/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.layers.maptools;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.esa.nest.dat.layers.maptools.MapToolsLayer;
import org.esa.snap.util.DialogUtils;

public class MapToolsOptions {
    private final JCheckBox northArrow = new JCheckBox("Show North Arrow", true);
    private final JCheckBox latLonGrid = new JCheckBox("Show Lat/lon Grid", false);
    private final JCheckBox lookDirection = new JCheckBox("Show Look Direction", false);
    private final JCheckBox mapOverview = new JCheckBox("Show Map Overview", false);
    private final JCheckBox info = new JCheckBox("Show Product Info", false);
    private final JCheckBox scale = new JCheckBox("Show Scale", true);
    private final JCheckBox processedByLogo = new JCheckBox("Show Logo", true);
    private MapToolsLayer layer = null;

    public MapToolsOptions() {
        ActionListener updateStateListenser = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapToolsOptions.this.updateState();
            }
        };
        this.northArrow.addActionListener(updateStateListenser);
        this.latLonGrid.addActionListener(updateStateListenser);
        this.lookDirection.addActionListener(updateStateListenser);
        this.mapOverview.addActionListener(updateStateListenser);
        this.info.addActionListener(updateStateListenser);
        this.scale.addActionListener(updateStateListenser);
        this.processedByLogo.addActionListener(updateStateListenser);
    }

    public void setLayer(MapToolsLayer layer) {
        this.layer = layer;
    }

    public boolean showNorthArrow() {
        return this.northArrow.isSelected();
    }

    public boolean showLookDirection() {
        return this.lookDirection.isSelected();
    }

    public boolean showLatLonGrid() {
        return this.latLonGrid.isSelected();
    }

    public boolean showMapOverview() {
        return this.mapOverview.isSelected();
    }

    public boolean showInfo() {
        return this.info.isSelected();
    }

    public boolean showScale() {
        return this.scale.isSelected();
    }

    public boolean showNestLogo() {
        return this.processedByLogo.isSelected();
    }

    public JPanel createPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        panel.add((Component)this.northArrow, gbc);
        ++gbc.gridy;
        panel.add((Component)this.lookDirection, gbc);
        ++gbc.gridy;
        panel.add((Component)this.scale, gbc);
        ++gbc.gridy;
        panel.add((Component)this.processedByLogo, gbc);
        return panel;
    }

    private void updateState() {
        if (this.layer != null) {
            this.layer.regenerate();
        }
    }
}

