/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.layers.maptools.components;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.apache.commons.math3.util.FastMath;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.nest.dat.layers.ScreenPixelConverter;
import org.esa.nest.dat.layers.maptools.components.MapToolsComponent;
import org.esa.snap.util.ResourceUtils;

public class CompassComponent
implements MapToolsComponent {
    private static final ImageIcon roseIcon = ResourceUtils.LoadIcon((String)"org/esa/nest/icons/compass_rose.png");
    private final BufferedImage image = new BufferedImage(roseIcon.getIconWidth(), roseIcon.getIconHeight(), 6);
    private final PixelPos tail;
    private final PixelPos head;
    private final PixelPos point1;
    private double angle;
    private final int rasterWidth;
    private final int rasterHeight;
    private static final double marginPct = 0.05;
    private final int margin;

    public CompassComponent(RasterDataNode raster) {
        Graphics2D g = this.image.createGraphics();
        g.drawImage(roseIcon.getImage(), null, null);
        this.rasterWidth = raster.getRasterWidth();
        this.rasterHeight = raster.getRasterHeight();
        this.margin = (int)((double)Math.min(this.rasterWidth, this.rasterHeight) * 0.05);
        this.point1 = new PixelPos((float)this.margin, (float)this.margin);
        GeoCoding geoCoding = raster.getGeoCoding();
        if (geoCoding == null) {
            this.tail = this.head = this.point1;
            this.angle = Double.NaN;
            return;
        }
        GeoPos point1Geo = geoCoding.getGeoPos(this.point1, null);
        GeoPos point2Geo = geoCoding.getGeoPos(new PixelPos((float)(this.rasterWidth / 2), (float)(this.rasterHeight / 2)), null);
        PixelPos point2 = geoCoding.getPixelPos(new GeoPos(point2Geo.getLat(), point1Geo.getLon()), null);
        double op = this.point1.x - point2.x;
        double hyp = FastMath.hypot((double)op, (double)(this.point1.y - point2.y));
        this.angle = FastMath.asin((double)(op / hyp));
        if (point1Geo.getLat() < point2Geo.getLat()) {
            this.tail = this.point1;
            this.head = point2;
            this.angle += Math.PI;
        } else {
            this.tail = point2;
            this.head = this.point1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Graphics2D graphics, ScreenPixelConverter screenPixel) {
        if (Double.isNaN(this.angle)) {
            return;
        }
        AffineTransform transformSave = graphics.getTransform();
        try {
            AffineTransform transform = screenPixel.getImageTransform(transformSave);
            double scale = 0.1 * (double)this.rasterWidth / (double)this.image.getWidth();
            transform.translate(this.point1.x, this.point1.y);
            transform.scale(scale, scale);
            transform.rotate(this.angle);
            graphics.drawRenderedImage(this.image, transform);
        }
        finally {
            graphics.setTransform(transformSave);
        }
    }
}

