/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.layers.maptools.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.nest.dat.graphics.GraphicText;
import org.esa.nest.dat.layers.ScreenPixelConverter;
import org.esa.nest.dat.layers.maptools.components.MapToolsComponent;
import org.esa.snap.datamodel.AbstractMetadata;

public class InfoComponent
implements MapToolsComponent {
    private final double[] pts;
    private final double[] vpts;
    private final ArrayList<String> infoList = new ArrayList();
    private int maxLength;
    private static final Font font = new Font("Arial", 0, 12);

    public InfoComponent(RasterDataNode raster) {
        int rasterWidth;
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)raster.getProduct());
        int startPosX = rasterWidth = raster.getRasterWidth();
        int startPosY = 100;
        this.pts = new double[]{startPosX, 100.0};
        this.vpts = new double[this.pts.length];
        this.infoList.add(absRoot.getAttributeString("PRODUCT"));
        this.infoList.add(absRoot.getAttributeString("first_line_time"));
        this.infoList.add(absRoot.getAttributeString("MISSION") + ' ' + absRoot.getAttributeString("ACQUISITION_MODE") + ' ' + absRoot.getAttributeString("PRODUCT_TYPE"));
        for (String str : this.infoList) {
            if (str.length() <= this.maxLength) continue;
            this.maxLength = str.length();
        }
    }

    @Override
    public void render(Graphics2D g, ScreenPixelConverter screenPixel) {
        if (this.pts == null) {
            return;
        }
        screenPixel.pixelToScreen(this.pts, this.vpts);
        Point[] pt = ScreenPixelConverter.arrayToPoints(this.vpts);
        g.setFont(font);
        int w = g.getFontMetrics().charWidth('B');
        int h = g.getFontMetrics().getHeight();
        int x = pt[0].x - w * (this.maxLength + 5);
        int y = pt[0].y;
        for (String str : this.infoList) {
            GraphicText.outlineText(g, Color.YELLOW, str, x, y);
            y += h;
        }
    }
}

