/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.layers.maptools.components;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.nest.dat.layers.ScreenPixelConverter;
import org.esa.nest.dat.layers.maptools.components.MapToolsComponent;
import org.esa.snap.util.ResourceUtils;

public class LogoComponent
implements MapToolsComponent {
    private static final ImageIcon procNestIcon = ResourceUtils.LoadIcon((String)"org/esa/nest/icons/proc_nest.png");
    private final BufferedImage image;
    private static final double marginPct = 0.05;
    private final double scale;
    private final Point point;

    public LogoComponent(RasterDataNode raster) {
        if (procNestIcon != null) {
            this.image = new BufferedImage(procNestIcon.getIconWidth(), procNestIcon.getIconHeight(), 6);
            Graphics2D g = this.image.createGraphics();
            g.drawImage(procNestIcon.getImage(), null, null);
            int rasterWidth = raster.getRasterWidth();
            int rasterHeight = raster.getRasterHeight();
            int size = Math.min(rasterWidth, rasterHeight);
            int margin = (int)((double)size * 0.05);
            this.scale = 0.1 * (double)size / (double)this.image.getWidth();
            this.point = new Point((int)((double)rasterWidth - (double)this.image.getWidth() * this.scale - (double)margin), (int)((double)rasterHeight - (double)this.image.getHeight() * this.scale - (double)margin));
        } else {
            this.image = null;
            this.scale = 0.0;
            this.point = new Point(0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Graphics2D graphics, ScreenPixelConverter screenPixel) {
        AffineTransform transformSave = graphics.getTransform();
        try {
            AffineTransform transform = screenPixel.getImageTransform(transformSave);
            transform.translate(this.point.x, this.point.y);
            transform.scale(this.scale, this.scale);
            graphics.drawRenderedImage(this.image, transform);
        }
        finally {
            graphics.setTransform(transformSave);
        }
    }
}

