/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.layers.maptools.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.nest.dat.graphics.GraphicShape;
import org.esa.nest.dat.layers.ScreenPixelConverter;
import org.esa.nest.dat.layers.maptools.components.MapToolsComponent;
import org.esa.snap.datamodel.AbstractMetadata;

public class LookDirectionComponent
implements MapToolsComponent {
    private boolean valid = true;
    private final List<Point> tails = new ArrayList<Point>();
    private final List<Point> heads = new ArrayList<Point>();
    private static final BasicStroke thickStroke = new BasicStroke(4.0f);
    private static final BasicStroke thinStroke = new BasicStroke(2.0f);

    public LookDirectionComponent(RasterDataNode raster) {
        try {
            int arrowLength = (int)((double)raster.getSceneRasterWidth() * 0.05);
            Product product = raster.getProduct();
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
            MetadataElement lookDirectionListElem = absRoot.getElement("Look_Direction_List");
            if (lookDirectionListElem != null) {
                MetadataElement[] dirDataElems;
                GeoCoding geoCoding = raster.getGeoCoding();
                for (MetadataElement dirElem : dirDataElems = lookDirectionListElem.getElements()) {
                    float tailLat = (float)dirElem.getAttributeDouble("tail_lat");
                    float tailLon = (float)dirElem.getAttributeDouble("tail_lon");
                    float headLat = (float)dirElem.getAttributeDouble("head_lat");
                    float headLon = (float)dirElem.getAttributeDouble("head_lon");
                    PixelPos tailPix = geoCoding.getPixelPos(new GeoPos(tailLat, tailLon), null);
                    PixelPos headPix = geoCoding.getPixelPos(new GeoPos(headLat, headLon), null);
                    double m = (headPix.getY() - tailPix.getY()) / (headPix.getX() - tailPix.getX());
                    int length = arrowLength;
                    if (tailPix.getX() > headPix.getX()) {
                        length = -length;
                    }
                    int x = (int)tailPix.getX() + length;
                    int y = (int)(m * (double)x + (headPix.getY() - m * headPix.getX()));
                    this.tails.add(new Point((int)tailPix.getX(), (int)tailPix.getY()));
                    this.heads.add(new Point(x, y));
                }
            } else {
                String pass = absRoot.getAttributeString("PASS", null);
                String antennaPointing = absRoot.getAttributeString("antenna_pointing", null);
                if (!antennaPointing.equalsIgnoreCase("right")) {
                    antennaPointing = "left";
                }
                int x = 0;
                int length = arrowLength;
                if (pass.equalsIgnoreCase("DESCENDING") && antennaPointing.equalsIgnoreCase("right") || pass.equalsIgnoreCase("ASCENDING") && antennaPointing.equalsIgnoreCase("left")) {
                    x = raster.getRasterWidth();
                    length = -length;
                }
                int y = 0;
                this.tails.add(new Point(x, y));
                this.heads.add(new Point(x + length, y));
                y = raster.getSceneRasterHeight() / 2;
                this.tails.add(new Point(x, y));
                this.heads.add(new Point(x + length, y));
                y = raster.getSceneRasterHeight();
                this.tails.add(new Point(x, y));
                this.heads.add(new Point(x + length, y));
            }
        }
        catch (Exception e) {
            this.valid = false;
        }
    }

    @Override
    public void render(Graphics2D g, ScreenPixelConverter screenPixel) {
        if (!this.valid) {
            return;
        }
        for (int i = 0; i < this.tails.size(); ++i) {
            g.setColor(Color.BLACK);
            g.setStroke(thickStroke);
            GraphicShape.drawArrow(g, screenPixel, (int)this.tails.get(i).getX(), (int)this.tails.get(i).getY(), (int)this.heads.get(i).getX(), (int)this.heads.get(i).getY());
            g.setColor(Color.CYAN);
            g.setStroke(thinStroke);
            GraphicShape.drawArrow(g, screenPixel, (int)this.tails.get(i).getX(), (int)this.tails.get(i).getY(), (int)this.heads.get(i).getX(), (int)this.heads.get(i).getY());
        }
    }
}

