/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.layers.maptools.components;

import java.awt.Graphics2D;
import org.apache.commons.math3.util.FastMath;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.nest.dat.layers.ArrowOverlay;
import org.esa.nest.dat.layers.ScreenPixelConverter;
import org.esa.nest.dat.layers.maptools.components.MapToolsComponent;
import org.esa.snap.eo.GeoUtils;

public class NorthArrowComponent
implements MapToolsComponent {
    private double angle;
    private ArrowOverlay arrow;

    public NorthArrowComponent(RasterDataNode raster) {
        int rasterWidth = raster.getRasterWidth();
        int rasterHeight = raster.getRasterHeight();
        int margin = (int)(0.02 * FastMath.hypot((double)rasterWidth, (double)rasterHeight));
        PixelPos point1 = new PixelPos((float)margin, (float)margin);
        GeoCoding geoCoding = raster.getGeoCoding();
        if (geoCoding == null) {
            this.angle = Double.NaN;
            return;
        }
        GeoPos point1Geo = geoCoding.getGeoPos(point1, null);
        GeoPos centrePointGeo = geoCoding.getGeoPos(new PixelPos((float)(rasterWidth / 2), (float)(rasterHeight / 2)), null);
        PixelPos point2 = geoCoding.getPixelPos(new GeoPos(centrePointGeo.getLat(), point1Geo.getLon()), null);
        if (Double.isNaN(point2.getX()) || Double.isNaN(point2.getY())) {
            point2 = new PixelPos((float)(rasterWidth / 2), (float)(rasterHeight / 2));
            PixelPos oldPoint1 = point1;
            GeoPos oldPoint1Geo = geoCoding.getGeoPos(oldPoint1, null);
            point1 = geoCoding.getPixelPos(new GeoPos(oldPoint1Geo.getLat(), centrePointGeo.getLon()), null);
        }
        double op = point1.x - point2.x;
        double hyp = FastMath.hypot((double)op, (double)(point1.y - point2.y));
        this.angle = FastMath.asin((double)(op / hyp));
        if (point1Geo.getLat() < centrePointGeo.getLat()) {
            this.angle += Math.PI;
        }
        GeoPos x5Geo = geoCoding.getGeoPos(new PixelPos((float)((int)((double)margin * 1.5)), (float)margin), null);
        GeoUtils.DistanceHeading dist = GeoUtils.vincenty_inverse((double)point1Geo.getLon(), (double)point1Geo.getLat(), (double)x5Geo.getLon(), (double)x5Geo.getLat());
        GeoUtils.LatLonHeading coord = GeoUtils.vincenty_direct((double)point1Geo.getLon(), (double)point1Geo.getLat(), (double)dist.distance, (double)this.angle);
        PixelPos point3 = geoCoding.getPixelPos(new GeoPos((float)coord.lat, (float)coord.lon), null);
        PixelPos dispTail = point1;
        PixelPos dispHead = point3;
        this.arrow = new ArrowOverlay((int)dispTail.getX(), (int)dispTail.getY(), (int)dispHead.getX(), (int)dispHead.getY());
        this.arrow.setText("N");
    }

    @Override
    public void render(Graphics2D g, ScreenPixelConverter screenPixel) {
        if (Double.isNaN(this.angle)) {
            return;
        }
        this.arrow.drawArrow(g, screenPixel);
    }
}

