/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.layers.maptools.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.nest.dat.graphics.GraphicText;
import org.esa.nest.dat.layers.ScreenPixelConverter;
import org.esa.nest.dat.layers.maptools.components.MapToolsComponent;
import org.esa.snap.eo.GeoUtils;

public class ScaleComponent
implements MapToolsComponent {
    private static final double marginPct = 0.05;
    private final int margin;
    private static final int tick = 5;
    private static final int h = 3;
    private final double[] pts;
    private final double[] vpts;
    private final BasicStroke stroke = new BasicStroke(1.0f);
    private boolean use500k;
    private boolean use100k;
    private boolean use50k;
    private boolean use10k;
    private boolean use5k;
    private boolean use1k;

    public ScaleComponent(RasterDataNode raster) {
        int rasterWidth = raster.getRasterWidth();
        int rasterHeight = raster.getRasterHeight();
        int thirdWidth = rasterWidth / 3;
        this.margin = (int)((double)Math.min(rasterWidth, rasterHeight) * 0.05);
        int length = 100;
        GeoCoding geoCoding = raster.getGeoCoding();
        if (geoCoding == null) {
            this.vpts = null;
            this.pts = null;
            return;
        }
        PixelPos startPix = new PixelPos((float)(0 + this.margin), (float)(rasterHeight - this.margin));
        PixelPos endPix = new PixelPos((float)(this.margin + 100), (float)(rasterHeight - this.margin));
        GeoPos startGeo = geoCoding.getGeoPos(startPix, null);
        GeoPos endGeo = geoCoding.getGeoPos(endPix, null);
        GeoUtils.DistanceHeading heading = GeoUtils.vincenty_inverse((double)startGeo.getLon(), (double)startGeo.getLat(), (double)endGeo.getLon(), (double)endGeo.getLat());
        GeoUtils.LatLonHeading LatLon = GeoUtils.vincenty_direct((double)startGeo.getLon(), (double)startGeo.getLat(), (double)1000.0, (double)heading.heading1);
        PixelPos pix1K = geoCoding.getPixelPos(new GeoPos((float)LatLon.lat, (float)LatLon.lon), null);
        LatLon = GeoUtils.vincenty_direct((double)startGeo.getLon(), (double)startGeo.getLat(), (double)2000.0, (double)heading.heading1);
        PixelPos pix2K = geoCoding.getPixelPos(new GeoPos((float)LatLon.lat, (float)LatLon.lon), null);
        LatLon = GeoUtils.vincenty_direct((double)startGeo.getLon(), (double)startGeo.getLat(), (double)3000.0, (double)heading.heading1);
        PixelPos pix3K = geoCoding.getPixelPos(new GeoPos((float)LatLon.lat, (float)LatLon.lon), null);
        LatLon = GeoUtils.vincenty_direct((double)startGeo.getLon(), (double)startGeo.getLat(), (double)4000.0, (double)heading.heading1);
        PixelPos pix4K = geoCoding.getPixelPos(new GeoPos((float)LatLon.lat, (float)LatLon.lon), null);
        LatLon = GeoUtils.vincenty_direct((double)startGeo.getLon(), (double)startGeo.getLat(), (double)5000.0, (double)heading.heading1);
        PixelPos pix5K = geoCoding.getPixelPos(new GeoPos((float)LatLon.lat, (float)LatLon.lon), null);
        LatLon = GeoUtils.vincenty_direct((double)startGeo.getLon(), (double)startGeo.getLat(), (double)10000.0, (double)heading.heading1);
        PixelPos pix10K = geoCoding.getPixelPos(new GeoPos((float)LatLon.lat, (float)LatLon.lon), null);
        LatLon = GeoUtils.vincenty_direct((double)startGeo.getLon(), (double)startGeo.getLat(), (double)50000.0, (double)heading.heading1);
        PixelPos pix50K = geoCoding.getPixelPos(new GeoPos((float)LatLon.lat, (float)LatLon.lon), null);
        LatLon = GeoUtils.vincenty_direct((double)startGeo.getLon(), (double)startGeo.getLat(), (double)100000.0, (double)heading.heading1);
        PixelPos pix100K = geoCoding.getPixelPos(new GeoPos((float)LatLon.lat, (float)LatLon.lon), null);
        LatLon = GeoUtils.vincenty_direct((double)startGeo.getLon(), (double)startGeo.getLat(), (double)200000.0, (double)heading.heading1);
        PixelPos pix500K = geoCoding.getPixelPos(new GeoPos((float)LatLon.lat, (float)LatLon.lon), null);
        this.use500k = pix500K.getX() < (double)thirdWidth;
        this.use100k = pix100K.getX() < (double)thirdWidth;
        this.use50k = pix50K.getX() < (double)thirdWidth;
        this.use10k = pix10K.getX() < (double)thirdWidth;
        this.use5k = pix5K.getX() < (double)(rasterWidth / 2);
        this.use1k = pix1K.getX() < (double)rasterWidth;
        this.pts = new double[]{startPix.getX(), startPix.getY(), pix1K.getX(), pix1K.getY(), pix2K.getX(), pix2K.getY(), pix3K.getX(), pix3K.getY(), pix4K.getX(), pix4K.getY(), pix5K.getX(), pix5K.getY(), pix10K.getX(), pix10K.getY(), pix50K.getX(), pix50K.getY(), pix100K.getX(), pix100K.getY(), pix500K.getX(), pix500K.getY()};
        this.vpts = new double[this.pts.length];
    }

    @Override
    public void render(Graphics2D g, ScreenPixelConverter screenPixel) {
        if (this.pts == null || !this.use1k) {
            return;
        }
        screenPixel.pixelToScreen(this.pts, this.vpts);
        Point[] pt = ScreenPixelConverter.arrayToPoints(this.vpts);
        int y = pt[0].y;
        g.setStroke(this.stroke);
        g.setColor(Color.YELLOW);
        g.drawLine(pt[0].x, y - 3, pt[0].x, y - 3 - 5);
        g.drawLine(pt[1].x, y - 3, pt[1].x, y - 3 - 5);
        if (this.use5k) {
            g.drawLine(pt[5].x, y - 3, pt[5].x, y - 3 - 5);
        }
        if (this.use10k) {
            g.drawLine(pt[6].x, y - 3, pt[6].x, y - 3 - 5);
        }
        if (this.use50k) {
            g.drawLine(pt[7].x, y - 3, pt[7].x, y - 3 - 5);
        }
        if (this.use100k) {
            g.drawLine(pt[8].x, y - 3, pt[8].x, y - 3 - 5);
        }
        if (this.use500k) {
            g.drawLine(pt[9].x, y - 3, pt[9].x, y - 3 - 5);
        }
        GraphicText.outlineText(g, Color.YELLOW, "1km", pt[1].x + 2, y - 3 - 5);
        if (this.use5k) {
            GraphicText.outlineText(g, Color.YELLOW, "5km", pt[5].x + 2, y - 3 - 5);
        }
        if (this.use10k) {
            GraphicText.outlineText(g, Color.YELLOW, "10km", pt[6].x + 2, y - 3 - 5);
        }
        if (this.use50k) {
            GraphicText.outlineText(g, Color.YELLOW, "50km", pt[7].x + 2, y - 3 - 5);
        }
        if (this.use100k) {
            GraphicText.outlineText(g, Color.YELLOW, "100km", pt[8].x + 2, y - 3 - 5);
        }
        if (this.use500k) {
            GraphicText.outlineText(g, Color.YELLOW, "500km", pt[9].x + 2, y - 3 - 5);
        }
        g.setColor(Color.BLACK);
        g.fillRect(pt[0].x, y - 3, pt[1].x - pt[0].x, 3);
        if (this.use5k) {
            g.fillRect(pt[2].x, y - 3, pt[3].x - pt[2].x, 3);
            g.fillRect(pt[4].x, y - 3, pt[5].x - pt[4].x, 3);
        }
        g.setColor(Color.WHITE);
        if (this.use5k) {
            g.fillRect(pt[1].x, y - 3, pt[2].x - pt[1].x, 3);
            g.fillRect(pt[3].x, y - 3, pt[4].x - pt[3].x, 3);
        }
        if (this.use10k) {
            g.fillRect(pt[5].x, y - 3, pt[6].x - pt[5].x, 3);
        }
        if (this.use100k) {
            g.fillRect(pt[7].x, y - 3, pt[8].x - pt[7].x, 3);
        }
        g.setColor(Color.YELLOW);
        if (this.use500k) {
            g.drawRect(pt[0].x, y - 3, pt[9].x - pt[0].x, 3);
        } else if (this.use100k) {
            g.drawRect(pt[0].x, y - 3, pt[8].x - pt[0].x, 3);
        } else if (this.use50k) {
            g.drawRect(pt[0].x, y - 3, pt[7].x - pt[0].x, 3);
        } else if (this.use10k) {
            g.drawRect(pt[0].x, y - 3, pt[6].x - pt[0].x, 3);
        } else if (this.use5k) {
            g.drawRect(pt[0].x, y - 3, pt[5].x - pt[0].x, 3);
        } else {
            g.drawRect(pt[0].x, y - 3, pt[1].x - pt[0].x, 3);
        }
    }
}

