/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.plugins;

import com.bc.ceres.core.runtime.internal.Platform;
import com.bc.ceres.swing.UriLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import org.esa.beam.framework.ui.command.CommandAdapter;
import org.esa.beam.framework.ui.command.CommandEvent;
import org.esa.beam.framework.ui.command.CommandListener;
import org.esa.beam.framework.ui.command.CommandManager;
import org.esa.beam.framework.ui.command.ExecCommand;
import org.esa.beam.util.PropertyMap;
import org.esa.beam.util.SystemUtils;
import org.esa.beam.util.VersionChecker;
import org.esa.beam.visat.AbstractVisatPlugIn;
import org.esa.beam.visat.VisatApp;
import org.esa.snap.util.ResourceUtils;
import org.esa.snap.util.VersionUtil;

public class VersionCheckerVPI
extends AbstractVisatPlugIn {
    private static final String MESSAGE_BOX_TITLE = "Software Version Check";
    private static final int DELAY_MILLIS = 5000;
    private static String remoteVersionUrl = "http://www.array.ca/nest-web/";
    private static final String NEST_WEBSITE = "http://www.array.ca/nest";
    private static String remoteVersionStr;

    public void start(VisatApp visatApp) {
        remoteVersionUrl = VersionUtil.getRemoteVersionURL((String)"DAT");
        Timer timer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersionCheckerVPI.runAuto();
            }
        });
        timer.setRepeats(false);
        timer.start();
        CommandAdapter versinoCheckerAction = new CommandAdapter(){

            public void actionPerformed(CommandEvent event) {
                VersionCheckerVPI.runManual();
            }
        };
        CommandManager commandManager = visatApp.getCommandManager();
        ExecCommand versionCheckerCommand = commandManager.createExecCommand("checkForUpdate", (CommandListener)versinoCheckerAction);
        versionCheckerCommand.setText("Check for New Release...");
        versionCheckerCommand.setShortDescription("Checks for a new " + VisatApp.getApp().getAppName() + " release");
        versionCheckerCommand.setParent("help");
        versionCheckerCommand.setPlaceAfter("showUpdateDialog");
        versionCheckerCommand.setPlaceBefore("about");
    }

    public void updateComponentTreeUI() {
    }

    private static void runManual() {
        VersionCheckerVPI.run(false, true);
    }

    private static void runAuto() {
        boolean prompt;
        boolean bl = prompt = !VersionCheckerVPI.isVersionCheckQuestionSuppressed();
        if (VersionCheckerVPI.isVersionCheckEnabled()) {
            VersionCheckerVPI.run(true, prompt);
        }
    }

    private static void run(final boolean auto, final boolean prompt) {
        SwingWorker<Integer, Integer> swingWorker = new SwingWorker<Integer, Integer>(){

            @Override
            protected Integer doInBackground() throws Exception {
                return new Integer(VersionCheckerVPI.getVersionStatus());
            }

            @Override
            public void done() {
                try {
                    VersionCheckerVPI.showVersionStatus(auto, prompt, (Integer)this.get());
                }
                catch (InterruptedException e) {
                    VersionCheckerVPI.showVersionCheckFailedMessage(auto, prompt, e);
                }
                catch (ExecutionException e) {
                    VersionCheckerVPI.showVersionCheckFailedMessage(auto, prompt, e.getCause());
                }
            }
        };
        swingWorker.execute();
    }

    private static int getVersionStatus() throws IOException {
        VersionChecker versionChecker = new VersionChecker();
        String localVersion = "VERSION " + System.getProperty(SystemUtils.getApplicationContextId() + ".version");
        localVersion = localVersion.replace("beta", "").trim();
        versionChecker.setLocalVersion(localVersion);
        versionChecker.setRemoteVersionUrlString(remoteVersionUrl);
        remoteVersionStr = versionChecker.getRemoteVersion();
        return versionChecker.compareVersions();
    }

    private static void showVersionStatus(boolean auto, boolean prompt, int versionStatus) {
        if (versionStatus < 0) {
            VersionCheckerVPI.showOutOfDateMessage();
        } else {
            VersionCheckerVPI.showUpToDateMessage(auto, prompt);
        }
    }

    private static void showOutOfDateMessage() {
        VisatApp.getApp().getLogger().info("version check performed, application is antiquated");
        try {
            UriLabel beamHomeLabel = new UriLabel(new URI(NEST_WEBSITE));
        }
        catch (URISyntaxException e) {
            JLabel beamHomeLabel = new JLabel(NEST_WEBSITE);
            beamHomeLabel.setForeground(Color.BLUE.darker());
        }
        Object[] message = new Object[]{"A new software version is available. " + remoteVersionStr + '\n' + "Would you like to update your software with the latest features and bug fixes?\n"};
        int answer = JOptionPane.showConfirmDialog((Component)VisatApp.getApp().getMainFrame(), message, MESSAGE_BOX_TITLE, 0, 3);
        if (answer == 0) {
            VersionCheckerVPI.runAutoUpdate();
        }
    }

    private static void runAutoUpdate() {
        String command;
        File autoUpdateExe;
        File homeFolder = ResourceUtils.findHomeFolder();
        Platform platform = Platform.getCurrentPlatform();
        if (platform.getId() == Platform.ID.win) {
            autoUpdateExe = new File(homeFolder, "bin" + File.separator + "updater.exe");
            File program = new File(homeFolder, "bin" + File.separator + "exec1.bat");
            String arg = '\"' + autoUpdateExe.getParent() + "\" " + autoUpdateExe.getName();
            command = '\"' + program.getAbsolutePath() + "\" " + arg;
        } else if (platform.getId() == Platform.ID.macosx) {
            autoUpdateExe = new File(homeFolder, "bin" + File.separator + "updater.app");
            command = autoUpdateExe.getAbsolutePath();
        } else {
            autoUpdateExe = new File(homeFolder, "bin" + File.separator + "updater.sh");
            command = autoUpdateExe.getAbsolutePath();
        }
        if (autoUpdateExe.exists()) {
            try {
                VersionCheckerVPI.externalExecute(command);
                System.exit(0);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            VisatApp.getApp().showErrorDialog("Unable to locate AutoUpdate " + autoUpdateExe.getAbsolutePath());
        }
    }

    private static void externalExecute(final String command) {
        Thread worker = new Thread(){

            @Override
            public void run() {
                try {
                    Process proc = Runtime.getRuntime().exec(command);
                    VersionCheckerVPI.outputTextBuffers(new BufferedReader(new InputStreamReader(proc.getInputStream())));
                    boolean hasErrors = VersionCheckerVPI.outputTextBuffers(new BufferedReader(new InputStreamReader(proc.getErrorStream())));
                    System.out.println(hasErrors);
                }
                catch (Throwable e) {
                    VisatApp.getApp().showErrorDialog(e.getMessage());
                }
            }
        };
        worker.start();
    }

    private static boolean outputTextBuffers(BufferedReader in) throws IOException {
        char c;
        boolean hasData = false;
        while ((c = (char)in.read()) != '\uffffffff' && c != '\uffff') {
            System.out.print(c);
            hasData = true;
        }
        return hasData;
    }

    private static void showUpToDateMessage(boolean auto, boolean prompt) {
        VisatApp.getApp().getLogger().info("version check performed, application is up-to-date");
        if (prompt && !auto) {
            JOptionPane.showMessageDialog((Component)VisatApp.getApp().getMainFrame(), "Your " + VisatApp.getApp().getAppName() + " software is up-to-date.\n", MESSAGE_BOX_TITLE, 1);
        }
    }

    private static void showVersionCheckFailedMessage(boolean auto, boolean prompt, Throwable t) {
        VisatApp.getApp().getLogger().severe("I/O error: " + t.getMessage());
        if (prompt && !auto) {
            JOptionPane.showMessageDialog((Component)VisatApp.getApp().getMainFrame(), "The on-line version check failed,\nan I/O error occured.\n", MESSAGE_BOX_TITLE, 0);
        }
    }

    private static boolean isVersionCheckEnabled() {
        return true;
    }

    private static boolean isVersionCheckQuestionSuppressed() {
        return VersionCheckerVPI.getPreferences().getPropertyBool("visat.versionCheck.dontShow", false);
    }

    private static PropertyMap getPreferences() {
        return VisatApp.getApp().getPreferences();
    }
}

