/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.reports;

import com.lowagie.text.Anchor;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Chapter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Section;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;

public class PDFFormat {
    private static Font catFont = new Font(2, 18.0f, 1);
    private static Font redFont = new Font(2, 12.0f, 0, Color.RED);
    private static Font subFont = new Font(2, 16.0f, 1);
    private static Font smallBold = new Font(2, 12.0f, 1);
    private final Document document = new Document();

    public void PDFFormat(File file, String title, String subject) {
        try {
            PdfWriter.getInstance((Document)this.document, (OutputStream)new FileOutputStream(file));
            this.document.open();
            this.addPDFAttributes(title, subject);
            PDFFormat.addTitlePage(this.document);
            PDFFormat.addContent(this.document);
            this.document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addPDFAttributes(String title, String subject) {
        this.document.addTitle(title);
        this.document.addSubject(subject);
        this.document.addKeywords("NEST, SAR");
        this.document.addAuthor(System.getProperty("user.name"));
        this.document.addCreator("NEST");
        this.document.addCreationDate();
    }

    private static void addTitlePage(Document document) throws DocumentException {
        Paragraph preface = new Paragraph();
        PDFFormat.addEmptyLine(preface, 1);
        preface.add((Object)new Paragraph("Title of the document", catFont));
        PDFFormat.addEmptyLine(preface, 1);
        preface.add((Object)new Paragraph("Report generated by: " + System.getProperty("user.name") + ", " + new Date(), smallBold));
        PDFFormat.addEmptyLine(preface, 3);
        preface.add((Object)new Paragraph("This document describes something which is very important ", smallBold));
        PDFFormat.addEmptyLine(preface, 8);
        preface.add((Object)new Paragraph("This document is a preliminary version and not subject to your license agreement or any other agreement with vogella.com ;-).", redFont));
        document.add((Element)preface);
        document.newPage();
    }

    private static void addContent(Document document) throws DocumentException {
        Anchor anchor = new Anchor("First Chapter", catFont);
        anchor.setName("First Chapter");
        Chapter catPart = new Chapter(new Paragraph((Phrase)anchor), 1);
        Paragraph subPara = new Paragraph("Subcategory 1", subFont);
        Section subCatPart = catPart.addSection(subPara);
        subCatPart.add((Object)new Paragraph("Hello"));
        subPara = new Paragraph("Subcategory 2", subFont);
        subCatPart = catPart.addSection(subPara);
        subCatPart.add((Object)new Paragraph("Paragraph 1"));
        subCatPart.add((Object)new Paragraph("Paragraph 2"));
        subCatPart.add((Object)new Paragraph("Paragraph 3"));
        PDFFormat.createList(subCatPart);
        Paragraph paragraph = new Paragraph();
        PDFFormat.addEmptyLine(paragraph, 5);
        subCatPart.add((Object)paragraph);
        PDFFormat.createTable(subCatPart);
        document.add((Element)catPart);
        anchor = new Anchor("Second Chapter", catFont);
        anchor.setName("Second Chapter");
        catPart = new Chapter(new Paragraph((Phrase)anchor), 1);
        subPara = new Paragraph("Subcategory", subFont);
        subCatPart = catPart.addSection(subPara);
        subCatPart.add((Object)new Paragraph("This is a very important message"));
        document.add((Element)catPart);
    }

    private void allign(Document document) throws DocumentException {
        Paragraph paragraph = new Paragraph("This is right aligned text");
        paragraph.setAlignment(2);
        document.add((Element)paragraph);
        paragraph = new Paragraph("This is centered text");
        paragraph.setAlignment(1);
        document.add((Element)paragraph);
        paragraph = new Paragraph("This is left aligned text");
        paragraph.setAlignment(0);
        document.add((Element)paragraph);
        paragraph = new Paragraph("This is left aligned text with indentation");
        paragraph.setAlignment(0);
        paragraph.setIndentationLeft(50.0f);
        document.add((Element)paragraph);
    }

    private static void createTable(Section subCatPart) throws BadElementException {
        PdfPTable table = new PdfPTable(3);
        PdfPCell c1 = new PdfPCell(new Phrase("Table Header 1"));
        c1.setHorizontalAlignment(1);
        table.addCell(c1);
        c1 = new PdfPCell(new Phrase("Table Header 2"));
        c1.setHorizontalAlignment(1);
        table.addCell(c1);
        c1 = new PdfPCell(new Phrase("Table Header 3"));
        c1.setHorizontalAlignment(1);
        table.addCell(c1);
        table.setHeaderRows(1);
        table.addCell("1.0");
        table.addCell("1.1");
        table.addCell("1.2");
        table.addCell("2.1");
        table.addCell("2.2");
        table.addCell("2.3");
        subCatPart.add((Object)table);
    }

    private static void createList(Section subCatPart) {
        List list = new List(true, false, 10.0f);
        list.add((Object)new ListItem("First point"));
        list.add((Object)new ListItem("Second point"));
        list.add((Object)new ListItem("Third point"));
        subCatPart.add((Object)list);
    }

    private static void addEmptyLine(Paragraph paragraph, int number) {
        for (int i = 0; i < number; ++i) {
            paragraph.add((Object)new Paragraph(" "));
        }
    }
}

