/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.toolviews.Projects;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.dialogs.ProductSetDialog;
import org.esa.snap.util.ProductFunctions;
import org.esa.snap.util.XMLSupport;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public final class ProductSet {
    private List<File> fileList = new ArrayList<File>(10);
    private File productSetFile = null;
    private final File productSetFolder;
    private String name = null;

    ProductSet(File path) {
        this.productSetFolder = path.getParentFile();
        this.setName(path.getName());
    }

    public File[] getFileList() {
        return this.fileList.toArray(new File[this.fileList.size()]);
    }

    public void setFileList(File[] inFileList) {
        this.fileList.clear();
        this.fileList.addAll(Arrays.asList(inFileList));
    }

    public File getFile() {
        return this.productSetFile;
    }

    boolean addProduct(File file) {
        if (ProductFunctions.isValidProduct((File)file)) {
            this.fileList.add(file);
            return true;
        }
        return false;
    }

    public void setName(String newName) {
        if (this.name == null || !this.name.equals(newName)) {
            if (this.productSetFile != null && this.productSetFile.exists()) {
                this.productSetFile.delete();
            }
            if (!newName.toLowerCase().endsWith(".xml")) {
                newName = newName + ".xml";
            }
            this.name = newName;
            this.productSetFile = new File(this.productSetFolder, this.name);
        }
    }

    public String getName() {
        return this.name;
    }

    public void Save() {
        Element root = new Element("ProjectSet");
        Document doc = new Document(root);
        for (File file : this.fileList) {
            Element fileElem = new Element("product");
            fileElem.setAttribute("path", file.getAbsolutePath());
            root.addContent((Content)fileElem);
        }
        XMLSupport.SaveXML((Document)doc, (String)this.productSetFile.getAbsolutePath());
    }

    boolean Load(File file) {
        Document doc;
        if (!file.exists()) {
            return false;
        }
        try {
            doc = XMLSupport.LoadXML((String)file.getAbsolutePath());
        }
        catch (IOException e) {
            VisatApp.getApp().showErrorDialog(e.getMessage());
            return false;
        }
        this.fileList = new ArrayList<File>(10);
        Element root = doc.getRootElement();
        List children = root.getContent();
        for (Object aChild : children) {
            Element child;
            if (!(aChild instanceof Element) || !(child = (Element)aChild).getName().equals("product")) continue;
            Attribute attrib = child.getAttribute("path");
            this.fileList.add(new File(attrib.getValue()));
        }
        return true;
    }

    public static void OpenProductSet(File file) {
        ProductSet prodSet = new ProductSet(file);
        prodSet.Load(file);
        ProductSetDialog dlg = new ProductSetDialog("ProductSet", prodSet);
        dlg.show();
    }

    public static void AddProduct(File productSetFile, File inputFile) {
        ProductSet prodSet = new ProductSet(productSetFile);
        prodSet.Load(productSetFile);
        if (prodSet.addProduct(inputFile)) {
            ProductSetDialog dlg = new ProductSetDialog("ProductSet", prodSet);
            dlg.show();
        }
    }

    public static String GetListAsString(File productSetFile) {
        File[] fileList;
        ProductSet prodSet = new ProductSet(productSetFile);
        prodSet.Load(productSetFile);
        StringBuilder listStr = new StringBuilder(256);
        for (File file : fileList = prodSet.getFileList()) {
            listStr.append(file.getAbsolutePath());
            listStr.append('\n');
        }
        return listStr.toString();
    }
}

