/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.toolviews.Projects;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Observable;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.SwingWorker;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductManager;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeList;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.framework.ui.BasicApp;
import org.esa.beam.framework.ui.NewProductDialog;
import org.esa.beam.framework.ui.command.ExecCommand;
import org.esa.beam.framework.ui.product.ProductSubsetDialog;
import org.esa.beam.framework.ui.product.ProductTreeListener;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.dialogs.ProductSetDialog;
import org.esa.nest.dat.toolviews.Projects.ProductSet;
import org.esa.nest.dat.toolviews.Projects.ProjectFile;
import org.esa.nest.dat.toolviews.Projects.ProjectSubFolder;
import org.esa.nest.dat.utils.FileFolderUtils;
import org.esa.snap.dat.dialogs.PromptDialog;
import org.esa.snap.dat.graphbuilder.GraphBuilderDialog;
import org.esa.snap.util.ProductFunctions;
import org.esa.snap.util.ResourceUtils;
import org.esa.snap.util.XMLSupport;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class Project
extends Observable {
    private static final Project _instance = new Project();
    private File projectFolder = null;
    private File projectFile = null;
    private ProjectPTL productTreeListener = null;
    private ProjectSubFolder projectSubFolders = null;
    private static final boolean SAVE_PROJECT = true;
    private final Timer timer = new Timer();

    public static Project instance() {
        return _instance;
    }

    public void finalize() throws Throwable {
        this.timer.cancel();
        super.finalize();
    }

    void notifyEvent(boolean saveProject) {
        this.setChanged();
        this.notifyObservers();
        this.clearChanged();
        if (saveProject) {
            this.SaveProject();
        }
    }

    private static void showProjectsView() {
        ExecCommand command = VisatApp.getApp().getCommandManager().getExecCommand("org.esa.nest.dat.toolviews.Projects.ProjectsToolView.showCmd");
        command.execute();
    }

    public void CreateNewProject() {
        File file = FileFolderUtils.GetFilePath("Create Project", "xml", "xml", "myProject", "Project File", true);
        if (file != null) {
            String prjName = file.getName();
            String folderName = prjName.substring(0, prjName.lastIndexOf(46));
            File prjFolder = new File(file.getParentFile(), folderName);
            if (!prjFolder.exists()) {
                prjFolder.mkdir();
            }
            File newProjectFile = new File(prjFolder, prjName);
            this.initProject(newProjectFile);
            this.addExistingOpenedProducts();
            this.notifyEvent(true);
            Project.showProjectsView();
        }
    }

    private void addExistingOpenedProducts() {
        ProductManager prodman = VisatApp.getApp().getProductManager();
        int numProducts = prodman.getProductCount();
        for (int i = 0; i < numProducts; ++i) {
            this.addProductLink(prodman.getProduct(i));
        }
    }

    private static boolean findSubFolders(File currentFolder, ProjectSubFolder projSubFolder) {
        File[] files = currentFolder.listFiles();
        boolean hasProducts = false;
        if (files == null) {
            return false;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                ProjectSubFolder newProjFolder;
                if (f.getName().endsWith(".data") || !Project.findSubFolders(f, newProjFolder = projSubFolder.addSubFolder(f.getName()))) continue;
                hasProducts = true;
                continue;
            }
            if (projSubFolder.containsFile(f)) continue;
            boolean found = false;
            ProjectSubFolder.FolderType folderType = projSubFolder.getFolderType();
            if (folderType == ProjectSubFolder.FolderType.PRODUCT) {
                found = ProductFunctions.isValidProduct((File)f);
            } else if (folderType == ProjectSubFolder.FolderType.PRODUCTSET || folderType == ProjectSubFolder.FolderType.GRAPH) {
                found = f.getName().toLowerCase().endsWith(".xml");
            }
            if (!found) continue;
            hasProducts = true;
            ProjectFile newFile = new ProjectFile(f, f.getName());
            boolean added = projSubFolder.addFile(newFile);
            if (!added) continue;
            newFile.setFolderType(folderType);
        }
        return hasProducts;
    }

    public File getProjectFolder() {
        return this.projectFolder;
    }

    public File getProjectFile() {
        return this.projectFile;
    }

    String getProjectName() {
        String name = this.projectFile.getName();
        if (name.endsWith(".xml")) {
            return name.substring(0, name.length() - 4);
        }
        return name;
    }

    protected void initProject(File file) {
        String[] defaultFolders;
        if (this.productTreeListener == null && VisatApp.getApp() != null) {
            this.productTreeListener = new ProjectPTL();
            VisatApp.getApp().addProductTreeListener((ProductTreeListener)this.productTreeListener);
        }
        this.projectFile = file;
        this.projectFolder = file.getParentFile();
        this.projectSubFolders = new ProjectSubFolder(this.projectFolder, this.getProjectName(), false, ProjectSubFolder.FolderType.ROOT);
        this.projectSubFolders.setRemoveable(false);
        ProjectSubFolder productSetsFolder = new ProjectSubFolder(new File(this.projectFolder, "ProductSets"), "ProductSets", true, ProjectSubFolder.FolderType.PRODUCTSET);
        this.projectSubFolders.addSubFolder(productSetsFolder);
        productSetsFolder.setRemoveable(false);
        ProjectSubFolder graphsFolder = new ProjectSubFolder(new File(this.projectFolder, "Graphs"), "Graphs", true, ProjectSubFolder.FolderType.GRAPH);
        this.projectSubFolders.addSubFolder(graphsFolder);
        graphsFolder.setRemoveable(false);
        ProjectSubFolder productLinksFolder = this.projectSubFolders.addSubFolder("External Product Links");
        productLinksFolder.setRemoveable(false);
        productLinksFolder.setFolderType(ProjectSubFolder.FolderType.PRODUCT);
        ProjectSubFolder importedFolder = new ProjectSubFolder(new File(this.projectFolder, "Imported Products"), "Imported Products", true, ProjectSubFolder.FolderType.PRODUCT);
        this.projectSubFolders.addSubFolder(importedFolder);
        importedFolder.setRemoveable(false);
        ProjectSubFolder processedFolder = new ProjectSubFolder(new File(this.projectFolder, "Processed Products"), "Processed Products", true, ProjectSubFolder.FolderType.PRODUCT);
        this.projectSubFolders.addSubFolder(processedFolder);
        processedFolder.setRemoveable(false);
        this.refreshProjectTree();
        for (String folderName : defaultFolders = Project.getDefaultProjectFolders()) {
            ProjectSubFolder newFolder = processedFolder.addSubFolder(folderName);
            newFolder.setCreatedByUser(true);
        }
        if (VisatApp.getApp() != null) {
            VisatApp.getApp().getPreferences().setPropertyString("app.file.lastSaveDir", processedFolder.getPath().getAbsolutePath());
            VisatApp.getApp().updateState();
        }
        this.startUpdateTimer();
    }

    private static String[] getDefaultProjectFolders() {
        String defaultProjectFolders = System.getProperty("defaultProjectFolders");
        if (defaultProjectFolders == null) {
            defaultProjectFolders = "Calibrated Products, Coregistered Products, Orthorectified Products";
        }
        ArrayList<String> folderNames = new ArrayList<String>(5);
        StringTokenizer st = new StringTokenizer(defaultProjectFolders, ",");
        int length = st.countTokens();
        for (int i = 0; i < length; ++i) {
            folderNames.add(st.nextToken().trim());
        }
        return folderNames.toArray(new String[folderNames.size()]);
    }

    private void startUpdateTimer() {
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (Project.this.IsProjectOpen() && Project.this.refreshProjectTree()) {
                    Project.this.notifyEvent(true);
                }
            }
        }, 2000L, 5000L);
    }

    private void addProductLink(Product product) {
        ProjectSubFolder productLinksFolder;
        File productFile = product.getFileLocation();
        if (productFile == null) {
            return;
        }
        if (this.projectSubFolders.containsFile(productFile)) {
            return;
        }
        this.refreshProjectTree();
        if (this.projectSubFolders.containsFile(productFile)) {
            return;
        }
        ProjectSubFolder destFolder = productLinksFolder = this.projectSubFolders.addSubFolder("External Product Links");
        String[] formats = product.getProductReader().getReaderPlugIn().getFormatNames();
        if (formats.length > 0) {
            destFolder = productLinksFolder.addSubFolder(formats[0]);
        }
        ProjectFile newFile = new ProjectFile(productFile, product.getName());
        destFolder.addFile(newFile);
        newFile.setFolderType(ProjectSubFolder.FolderType.PRODUCT);
    }

    public boolean refreshProjectTree() {
        boolean found = false;
        ProjectSubFolder productSetsFolder = this.projectSubFolders.findFolder("ProductSets");
        if (Project.findSubFolders(productSetsFolder.getPath(), productSetsFolder)) {
            found = true;
        }
        Project.pruneNonExistantFiles(productSetsFolder);
        ProjectSubFolder graphsFolder = this.projectSubFolders.findFolder("Graphs");
        if (Project.findSubFolders(graphsFolder.getPath(), graphsFolder)) {
            found = true;
        }
        Project.pruneNonExistantFiles(graphsFolder);
        ProjectSubFolder importedFolder = this.projectSubFolders.findFolder("Imported Products");
        if (Project.findSubFolders(importedFolder.getPath(), importedFolder)) {
            found = true;
        }
        Project.pruneNonExistantFiles(importedFolder);
        ProjectSubFolder processedFolder = this.projectSubFolders.findFolder("Processed Products");
        if (Project.findSubFolders(processedFolder.getPath(), processedFolder)) {
            found = true;
        }
        Project.pruneNonExistantFiles(processedFolder);
        return found;
    }

    private static void pruneNonExistantFiles(ProjectSubFolder projSubFolder) {
        ProjectFile[] fileList = projSubFolder.getFileList().toArray(new ProjectFile[projSubFolder.getFileList().size()]);
        for (ProjectFile projFile : fileList) {
            File f = projFile.getFile();
            if (f.exists() && !f.getName().endsWith(".data")) continue;
            projSubFolder.removeFile(f);
        }
        for (ProjectSubFolder subFolder : projSubFolder.getSubFolders()) {
            Project.pruneNonExistantFiles(subFolder);
        }
    }

    public void createNewFolder(ProjectSubFolder subFolder) {
        PromptDialog dlg = new PromptDialog("New Folder", "Name", "", false);
        dlg.show();
        if (dlg.IsOK()) {
            ProjectSubFolder newFolder = subFolder.addSubFolder(dlg.getValue());
            newFolder.setCreatedByUser(true);
            if (subFolder == this.projectSubFolders || subFolder.isPhysical()) {
                newFolder.setPhysical(true);
            }
            this.notifyEvent(true);
        }
    }

    public void createNewProductSet(ProjectSubFolder subFolder) {
        String name = "ProductSet" + (subFolder.getFileList().size() + 1);
        ProductSet prodSet = new ProductSet(new File(subFolder.getPath(), name));
        ProductSetDialog dlg = new ProductSetDialog("New ProductSet", prodSet);
        dlg.show();
        if (dlg.IsOK()) {
            ProjectFile newFile = new ProjectFile(prodSet.getFile(), prodSet.getName());
            newFile.setFolderType(ProjectSubFolder.FolderType.PRODUCTSET);
            subFolder.addFile(newFile);
            this.notifyEvent(true);
            this.refreshProjectTree();
        }
    }

    public static void createNewGraph(ProjectSubFolder subFolder) {
        GraphBuilderDialog dialog = new GraphBuilderDialog((AppContext)VisatApp.getApp(), "Graph Builder", "graph_builder");
        dialog.show();
    }

    public static void openFile(ProjectSubFolder parentFolder, File file) {
        if (parentFolder.getFolderType() == ProjectSubFolder.FolderType.PRODUCTSET) {
            ProductSet.OpenProductSet(file);
        } else if (parentFolder.getFolderType() == ProjectSubFolder.FolderType.GRAPH) {
            GraphBuilderDialog dialog = new GraphBuilderDialog((AppContext)VisatApp.getApp(), "Graph Builder", "graph_builder");
            dialog.show();
            dialog.LoadGraph(file);
        } else if (parentFolder.getFolderType() == ProjectSubFolder.FolderType.PRODUCT) {
            VisatApp.getApp().openProduct(file);
        }
    }

    public static void openSubset(ProjectSubFolder parentFolder, File prodFile) {
        try {
            Product subsetProduct;
            Product product = ProductIO.readProduct((File)prodFile);
            if (product != null && (subsetProduct = Project.getProductSubset(product)) != null) {
                VisatApp.getApp().getProductManager().addProduct(subsetProduct);
            }
        }
        catch (Exception e) {
            VisatApp.getApp().showErrorDialog(e.getMessage());
        }
    }

    public void importSubset(ProjectSubFolder parentFolder, File prodFile) {
        ProductReader reader = ProductIO.getProductReaderForInput((Object)prodFile);
        if (reader != null) {
            ProjectSubFolder importedFolder = this.projectSubFolders.findFolder("Imported Products");
            try {
                Product product = reader.readProductNodes((Object)prodFile, null);
                Product subsetProduct = Project.getProductSubset(product);
                if (subsetProduct != null) {
                    File destFile = new File(importedFolder.getPath(), subsetProduct.getName());
                    this.writeProduct(subsetProduct, destFile);
                }
            }
            catch (Exception e) {
                VisatApp.getApp().showErrorDialog(e.getMessage());
            }
        }
    }

    private static Product getProductSubset(Product product) {
        BasicApp.MainFrame mainFrame;
        ProductSubsetDialog productSubsetDialog;
        if (product != null && (productSubsetDialog = new ProductSubsetDialog((Window)(mainFrame = VisatApp.getApp().getMainFrame()), product)).show() == 1) {
            ProductNodeList products = new ProductNodeList();
            products.add((ProductNode)product);
            NewProductDialog newProductDialog = new NewProductDialog((Window)mainFrame, products, 0, true);
            newProductDialog.setSubsetDef(productSubsetDialog.getProductSubsetDef());
            if (newProductDialog.show() == 1) {
                Product subsetProduct = newProductDialog.getResultProduct();
                if (subsetProduct == null || newProductDialog.getException() != null) {
                    VisatApp.getApp().showErrorDialog("The product subset could not be created:\n" + newProductDialog.getException().getMessage());
                } else {
                    return subsetProduct;
                }
            }
        }
        return null;
    }

    private void writeProduct(final Product product, final File destFile) {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                VisatApp.getApp().writeProduct(product, destFile, "BEAM-DIMAP");
                return null;
            }

            @Override
            public void done() {
                Project.this.refreshProjectTree();
                Project.this.notifyEvent(true);
            }
        };
        worker.execute();
    }

    public void ImportFileList(File[] productFilesToOpen) {
        if (!this.IsProjectOpen()) {
            this.CreateNewProject();
        }
        ProjectSubFolder importedFolder = this.projectSubFolders.findFolder("Imported Products");
        ImportProducts worker = new ImportProducts(productFilesToOpen, importedFolder);
        worker.execute();
        this.refreshProjectTree();
        this.notifyEvent(true);
    }

    public void deleteFolder(ProjectSubFolder parentFolder, ProjectSubFolder subFolder) {
        parentFolder.removeSubFolder(subFolder);
        this.notifyEvent(true);
    }

    public void clearFolder(ProjectSubFolder subFolder) {
        subFolder.clear();
        this.notifyEvent(true);
    }

    public void renameFolder(ProjectSubFolder subFolder) {
        PromptDialog dlg = new PromptDialog("Rename Folder", "Name", "", false);
        dlg.show();
        if (dlg.IsOK()) {
            subFolder.renameTo(dlg.getValue());
            this.notifyEvent(true);
        }
    }

    public void removeFile(ProjectSubFolder parentFolder, File file) {
        parentFolder.removeFile(file);
        if (parentFolder.getFolderType() == ProjectSubFolder.FolderType.PRODUCTSET || parentFolder.getFolderType() == ProjectSubFolder.FolderType.GRAPH) {
            file.delete();
        } else if (parentFolder.getFolderType() == ProjectSubFolder.FolderType.PRODUCT) {
            if (file.getName().endsWith(".dim")) {
                String pathStr = file.getAbsolutePath();
                File dataDir = new File(pathStr.substring(0, pathStr.length() - 4) + ".data");
                if (dataDir.exists()) {
                    ResourceUtils.deleteFile((File)dataDir);
                    file.delete();
                }
            } else {
                file.delete();
            }
        }
        this.notifyEvent(true);
    }

    public ProjectSubFolder getProjectSubFolders() {
        return this.projectSubFolders;
    }

    public void CloseProject() {
        this.projectSubFolders = null;
        this.notifyEvent(false);
        if (VisatApp.getApp() != null) {
            VisatApp.getApp().updateState();
        }
    }

    public boolean IsProjectOpen() {
        return this.projectSubFolders != null;
    }

    public void SaveProjectAs() {
        File file = FileFolderUtils.GetFilePath("Save Project", "XML", "xml", this.getProjectName(), "Project File", true);
        if (file == null) {
            return;
        }
        this.projectFile = file;
        this.projectFolder = file.getParentFile();
        this.SaveProject();
    }

    public void SaveProject() {
        if (this.projectSubFolders == null) {
            return;
        }
        Element root = new Element("Project");
        root.setAttribute("name", this.getProjectName());
        Document doc = new Document(root);
        Vector<ProjectSubFolder> subFolders = this.projectSubFolders.getSubFolders();
        Enumeration<ProjectSubFolder> e = subFolders.elements();
        while (e.hasMoreElements()) {
            ProjectSubFolder folder = e.nextElement();
            Element elem = folder.toXML();
            root.addContent((Content)elem);
        }
        XMLSupport.SaveXML((Document)doc, (String)this.projectFile.getAbsolutePath());
    }

    public void LoadProject() {
        File file = FileFolderUtils.GetFilePath("Load Project", "XML", "xml", "", "Project File", false);
        if (file == null) {
            return;
        }
        this.LoadProject(file);
    }

    public void LoadProject(File file) {
        Document doc;
        this.initProject(file);
        try {
            doc = XMLSupport.LoadXML((String)file.getAbsolutePath());
        }
        catch (IOException e) {
            VisatApp.getApp().showErrorDialog(e.getMessage());
            return;
        }
        Vector<ProjectSubFolder> folderList = new Vector<ProjectSubFolder>(30);
        Vector<ProjectFile> prodList = new Vector<ProjectFile>(50);
        Element root = doc.getRootElement();
        List children = root.getContent();
        for (Object aChild : children) {
            Element child;
            if (!(aChild instanceof Element) || !(child = (Element)aChild).getName().equals("subFolder")) continue;
            Attribute attrib = child.getAttribute("name");
            ProjectSubFolder subFolder = this.projectSubFolders.addSubFolder(attrib.getValue());
            subFolder.fromXML(child, folderList, prodList);
        }
        Project.loadProducts(folderList, prodList);
        this.notifyEvent(false);
        Project.showProjectsView();
    }

    private static void loadProducts(final Vector<ProjectSubFolder> folderList, final Vector<ProjectFile> prodList) {
        ProgressMonitorSwingWorker worker = new ProgressMonitorSwingWorker((Component)VisatApp.getApp().getMainFrame(), "Opening Project"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doInBackground(ProgressMonitor pm) throws Exception {
                pm.beginTask("Opening Project...", prodList.size());
                try {
                    for (int i = 0; i < prodList.size(); ++i) {
                        ProjectSubFolder subFolder = (ProjectSubFolder)folderList.get(i);
                        ProjectFile projFile = (ProjectFile)prodList.get(i);
                        File prodFile = projFile.getFile();
                        if (ProductFunctions.isValidProduct((File)prodFile)) {
                            subFolder.addFile(projFile);
                        }
                        pm.worked(1);
                    }
                }
                finally {
                    pm.done();
                }
                return null;
            }
        };
        worker.executeWithBlocking();
    }

    private class ProjectPTL
    implements ProductTreeListener {
        public void productAdded(Product product) {
            if (Project.this.projectSubFolders == null) {
                return;
            }
            Project.this.addProductLink(product);
            Project.this.notifyEvent(true);
        }

        public void productRemoved(Product product) {
        }

        public void productSelected(Product product, int clickCount) {
        }

        public void metadataElementSelected(MetadataElement group, int clickCount) {
        }

        public void tiePointGridSelected(TiePointGrid tiePointGrid, int clickCount) {
        }

        public void bandSelected(Band band, int clickCount) {
        }
    }

    private static class ImportProducts
    extends ProgressMonitorSwingWorker {
        final File[] productFilesToOpen;
        final ProjectSubFolder importedFolder;

        ImportProducts(File[] productFilesToOpen, ProjectSubFolder importedFolder) {
            super((Component)VisatApp.getApp().getMainFrame(), "Writing...");
            this.productFilesToOpen = productFilesToOpen;
            this.importedFolder = importedFolder;
        }

        protected Object doInBackground(ProgressMonitor pm) throws Exception {
            pm.beginTask("Importing", this.productFilesToOpen.length);
            if (this.importedFolder.getFolderType() == ProjectSubFolder.FolderType.PRODUCT) {
                for (File prodFile : this.productFilesToOpen) {
                    ProductReader reader = ProductIO.getProductReaderForInput((Object)prodFile);
                    if (reader != null) {
                        try {
                            Product product = reader.readProductNodes((Object)prodFile, null);
                            if (product != null) {
                                if (product.getProductType().equals("ASA_WSS_1P")) {
                                    throw new Exception("WSS products need to be debursted before saving as DIMAP");
                                }
                                File destFile = new File(this.importedFolder.getPath(), product.getName());
                                VisatApp.getApp().writeProductImpl(product, destFile, "BEAM-DIMAP", false);
                            }
                        }
                        catch (Exception e) {
                            VisatApp.getApp().showErrorDialog(e.getMessage());
                        }
                    }
                    pm.worked(1);
                }
            }
            pm.done();
            return true;
        }
    }
}

