/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.toolviews.Projects;

import com.thoughtworks.xstream.io.xml.xppdom.XppDom;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.esa.beam.framework.gpf.graph.Graph;
import org.esa.nest.dat.toolviews.Projects.ProjectSubFolder;
import org.esa.snap.gpf.GPFProcessor;

public class ProjectFile {
    private final File file;
    private final String displayName;
    private String tooltipText;
    private ProjectSubFolder.FolderType folderType;

    ProjectFile(File f, String name) {
        this.file = f;
        this.tooltipText = this.displayName = name.trim();
    }

    void setFolderType(ProjectSubFolder.FolderType folder) {
        this.folderType = folder;
        if (this.folderType == ProjectSubFolder.FolderType.GRAPH) {
            try {
                XppDom descXML;
                XppDom presXML;
                Graph graph = GPFProcessor.readGraph((Reader)new FileReader(this.file), null);
                if (graph != null && (presXML = graph.getApplicationData("Presentation")) != null && (descXML = presXML.getChild("Description")) != null && descXML.getValue() != null) {
                    this.tooltipText = descXML.getValue();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ProjectSubFolder.FolderType getFolderType() {
        return this.folderType;
    }

    public File getFile() {
        return this.file;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getToolTipText() {
        return this.tooltipText;
    }

    void setToolTipText(String text) {
        this.tooltipText = text;
    }
}

