/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.toolviews.Projects;

import java.io.File;
import java.util.List;
import java.util.Vector;
import org.esa.nest.dat.toolviews.Projects.ProjectFile;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;

public class ProjectSubFolder {
    private String folderName;
    private final File path;
    private final Vector<ProjectFile> fileList = new Vector(20);
    private final Vector<ProjectSubFolder> subFolders = new Vector(10);
    private boolean removeable = true;
    private boolean physical = false;
    private boolean createdByUser = false;
    private FolderType folderType;

    ProjectSubFolder(File newPath, String name, boolean isPhysical, FolderType type) {
        this.path = newPath;
        this.folderName = name;
        this.physical = isPhysical;
        this.folderType = type;
        if (this.physical && !this.path.exists()) {
            this.path.mkdir();
        }
    }

    void setCreatedByUser(boolean flag) {
        this.createdByUser = flag;
    }

    boolean isCreatedByUser() {
        return this.createdByUser;
    }

    FolderType getFolderType() {
        return this.folderType;
    }

    public void setFolderType(FolderType type) {
        this.folderType = type;
    }

    void setRemoveable(boolean flag) {
        this.removeable = flag;
    }

    public boolean canBeRemoved() {
        return this.removeable;
    }

    void setPhysical(boolean flag) {
        this.physical = flag;
    }

    boolean isPhysical() {
        return this.physical;
    }

    public String getName() {
        return this.folderName;
    }

    public File getPath() {
        return this.path;
    }

    void clear() {
        this.fileList.clear();
        this.subFolders.clear();
    }

    boolean addFile(ProjectFile file) {
        if (!this.containsFile(file.getFile())) {
            file.setFolderType(this.folderType);
            this.fileList.add(file);
            return true;
        }
        return false;
    }

    ProjectSubFolder addSubFolder(String name) {
        ProjectSubFolder newFolder = this.findFolder(name);
        if (newFolder != null) {
            return newFolder;
        }
        newFolder = new ProjectSubFolder(new File(this.path, name), name, this.physical, this.folderType);
        this.subFolders.add(newFolder);
        return newFolder;
    }

    ProjectSubFolder addSubFolder(ProjectSubFolder newFolder) {
        if (this.findFolder(newFolder.getName()) != null) {
            return newFolder;
        }
        if (this.physical) {
            newFolder.setPhysical(this.physical);
            if (!newFolder.getPath().exists()) {
                newFolder.getPath().mkdir();
            }
        }
        this.subFolders.add(newFolder);
        return newFolder;
    }

    void renameTo(String newName) {
        if (this.physical) {
            String newPath = this.path.getParent() + File.separator + this.folderName;
            File newFile = new File(newPath);
            if (this.path.renameTo(newFile)) {
                this.folderName = newName;
            }
        } else {
            this.folderName = newName;
        }
    }

    void removeSubFolder(ProjectSubFolder subFolder) {
        this.subFolders.remove(subFolder);
    }

    void removeFile(File file) {
        for (ProjectFile projFile : this.fileList) {
            if (!projFile.getFile().equals(file)) continue;
            this.fileList.remove(projFile);
            return;
        }
    }

    public ProjectSubFolder findFolder(String name) {
        for (int i = 0; i < this.subFolders.size(); ++i) {
            ProjectSubFolder folder = this.subFolders.elementAt(i);
            if (!folder.getName().equals(name)) continue;
            return folder;
        }
        return null;
    }

    public boolean containsFile(File file) {
        for (ProjectFile projFile : this.fileList) {
            if (!projFile.getFile().equals(file)) continue;
            return true;
        }
        for (int i = 0; i < this.subFolders.size(); ++i) {
            ProjectSubFolder folder = this.subFolders.elementAt(i);
            if (!folder.containsFile(file)) continue;
            return true;
        }
        return false;
    }

    public Vector<ProjectSubFolder> getSubFolders() {
        return this.subFolders;
    }

    public Vector<ProjectFile> getFileList() {
        return this.fileList;
    }

    public Element toXML() {
        int i;
        Element elem = new Element("subFolder");
        elem.setAttribute("name", this.folderName);
        if (this.createdByUser) {
            elem.setAttribute("user", "true");
        }
        for (i = 0; i < this.subFolders.size(); ++i) {
            ProjectSubFolder sub = this.subFolders.elementAt(i);
            Element subElem = sub.toXML();
            elem.addContent((Content)subElem);
        }
        for (i = 0; i < this.fileList.size(); ++i) {
            ProjectFile projFile = this.fileList.elementAt(i);
            Element fileElem = new Element("product");
            fileElem.setAttribute("path", projFile.getFile().getAbsolutePath());
            fileElem.setAttribute("name", projFile.getDisplayName());
            elem.addContent((Content)fileElem);
        }
        return elem;
    }

    public void fromXML(Element elem, Vector<ProjectSubFolder> folderList, Vector<ProjectFile> prodList) {
        List children = elem.getContent();
        for (Object aChild : children) {
            if (!(aChild instanceof Element)) continue;
            Element child = (Element)aChild;
            if (child.getName().equals("subFolder")) {
                Attribute attrib = child.getAttribute("name");
                ProjectSubFolder subFolder = this.addSubFolder(attrib.getValue());
                Attribute attribUser = child.getAttribute("user");
                if (attribUser != null && attrib.getValue().equals("true")) {
                    this.createdByUser = true;
                }
                subFolder.fromXML(child, folderList, prodList);
                continue;
            }
            if (!child.getName().equals("product")) continue;
            Attribute pathAttrib = child.getAttribute("path");
            Attribute nameAttrib = child.getAttribute("name");
            File file = new File(pathAttrib.getValue());
            if (!file.exists()) continue;
            folderList.add(this);
            ProjectFile newFile = new ProjectFile(file, nameAttrib.getValue());
            boolean added = prodList.add(newFile);
            if (!added) continue;
            newFile.setFolderType(this.folderType);
        }
    }

    static enum FolderType {
        ROOT,
        PRODUCTSET,
        GRAPH,
        PRODUCT;

    }
}

