/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.toolviews.Projects;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Enumeration;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.esa.beam.framework.ui.PopupMenuFactory;
import org.esa.beam.framework.ui.PopupMenuHandler;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.toolviews.Projects.ProductSet;
import org.esa.nest.dat.toolviews.Projects.Project;
import org.esa.nest.dat.toolviews.Projects.ProjectFile;
import org.esa.nest.dat.toolviews.Projects.ProjectSubFolder;

class ProjectTree
extends JTree
implements PopupMenuFactory,
ActionListener {
    private Object menuContext;
    private DefaultMutableTreeNode selectedNode;
    private TreePath selectedPath;
    private final Project project = Project.instance();

    public ProjectTree() {
        this(false);
    }

    public ProjectTree(boolean multipleSelect) {
        this.getSelectionModel().setSelectionMode(multipleSelect ? 4 : 1);
        this.addMouseListener(new PTMouseListener());
        this.setCellRenderer(new PTCellRenderer());
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setToggleClickCount(2);
        this.setExpandsSelectedPaths(true);
        this.setScrollsOnExpand(true);
        this.setAutoscrolls(true);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON);
        this.setTransferHandler(new TreeTransferHandler());
        this.putClientProperty("JTree.lineStyle", "Angled");
        ToolTipManager.sharedInstance().registerComponent(this);
        PopupMenuHandler popupMenuHandler = new PopupMenuHandler((PopupMenuFactory)this);
        this.addMouseListener((MouseListener)popupMenuHandler);
        this.addKeyListener((KeyListener)popupMenuHandler);
    }

    public JPopupMenu createPopupMenu(Component component) {
        return null;
    }

    public JPopupMenu createPopupMenu(MouseEvent event) {
        this.selectedPath = this.getPathForLocation(event.getX(), event.getY());
        if (this.selectedPath != null) {
            Object context;
            this.setSelectionPath(this.selectedPath);
            this.selectedNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
            if (this.selectedNode != null && (context = this.selectedNode.getUserObject()) != null) {
                return this.createPopup(context);
            }
        }
        return null;
    }

    JPopupMenu createPopup(Object context) {
        JPopupMenu popup = new JPopupMenu();
        this.menuContext = context;
        if (context instanceof ProjectSubFolder) {
            ProjectSubFolder folder = (ProjectSubFolder)context;
            if (this.isExpanded(this.selectedPath)) {
                this.createMenuItem(popup, "Collapse");
            } else {
                this.createMenuItem(popup, "Expand");
            }
            if (this.selectedNode.isRoot()) {
                this.createMenuItem(popup, "Expand All");
                ProjectTree.addSeparator(popup);
                this.createMenuItem(popup, "New Project...");
                this.createMenuItem(popup, "Load Project...");
                this.createMenuItem(popup, "Save Project");
                this.createMenuItem(popup, "Save Project As...");
                this.createMenuItem(popup, "Close Project");
                this.createMenuItem(popup, "Refresh Project");
            } else {
                ProjectTree.addSeparator(popup);
                this.createMenuItem(popup, "Create Folder");
                JMenuItem menuItemRename = this.createMenuItem(popup, "Rename Folder");
                JMenuItem menuItemRemove = this.createMenuItem(popup, "Remove Folder");
                if (!folder.canBeRemoved()) {
                    menuItemRename.setEnabled(false);
                    menuItemRemove.setEnabled(false);
                }
                if (!folder.isPhysical()) {
                    this.createMenuItem(popup, "Clear");
                }
            }
            if (folder.getFolderType() == ProjectSubFolder.FolderType.PRODUCTSET) {
                ProjectTree.addSeparator(popup);
                this.createMenuItem(popup, "New ProductSet...");
            } else if (folder.getFolderType() == ProjectSubFolder.FolderType.GRAPH) {
                ProjectTree.addSeparator(popup);
                this.createMenuItem(popup, "New Graph...");
            }
        } else if (context instanceof ProjectFile) {
            this.createMenuItem(popup, "Open");
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.selectedNode.getParent();
            ProjectSubFolder folder = (ProjectSubFolder)parentNode.getUserObject();
            if (folder.getFolderType() == ProjectSubFolder.FolderType.PRODUCT) {
                this.createMenuItem(popup, "Open Subset");
            }
            if (!folder.isPhysical()) {
                this.createMenuItem(popup, "Import as DIMAP");
                this.createMenuItem(popup, "Import Subset as DIMAP");
            }
            this.createMenuItem(popup, "Remove");
        }
        return popup;
    }

    private JMenuItem createMenuItem(JPopupMenu popup, String text) {
        JMenuItem menuItem = new JMenuItem(text);
        menuItem.addActionListener(this);
        popup.add(menuItem);
        return menuItem;
    }

    private static void addSeparator(JPopupMenu popup) {
        if (popup.getComponentCount() > 0) {
            popup.addSeparator();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.selectedNode.getParent();
        String actionCmd = e.getActionCommand();
        if (actionCmd.equals("Create Folder")) {
            ProjectSubFolder subFolder = (ProjectSubFolder)this.menuContext;
            this.project.createNewFolder(subFolder);
        } else if (actionCmd.equals("Remove Folder")) {
            Object context;
            if (parentNode != null && (context = parentNode.getUserObject()) != null) {
                ProjectSubFolder parentFolder = (ProjectSubFolder)context;
                ProjectSubFolder subFolder = (ProjectSubFolder)this.menuContext;
                this.project.deleteFolder(parentFolder, subFolder);
            }
        } else if (actionCmd.equals("Rename Folder")) {
            Object context;
            if (parentNode != null && (context = parentNode.getUserObject()) != null) {
                ProjectSubFolder subFolder = (ProjectSubFolder)this.menuContext;
                this.project.renameFolder(subFolder);
            }
        } else if (actionCmd.equals("Remove")) {
            ProjectSubFolder parentFolder = (ProjectSubFolder)parentNode.getUserObject();
            if (parentNode != null && parentFolder != null) {
                ProjectFile file = (ProjectFile)this.menuContext;
                int status = VisatApp.getApp().showQuestionDialog("Are you sure you want to delete " + file.getFile().toString(), "");
                if (status == 0) {
                    this.project.removeFile(parentFolder, file.getFile());
                }
            }
        } else if (actionCmd.equals("Open")) {
            ProjectSubFolder parentFolder = (ProjectSubFolder)parentNode.getUserObject();
            ProjectFile file = (ProjectFile)this.menuContext;
            Project.openFile(parentFolder, file.getFile());
        } else if (actionCmd.equals("Open Subset")) {
            ProjectSubFolder parentFolder = (ProjectSubFolder)parentNode.getUserObject();
            ProjectFile file = (ProjectFile)this.menuContext;
            Project.openSubset(parentFolder, file.getFile());
        } else if (actionCmd.equals("Import as DIMAP")) {
            ProjectFile file = (ProjectFile)this.menuContext;
            this.project.ImportFileList(new File[]{file.getFile()});
        } else if (actionCmd.equals("Import Subset as DIMAP")) {
            ProjectSubFolder parentFolder = (ProjectSubFolder)parentNode.getUserObject();
            ProjectFile file = (ProjectFile)this.menuContext;
            this.project.importSubset(parentFolder, file.getFile());
        } else if (actionCmd.equals("Clear")) {
            ProjectSubFolder subFolder = (ProjectSubFolder)this.menuContext;
            this.project.clearFolder(subFolder);
        } else if (actionCmd.equals("Expand All")) {
            this.expandAll();
        } else if (actionCmd.equals("Expand")) {
            this.expandPath(this.selectedPath);
        } else if (actionCmd.equals("Collapse")) {
            this.collapsePath(this.selectedPath);
        } else if (actionCmd.equals("New Project...")) {
            this.project.CreateNewProject();
        } else if (actionCmd.equals("Load Project...")) {
            this.project.LoadProject();
        } else if (actionCmd.equals("Save Project")) {
            this.project.SaveProject();
        } else if (actionCmd.equals("Save Project As...")) {
            this.project.SaveProjectAs();
        } else if (actionCmd.equals("Close Project")) {
            this.project.CloseProject();
        } else if (actionCmd.equals("Refresh Project")) {
            this.project.refreshProjectTree();
            this.project.notifyEvent(true);
        } else if (actionCmd.equals("New ProductSet...")) {
            ProjectSubFolder subFolder = (ProjectSubFolder)this.menuContext;
            this.project.createNewProductSet(subFolder);
        } else if (actionCmd.equals("New Graph...")) {
            ProjectSubFolder subFolder = (ProjectSubFolder)this.menuContext;
            Project.createNewGraph(subFolder);
        }
    }

    void expandAll() {
        TreeNode root = (TreeNode)this.getModel().getRoot();
        ProjectTree.expandAll(this, new TreePath(root), true);
    }

    private static void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                ProjectTree.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public void populateTree(DefaultMutableTreeNode treeNode) {
        this.setModel(new DefaultTreeModel(treeNode));
        this.expandAll();
    }

    public void select(Object toSelect) {
        TreePath path = this.findTreePathFor(toSelect);
        if (path != null) {
            this.setSelectionPath(path);
        }
    }

    private TreePath findTreePathFor(Object o) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        Enumeration<TreeNode> enumeration = rootNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (treeNode.getUserObject() != o) continue;
            return new TreePath(treeNode.getPath());
        }
        return null;
    }

    private static class TreeTransferHandler
    extends TransferHandler {
        private TreeTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.stringFlavor);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            JTree tree = (JTree)c;
            TreePath path = tree.getSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
            Object context = node.getUserObject();
            if (context != null) {
                if (context instanceof ProjectFile) {
                    ProjectSubFolder parentFolder = (ProjectSubFolder)parentNode.getUserObject();
                    ProjectFile file = (ProjectFile)context;
                    if (parentFolder.getFolderType() == ProjectSubFolder.FolderType.PRODUCTSET) {
                        return new StringSelection(ProductSet.GetListAsString(file.getFile()));
                    }
                    return new StringSelection(file.getFile().getAbsolutePath());
                }
                if (context instanceof ProjectSubFolder) {
                    ProjectSubFolder parentFolder = (ProjectSubFolder)context;
                    return new StringSelection(parentFolder.getPath().getAbsolutePath());
                }
            }
            return null;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            String[] values;
            String data;
            if (!info.isDrop()) {
                return false;
            }
            JTree tree = (JTree)info.getComponent();
            DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
            Transferable t = info.getTransferable();
            try {
                data = (String)t.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                return false;
            }
            for (String value : values = data.split("\n")) {
                TreePath dropPath = tree.getDropLocation().getPath();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)dropPath.getLastPathComponent();
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
                Object o = node.getUserObject();
                if (!(o instanceof ProjectFile)) continue;
                ProjectFile projFile = (ProjectFile)o;
                ProjectSubFolder projSubFolder = (ProjectSubFolder)parentNode.getUserObject();
                if (projSubFolder.getFolderType() != ProjectSubFolder.FolderType.PRODUCTSET) continue;
                ProductSet.AddProduct(projFile.getFile(), new File(value));
            }
            return true;
        }
    }

    private static class PTCellRenderer
    extends DefaultTreeCellRenderer {
        private final ImageIcon productIcon = UIUtils.loadImageIcon((String)"icons/RsProduct16.gif");
        private final ImageIcon groupOpenIcon = UIUtils.loadImageIcon((String)"icons/RsGroupOpen16.gif");
        private final ImageIcon projectIcon = UIUtils.loadImageIcon((String)"icons/RsGroupClosed16.gif");

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            value = treeNode.getUserObject();
            if (value instanceof ProjectFile) {
                ProjectFile file = (ProjectFile)value;
                this.setText(file.getDisplayName());
                this.setIcon(this.productIcon);
                this.setToolTipText(leaf ? file.getToolTipText() : null);
            } else if (value instanceof ProjectSubFolder) {
                ProjectSubFolder subFolder = (ProjectSubFolder)value;
                this.setText(subFolder.getName());
                this.setIcon(this.projectIcon);
                this.setToolTipText(null);
            }
            return this;
        }
    }

    private class PTMouseListener
    extends MouseAdapter {
        private PTMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            int clickCount;
            int selRow = ProjectTree.this.getRowForLocation(event.getX(), event.getY());
            if (selRow >= 0 && (clickCount = event.getClickCount()) > 1) {
                TreePath selPath = ProjectTree.this.getPathForLocation(event.getX(), event.getY());
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
                Object o = node.getUserObject();
                if (o instanceof ProjectFile) {
                    ProjectFile file = (ProjectFile)o;
                    ProjectSubFolder parentFolder = (ProjectSubFolder)parentNode.getUserObject();
                    Project.openFile(parentFolder, file.getFile());
                }
            }
        }
    }
}

