/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.toolviews.Projects;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideSplitPane;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.esa.beam.framework.ui.BasicApp;
import org.esa.beam.framework.ui.application.support.AbstractToolView;
import org.esa.nest.dat.toolviews.Projects.Project;
import org.esa.nest.dat.toolviews.Projects.ProjectFile;
import org.esa.nest.dat.toolviews.Projects.ProjectSubFolder;
import org.esa.nest.dat.toolviews.Projects.ProjectTree;

public class ProjectsToolView
extends AbstractToolView
implements Observer {
    public static final String ID = ProjectsToolView.class.getName();
    private ProjectTree projectTree;
    private DefaultMutableTreeNode rootNode;
    private final Project project = Project.instance();

    public JComponent createControl() {
        Project.instance().addObserver(this);
        JideScrollPane prjScrollPane = new JideScrollPane((Component)this.createTree());
        prjScrollPane.setPreferredSize(new Dimension(320, 480));
        prjScrollPane.setHorizontalScrollBarPolicy(30);
        prjScrollPane.setVerticalScrollBarPolicy(20);
        prjScrollPane.setBorder(null);
        prjScrollPane.setViewportBorder(null);
        JideSplitPane splitPane = new JideSplitPane(0);
        splitPane.addPane((Component)prjScrollPane);
        return splitPane;
    }

    private ProjectTree createTree() {
        this.rootNode = new DefaultMutableTreeNode("");
        this.projectTree = new ProjectTree(false);
        this.projectTree.populateTree(this.rootNode);
        this.projectTree.setRootVisible(false);
        this.projectTree.setShowsRootHandles(true);
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.projectTree.getCellRenderer();
        renderer.setLeafIcon(IconsFactory.getImageIcon(BasicApp.class, (String)"/org/esa/beam/resources/images/icons/RsBandAsSwath16.gif"));
        renderer.setClosedIcon(IconsFactory.getImageIcon(BasicApp.class, (String)"/org/esa/beam/resources/images/icons/RsGroupClosed16.gif"));
        renderer.setOpenIcon(IconsFactory.getImageIcon(BasicApp.class, (String)"/org/esa/beam/resources/images/icons/RsGroupOpen16.gif"));
        return this.projectTree;
    }

    private static void PopulateNode(Vector<ProjectSubFolder> subFolders, DefaultMutableTreeNode treeNode) {
        Enumeration<ProjectSubFolder> e = subFolders.elements();
        while (e.hasMoreElements()) {
            ProjectSubFolder folder = e.nextElement();
            DefaultMutableTreeNode folderNode = new DefaultMutableTreeNode(folder);
            treeNode.add(folderNode);
            Vector<ProjectFile> fileList = folder.getFileList();
            Enumeration<ProjectFile> file = fileList.elements();
            while (file.hasMoreElements()) {
                DefaultMutableTreeNode fileNode = new DefaultMutableTreeNode(file.nextElement());
                folderNode.add(fileNode);
            }
            Vector<ProjectSubFolder> moreFolders = folder.getSubFolders();
            if (moreFolders.isEmpty()) continue;
            ProjectsToolView.PopulateNode(moreFolders, folderNode);
        }
    }

    @Override
    public void update(Observable subject, Object data) {
        this.rootNode.removeAllChildren();
        ProjectSubFolder projectFolders = this.project.getProjectSubFolders();
        if (projectFolders == null) {
            this.projectTree.setRootVisible(false);
            this.projectTree.populateTree(this.rootNode);
        } else {
            this.rootNode.setUserObject(this.project.getProjectSubFolders());
            this.projectTree.setRootVisible(true);
            Vector<ProjectSubFolder> subFolders = this.project.getProjectSubFolders().getSubFolders();
            ProjectsToolView.PopulateNode(subFolders, this.rootNode);
            this.projectTree.populateTree(this.rootNode);
        }
    }
}

