/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.utils;

import com.bc.io.FileDownloader;
import com.bc.io.FileUnpacker;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.esa.beam.framework.ui.BasicApp;
import org.esa.beam.visat.VisatApp;

public class AutoDownload {
    public static String getDownloadedDirPath(String message, File installDir, String ARCHIVE_URL_PATH) {
        if (!installDir.canRead() || installDir.listFiles().length == 0) {
            if (!installDir.canRead() && !installDir.mkdirs()) {
                return null;
            }
            try {
                AutoDownload.downloadDGGTiles(message, installDir, ARCHIVE_URL_PATH);
            }
            catch (IOException e) {
                return null;
            }
        }
        return installDir.getAbsolutePath();
    }

    private static synchronized void downloadDGGTiles(String message, File installDir, String ARCHIVE_URL_PATH) throws IOException {
        VisatApp visatApp = VisatApp.getApp();
        if (visatApp != null) {
            visatApp.setStatusBarMessage(message);
        }
        BasicApp.MainFrame parent = visatApp != null ? visatApp.getMainFrame() : null;
        File archiveFile = FileDownloader.downloadFile((URL)new URL(ARCHIVE_URL_PATH), (File)installDir, (Component)parent);
        FileUnpacker.unpackZip((File)archiveFile, (File)installDir, (Component)parent);
        archiveFile.delete();
        if (visatApp != null) {
            visatApp.setStatusBarMessage("");
        }
    }
}

