/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.utils;

import java.awt.Component;
import java.io.File;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import org.esa.beam.util.io.BeamFileChooser;
import org.esa.beam.util.io.BeamFileFilter;
import org.esa.beam.util.io.FileUtils;
import org.esa.beam.visat.VisatApp;

public class FileFolderUtils {
    public static File GetFilePath(String title, String formatName, String extension, String fileName, String description, boolean isSave) {
        return FileFolderUtils.GetFilePath(title, formatName, extension, fileName, description, isSave, "app.file.lastOpenDir", FileSystemView.getFileSystemView().getRoots()[0].getAbsolutePath());
    }

    public static File GetSaveFilePath(String title, String formatName, String extension, String fileName, String description) {
        return FileFolderUtils.GetFilePath(title, formatName, extension, fileName, description, true, "app.file.lastSaveDir", FileSystemView.getFileSystemView().getRoots()[0].getAbsolutePath());
    }

    public static File GetFilePath(String title, String formatName, String extension, String fileName, String description, boolean isSave, String lastDirPropertyKey, String defaultPath) {
        File file;
        BeamFileFilter fileFilter = null;
        if (!extension.isEmpty()) {
            fileFilter = new BeamFileFilter(formatName, extension, description);
        }
        if (isSave) {
            file = VisatApp.getApp().showFileSaveDialog(title, false, (FileFilter)fileFilter, '.' + extension, fileName, lastDirPropertyKey);
        } else {
            String lastDir = VisatApp.getApp().getPreferences().getPropertyString(lastDirPropertyKey, defaultPath);
            file = fileName == null ? FileFolderUtils.showFileOpenDialog(title, false, (FileFilter)fileFilter, lastDir, lastDirPropertyKey) : FileFolderUtils.showFileOpenDialog(title, false, (FileFilter)fileFilter, fileName, lastDirPropertyKey);
        }
        return file == null ? null : FileUtils.ensureExtension((File)file, (String)extension);
    }

    private static File showFileOpenDialog(String title, boolean dirsOnly, FileFilter fileFilter, String currentDir, String lastDirPropertyKey) {
        String lastDirPath;
        BeamFileChooser fileChooser = new BeamFileChooser();
        fileChooser.setCurrentDirectory(new File(currentDir));
        if (fileFilter != null) {
            fileChooser.setFileFilter(fileFilter);
        }
        fileChooser.setDialogTitle(VisatApp.getApp().getAppName() + " - " + title);
        fileChooser.setFileSelectionMode(dirsOnly ? 1 : 0);
        int result = fileChooser.showOpenDialog((Component)VisatApp.getApp().getMainFrame());
        if (fileChooser.getCurrentDirectory() != null && (lastDirPath = fileChooser.getCurrentDirectory().getAbsolutePath()) != null) {
            VisatApp.getApp().getPreferences().setPropertyString(lastDirPropertyKey, lastDirPath);
        }
        if (result == 0) {
            File file = fileChooser.getSelectedFile();
            if (file == null || file.getName().isEmpty()) {
                return null;
            }
            return file.getAbsoluteFile();
        }
        return null;
    }
}

