/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.views.polarview;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.esa.nest.dat.views.polarview.ColourScale;

class ColorBar
implements ImageProducer {
    private final ColourScale colourScale;
    private ColorModel model;
    private static final Dimension barSize = new Dimension(24, 256);
    private static final byte[] barPixels = new byte[ColorBar.barSize.height];
    private static final int[] barRGBPixels = new int[ColorBar.barSize.height];
    private final Dimension imageSize;
    private final Rectangle imageArea;
    protected static final Point p0 = new Point(0, 0);
    private final Hashtable properties;
    private final Vector<ImageConsumer> theConsumers;
    private static final int hints = 3;

    public ColorBar(ColourScale colourScale) {
        this.imageSize = new Dimension(ColorBar.barSize.width, ColorBar.barSize.height);
        this.imageArea = new Rectangle(this.imageSize);
        this.properties = new Hashtable(1);
        this.theConsumers = new Vector(1);
        this.colourScale = colourScale;
        colourScale.addColoredObject(this);
        this.model = colourScale.getColorModel();
    }

    @Override
    public synchronized boolean isConsumer(ImageConsumer ic) {
        return this.theConsumers.contains(ic);
    }

    @Override
    public synchronized void removeConsumer(ImageConsumer ic) {
        this.theConsumers.removeElement(ic);
    }

    private synchronized void removeAllConsumers() {
        Enumeration<ImageConsumer> elem = this.theConsumers.elements();
        while (elem.hasMoreElements()) {
            ImageConsumer ic = elem.nextElement();
            ic.imageComplete(3);
            if (!this.isConsumer(ic)) continue;
            ic.imageComplete(1);
        }
        this.theConsumers.removeAllElements();
    }

    @Override
    public void startProduction(ImageConsumer ic) {
        this.addConsumer(ic);
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer imageconsumer) {
    }

    private void initConsumer(ImageConsumer ic) {
        if (this.isConsumer(ic)) {
            ic.setDimensions(this.imageSize.width, this.imageSize.height);
        }
        if (this.isConsumer(ic)) {
            ic.setProperties(this.properties);
        }
        if (this.isConsumer(ic)) {
            ic.setColorModel(this.model);
        }
        if (this.isConsumer(ic)) {
            ic.setHints(3);
        }
    }

    private synchronized Enumeration getConsumers() {
        return this.theConsumers.elements();
    }

    private synchronized void addConsumerToList(ImageConsumer ic) {
        this.theConsumers.addElement(ic);
    }

    protected void finalize() {
        this.removeAllConsumers();
    }

    @Override
    public synchronized void addConsumer(ImageConsumer ic) {
        block4: {
            if (this.isConsumer(ic)) {
                return;
            }
            this.addConsumerToList(ic);
            try {
                this.initConsumer(ic);
                this.deliverPixels(ic, this.imageArea);
                if (this.isConsumer(ic)) {
                    ic.imageComplete(2);
                }
            }
            catch (Exception e) {
                if (!this.isConsumer(ic)) break block4;
                ic.imageComplete(1);
            }
        }
    }

    private synchronized void resend() {
        this.resend(this.imageArea);
    }

    void updatedColorMap() {
        this.model = this.colourScale.getColorModel();
        this.resendColorModel();
        this.resend();
    }

    public void updatedColorScale() {
        this.updatedColorMap();
    }

    private synchronized void resend(Rectangle area) {
        Enumeration con = this.getConsumers();
        while (con.hasMoreElements()) {
            ImageConsumer ic = (ImageConsumer)con.nextElement();
            try {
                this.deliverPixels(ic, area);
                if (!this.isConsumer(ic)) continue;
                ic.imageComplete(2);
            }
            catch (Exception e) {
                if (!this.isConsumer(ic)) continue;
                ic.imageComplete(1);
            }
        }
    }

    private synchronized void resendColorModel() {
        Enumeration elem = this.getConsumers();
        while (elem.hasMoreElements()) {
            ImageConsumer ic = (ImageConsumer)elem.nextElement();
            ic.setColorModel(this.model);
        }
    }

    public static Dimension getBarSize() {
        return new Dimension(barSize);
    }

    private void deliverPixels(ImageConsumer ic, Rectangle area) {
        if (this.model instanceof DirectColorModel) {
            for (int i = 0; i < ColorBar.barSize.width; ++i) {
                ic.setPixels(i, 0, 1, ColorBar.barSize.height, this.model, barRGBPixels, 0, 1);
            }
        } else {
            for (int i = 0; i < ColorBar.barSize.width; ++i) {
                ic.setPixels(i, 0, 1, ColorBar.barSize.height, this.model, barPixels, 0, 1);
            }
        }
    }

    static {
        int p = 0;
        float scale = 0xFFFFFF / (ColorBar.barSize.height - 1);
        for (int i = ColorBar.barSize.height - 1; i >= 0; --i) {
            ColorBar.barPixels[p] = (byte)i;
            ColorBar.barRGBPixels[p] = (int)((float)p * scale);
            ++p;
        }
    }
}

