/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.views.polarview;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.Enumeration;
import java.util.Vector;
import org.esa.nest.dat.views.polarview.ColorBar;
import org.esa.nest.dat.views.polarview.PolarView;

public class ColourScale {
    private ColorModel cm = null;
    private final Color[] colors;
    private final int thresholdCount;
    private final int[] colorIndexThresholds;
    private final Vector<ColorBar> coloredClients = new Vector();
    private double[] colorIndexValues = null;
    private double darkestValue = 0.0;
    private double darkestIndex = 0.0;
    private double lightestValue = 0.0;
    private double lightestIndex = 0.0;
    private double scale = 0.0;

    private ColourScale(Color[] colorTable) {
        this.thresholdCount = colorTable.length;
        this.colorIndexThresholds = new int[this.thresholdCount];
        this.colorIndexThresholds[0] = 0;
        this.colorIndexThresholds[this.thresholdCount - 1] = 255;
        this.colors = colorTable;
    }

    public static ColourScale newMonochromeScale(double[] range, Color chromum) {
        Color[] monochromeColorTable = new Color[]{Color.black, Color.black, chromum, chromum};
        return new ColourScale(monochromeColorTable, range);
    }

    public static ColourScale newCustomScale(double[] range) {
        return new ColourScale(PolarView.colourTable, range);
    }

    private ColourScale(Color[] colorTable, double[] range) {
        this(colorTable);
        this.colorIndexValues = new double[this.thresholdCount];
        this.setRange(range[0], range[1]);
        this.createColorMap();
    }

    public void setRange(double[] range) {
        this.setRange(range[0], range[1]);
    }

    public void setRange(int[] range) {
        this.setRange(range[0], range[1]);
    }

    private void setRange(int minValue, int maxValue) {
        this.setRange((double)minValue, (double)maxValue);
    }

    private void setRange(double minValue, double maxValue) {
        this.darkestValue = minValue;
        this.lightestValue = maxValue;
        this.validateRange();
        this.setEvenThresholds();
        this.darkestIndex = this.colorIndexThresholds[0];
        this.lightestIndex = this.colorIndexThresholds[this.thresholdCount - 1];
        this.updateRange();
    }

    byte getColorIndex(int value) {
        return this.getColorIndex((double)value);
    }

    byte getColorIndex(float value) {
        return this.getColorIndex((double)value);
    }

    byte getColorIndex(double value) {
        double val = value - this.darkestValue;
        if (val < 0.0) {
            return (byte)this.darkestIndex;
        }
        if (this.scale != 0.0) {
            val *= this.scale;
        }
        if ((val += this.darkestIndex) > this.lightestIndex) {
            return (byte)this.lightestIndex;
        }
        return (byte)((int)Math.round(val) & 0xFF);
    }

    private int getIntegerColorValue(int index) {
        return (int)Math.round(this.getDoubleColorValue(index));
    }

    private double getDoubleColorValue(int index) {
        double value = (double)index - this.darkestIndex;
        if (this.scale != 0.0) {
            value /= this.scale;
        }
        return value + this.darkestValue;
    }

    private void updateColorValues() {
        for (int i = 0; i < this.thresholdCount; ++i) {
            this.colorIndexValues[i] = this.getIntegerColorValue(this.colorIndexThresholds[i]);
        }
    }

    private void validateRange() {
        this.darkestValue = Math.min(this.darkestValue, this.lightestValue);
        double range = this.lightestValue - this.darkestValue;
        this.scale = 255.0 / range;
    }

    public final Color getColor(int value) {
        return new Color(this.getRGB(value));
    }

    public final Color getColor(float value) {
        return new Color(this.getRGB(value));
    }

    public final Color getColor(double value) {
        return new Color(this.getRGB(value));
    }

    private int getRGB(int value) {
        return this.cm.getRGB(this.getColorIndex(value) & 0xFF);
    }

    private int getRGB(float value) {
        return this.cm.getRGB(this.getColorIndex(value) & 0xFF);
    }

    private int getRGB(double value) {
        return this.cm.getRGB(this.getColorIndex(value) & 0xFF);
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public synchronized void addColoredObject(ColorBar ip) {
        if (!this.coloredClients.contains(ip)) {
            this.coloredClients.addElement(ip);
        }
    }

    private void setEvenThresholds() {
        int N = this.thresholdCount - 1;
        int first = 0;
        int last = N;
        if (this.colors[last].equals(this.colors[last - 1])) {
            this.colorIndexThresholds[last] = 255;
            --last;
            --N;
        }
        if (this.colors[first].equals(this.colors[first + 1])) {
            this.colorIndexThresholds[first] = 0;
            ++first;
            --N;
        }
        double colorStep = 255.0 / (double)N;
        int offset = 0;
        int i = 0;
        for (int t = first; t <= last; ++t) {
            this.colorIndexThresholds[t] = offset + (int)Math.round((double)i * colorStep);
            ++i;
        }
    }

    private void createColorMap() {
        int lastThreshold = this.thresholdCount - 1;
        byte[] cmap = new byte[768];
        Color lastColor = this.colors[0];
        int lastIndex = this.colorIndexThresholds[0];
        int c = 0;
        for (int i = 1; i < this.thresholdCount; ++i) {
            int cRange = this.colorIndexThresholds[i] - lastIndex;
            int[] lastRGB = new int[]{lastColor.getRed(), lastColor.getGreen(), lastColor.getBlue()};
            int[] nextRGB = new int[]{this.colors[i].getRed(), this.colors[i].getGreen(), this.colors[i].getBlue()};
            for (int j = 0; j < cRange; ++j) {
                float nextScale = (float)j / (float)cRange;
                float lastScale = 1.0f - nextScale;
                cmap[c++] = (byte)((float)lastRGB[0] * lastScale + (float)nextRGB[0] * nextScale);
                cmap[c++] = (byte)((float)lastRGB[1] * lastScale + (float)nextRGB[1] * nextScale);
                cmap[c++] = (byte)((float)lastRGB[2] * lastScale + (float)nextRGB[2] * nextScale);
            }
            lastColor = this.colors[i];
            lastIndex = this.colorIndexThresholds[i];
        }
        Color finalColor = this.colors[lastThreshold];
        cmap[c++] = (byte)finalColor.getRed();
        cmap[c++] = (byte)finalColor.getGreen();
        cmap[c] = (byte)finalColor.getBlue();
        this.cm = new IndexColorModel(8, 256, cmap, 0, false);
    }

    private synchronized void notifyRangeChange() {
        Enumeration<ColorBar> elem = this.coloredClients.elements();
        while (elem.hasMoreElements()) {
            ColorBar ip = elem.nextElement();
            ip.updatedColorScale();
        }
    }

    private void updateRange() {
        this.updateColorValues();
        this.createColorMap();
        this.notifyRangeChange();
    }
}

