/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.views.polarview;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.esa.beam.framework.ui.ModalDialog;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.views.polarview.Axis;
import org.esa.snap.util.DialogUtils;

class ColourScaleDialog
extends ModalDialog {
    private final JTextField min = new JTextField("");
    private final JTextField max = new JTextField("");
    private boolean ok = false;
    private final Axis colourAxis;

    public ColourScaleDialog(Axis colourAxis) {
        super((Window)VisatApp.getApp().getMainFrame(), "Colour Scale", 33, null);
        this.colourAxis = colourAxis;
        double[] range = colourAxis.getRange();
        this.min.setText(String.valueOf(range[0]));
        this.max.setText(String.valueOf(range[range.length - 1]));
        this.setContent(this.createPanel());
    }

    protected void onOK() {
        this.colourAxis.setDataRange(Double.parseDouble(this.min.getText()), Double.parseDouble(this.max.getText()));
        this.ok = true;
        this.hide();
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"min:", (JComponent)this.min);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"max:", (JComponent)this.max);
        ++gbc.gridy;
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }
}

