/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.views.polarview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import org.esa.beam.util.Debug;
import org.esa.nest.dat.views.polarview.Axis;
import org.esa.nest.dat.views.polarview.ColorBar;
import org.esa.nest.dat.views.polarview.ColourScale;
import org.esa.nest.dat.views.polarview.PolarData;

class PolarCanvas
extends Container {
    private final Axis radialAxis;
    private final Axis colourAxis;
    private PolarData data = null;
    private double[] rings = null;
    private String[] ringText = null;
    private final float dirOffset;
    private int plotRadius = 0;
    private double windDirection = 0.0;
    private boolean showWindDirection = false;
    private boolean opaque = false;
    private final Dimension graphSize = new Dimension(200, 100);
    private Point origin = new Point(0, 0);
    private Image colorBar = null;
    private String axisLabel1 = "";
    private String axisLabel2 = "";

    public PolarCanvas() {
        this(new Axis(5), new Axis(4));
    }

    private PolarCanvas(Axis radialAxis, Axis colourAxis) {
        this.dirOffset = 0.0f;
        this.radialAxis = radialAxis;
        this.colourAxis = colourAxis;
        colourAxis.setLocation(4);
        radialAxis.setSpacing(0);
        colourAxis.setSpacing(0);
        this.enableEvents(16L);
        this.setBackground(Color.white);
    }

    public void setAxisNames(String name1, String name2) {
        this.axisLabel1 = name1;
        this.axisLabel2 = name2;
    }

    @Override
    public Font getFont() {
        Font font = super.getFont();
        if (font == null) {
            return Font.decode("SansSerif-plain-9");
        }
        return font;
    }

    @Override
    public final void setBackground(Color background) {
        this.opaque = true;
        super.setBackground(background);
    }

    private void fillBackground(Graphics g) {
        Rectangle clip = g.getClipBounds();
        Color col = g.getColor();
        g.setColor(this.getBackground());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        g.setColor(col);
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
        try {
            super.repaint(tm, x, y, width, height);
        }
        catch (Throwable e) {
            Debug.trace((Throwable)e);
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        try {
            if (this.isShowing()) {
                if (this.opaque) {
                    this.fillBackground(g);
                }
                g.setColor(this.getForeground());
                g.setFont(this.getFont());
                PolarCanvas.paintComponents(this, g);
            }
            this.drawSynchronised(g, this.getSize());
        }
        catch (Throwable e) {
            Debug.trace((Throwable)e);
        }
    }

    private synchronized void drawSynchronised(Graphics g, Dimension size) {
        this.draw(g, size);
    }

    private Rectangle positionPlot(Dimension size, int x, int y, int bottom, int right) {
        Rectangle r = new Rectangle(x, y, (int)size.getWidth() - x - right, (int)size.getHeight() - y - bottom);
        this.origin = r.getLocation();
        this.graphSize.setSize(r.width, r.height);
        return r;
    }

    private void loadColorBar(ColourScale scale) {
        if (this.colorBar == null) {
            this.colorBar = this.createImage(new ColorBar(scale));
        }
    }

    private void drawColorBar(Graphics g, Axis cAxis) {
        Dimension cbSize = new Dimension((int)((double)this.graphSize.width * 0.03), (int)Math.min(200.0, (double)this.graphSize.height * 0.6));
        Point at = new Point(20, -100);
        g.translate(at.x, at.y);
        g.drawImage(this.colorBar, 0, 0, cbSize.width, cbSize.height, this);
        g.drawRect(0, 0, cbSize.width, cbSize.height);
        g.translate(cbSize.width, cbSize.height);
        cAxis.draw(g, cbSize);
        g.drawString(cAxis.getUnit(), 50, 5);
        g.translate(-cbSize.width - at.x, -cbSize.height - at.y);
    }

    protected void finalize() throws Throwable {
        if (this.colorBar != null) {
            this.colorBar.flush();
        }
        this.colorBar = null;
        super.finalize();
    }

    private static void paintComponents(Container c, Graphics g) {
        if (!c.isShowing()) {
            return;
        }
        int ncomponents = c.getComponentCount();
        Rectangle clip = g.getClipBounds();
        int i = ncomponents - 1;
        while (i >= 0) {
            Component[] component = c.getComponents();
            Component comp = component[i];
            if (comp == null || !comp.isVisible()) continue;
            Rectangle bounds = comp.getBounds();
            Rectangle cr = clip == null ? new Rectangle(bounds) : bounds.intersection(clip);
            if (cr.isEmpty()) continue;
            Graphics cg = g.create();
            cg.setClip(cr);
            cg.translate(bounds.x, bounds.y);
            try {
                comp.paint(cg);
            }
            catch (Throwable e) {
                // empty catch block
            }
            cg.dispose();
            --i;
        }
    }

    public Axis getRadialAxis() {
        return this.radialAxis;
    }

    public Axis getColourAxis() {
        return this.colourAxis;
    }

    public PolarData getData() {
        return this.data;
    }

    public void setData(PolarData data) {
        this.data = data;
        if (data != null) {
            data.setRAxis(this.radialAxis);
            data.setDirOffset(this.dirOffset);
            data.setCAxis(this.colourAxis);
        }
    }

    public void setRings(double[] rings, String[] ringText) {
        this.rings = rings;
        this.ringText = ringText;
    }

    public double[] getRTheta(Point oP) {
        Point p = new Point(oP);
        p.y = this.origin.y - p.y;
        p.x -= this.origin.x;
        if (Math.abs(p.y) > this.plotRadius || Math.abs(p.x) > this.plotRadius) {
            return null;
        }
        int r = (int)Math.sqrt(p.x * p.x + p.y * p.y);
        double rV = this.data.valueFromScreenPoint(r);
        return new double[]{rV, (360.0 - Math.atan2(p.x, p.y) * 180.0 / Math.PI) % 360.0};
    }

    public Axis selectAxis(Point oP) {
        Point p = new Point(oP);
        p.y = this.origin.y - p.y;
        p.x -= this.origin.x;
        if (Math.abs(p.y) < this.plotRadius) {
            if (Math.abs(p.x) < this.plotRadius) {
                return this.radialAxis;
            }
            if (p.x > this.graphSize.width / 2) {
                return this.colourAxis;
            }
        }
        return null;
    }

    private void draw(Graphics g, Dimension size) {
        int annotationHeight = 100;
        int x = Math.max((int)((double)size.height * 0.05), 10);
        int y = Math.max((int)((double)size.width * 0.05), 10);
        int bottom = Math.max((int)((double)size.height * 0.1) + 100, 20);
        int right = Math.max((int)((double)size.width * 0.1), 20);
        Rectangle r = this.positionPlot(size, x, y, bottom, right);
        this.plotRadius = Math.min(r.width / 2, r.height / 2);
        Dimension quadrantSize = new Dimension(this.plotRadius, this.plotRadius);
        g.translate(0, this.origin.y + r.height);
        if (this.data != null) {
            this.loadColorBar(this.data.getColorScale());
            this.drawColorBar(g, this.colourAxis);
        }
        g.translate(0, -this.origin.y - r.height);
        this.origin.y += r.height / 2;
        this.origin.x += r.width / 2;
        Graphics graphics = g.create();
        graphics.translate(this.origin.x, this.origin.y);
        this.radialAxis.setSize(quadrantSize);
        if (this.data != null) {
            this.data.draw(graphics);
        }
        if (this.rings != null) {
            int ri = 0;
            for (double ring : this.rings) {
                int rad = this.radialAxis.getScreenPoint(ring);
                int rad2 = rad + rad;
                graphics.setColor(Color.lightGray);
                graphics.drawOval(-rad, -rad, rad2, rad2);
                if (this.ringText != null && this.ringText[ri] != null) {
                    graphics.setColor(Color.black);
                    graphics.drawString(this.ringText[ri], 0, -rad);
                }
                ++ri;
            }
        } else {
            this.radialAxis.draw(graphics);
        }
        if (this.showWindDirection) {
            PolarCanvas.drawWindDirection(graphics, this.plotRadius, this.windDirection - 90.0);
        }
        graphics.translate(-this.origin.x, -this.origin.y);
        this.drawAxisLabels(graphics);
        graphics.dispose();
    }

    private static void drawWindDirection(Graphics graphics, double radius, double theta) {
        double a = theta * (Math.PI / 180);
        int x1 = (int)(radius * Math.cos(a));
        int y1 = (int)(radius * Math.sin(a));
        int x2 = (int)((radius + 50.0) * Math.cos(a));
        int y2 = (int)((radius + 50.0) * Math.sin(a));
        graphics.setColor(Color.black);
        graphics.drawLine(x1, y1, x2, y2);
        PolarCanvas.drawArrowHead(graphics, x2, y2, theta, radius + 40.0);
    }

    private void drawAxisLabels(Graphics graphics) {
        int x = 20;
        int y = this.origin.y;
        int d = 50;
        graphics.setColor(Color.black);
        int y2 = y - 50;
        graphics.drawLine(20, y, 20, y - 50);
        graphics.drawLine(20, y2, 15, y2 + 5);
        graphics.drawLine(20, y2, 25, y2 + 5);
        graphics.drawString(this.axisLabel1, 5, y2 - 10);
        int x2 = 70;
        graphics.drawLine(20, y, 70, y);
        graphics.drawLine(70, y, 65, y - 5);
        graphics.drawLine(70, y, 65, y + 5);
        graphics.drawString(this.axisLabel2, 60, y + 20);
    }

    private static void drawArrowHead(Graphics graphics, int x, int y, double theta, double length) {
        double b = (theta + 1.0) * (Math.PI / 180);
        int x3 = (int)(length * Math.cos(b));
        int y3 = (int)(length * Math.sin(b));
        graphics.drawLine(x, y, x3, y3);
        double c = (theta - 1.0) * (Math.PI / 180);
        int x4 = (int)(length * Math.cos(c));
        int y4 = (int)(length * Math.sin(c));
        graphics.drawLine(x, y, x4, y4);
    }

    public void setWindDirection(double dir) {
        this.windDirection = dir;
    }

    public void showWindDirection(boolean flag) {
        this.showWindDirection = flag;
    }
}

