/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.views.polarview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.BevelBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.ui.BasicView;
import org.esa.beam.framework.ui.product.ProductNodeView;
import org.esa.beam.framework.ui.product.ProductSceneImage;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.utils.FileFolderUtils;
import org.esa.nest.dat.views.polarview.Axis;
import org.esa.nest.dat.views.polarview.ColourScale;
import org.esa.nest.dat.views.polarview.ColourScaleDialog;
import org.esa.nest.dat.views.polarview.ControlPanel;
import org.esa.nest.dat.views.polarview.PolarCanvas;
import org.esa.nest.dat.views.polarview.PolarData;
import org.esa.nest.dat.views.polarview.PolarPanel;
import org.esa.snap.datamodel.AbstractMetadata;

public final class PolarView
extends BasicView
implements ProductNodeView,
ActionListener,
PopupMenuListener,
MouseListener,
MouseMotionListener {
    private final Product product;
    private ProductSceneImage sceneImage;
    private MetadataElement spectraMetadataRoot = null;
    private final int numRecords;
    private final int recordLength;
    private int numDirBins;
    private int numWLBins;
    private float firstDirBins = 0.0f;
    private float dirBinStep = 0.0f;
    private float firstWLBin = 0.0f;
    private float lastWLBin = 0.0f;
    private final double minRadius = -10.0;
    private ProductData.UTC zeroDopplerTime = null;
    private double minSpectrum = 0.0;
    private double maxSpectrum = 255.0;
    private double maxSpecDir = 0.0;
    private double maxSpecWL = 0.0;
    private double minReal = 0.0;
    private double maxReal = 0.0;
    private double minImaginary = 0.0;
    private double maxImaginary = 0.0;
    private double windSpeed = 0.0;
    private double windDirection = 0.0;
    private double sarWaveHeight = 0.0;
    private double sarAzShiftVar = 0.0;
    private double backscatter = 0.0;
    private int currentRecord = 0;
    private final String[] unitTypes = new String[]{"Real", "Imaginary", "Amplitude", "Intensity"};
    private final ControlPanel controlPanel;
    private final PolarPanel polarPanel;
    private Unit graphUnit = Unit.REAL;
    private WaveProductType waveProductType = WaveProductType.WAVE_SPECTRA;
    private float[][] spectrum = null;
    public static final Color[] colourTable = new Color[]{new Color(255, 255, 255), new Color(0, 0, 255), new Color(0, 255, 255), new Color(0, 255, 0), new Color(255, 255, 0), new Color(255, 0, 0)};
    private static final double[] rings = new double[]{50.0, 100.0, 200.0};
    private static final String[] ringTextStrings = new String[]{"200 m", "100 m", "50 m"};

    public PolarView(Product prod, ProductSceneImage image) {
        this.product = prod;
        this.sceneImage = image;
        if (prod.getProductType().equals("ASA_WVW_2P")) {
            this.waveProductType = WaveProductType.WAVE_SPECTRA;
            this.graphUnit = Unit.AMPLITUDE;
        } else {
            this.waveProductType = WaveProductType.CROSS_SPECTRA;
            this.graphUnit = Unit.INTENSITY;
        }
        this.getMetadata();
        RasterDataNode[] rasters = this.sceneImage.getRasters();
        RasterDataNode rasterNode = rasters[0];
        this.numRecords = rasterNode.getRasterHeight() - 1;
        this.recordLength = rasterNode.getRasterWidth();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setLayout(new BorderLayout());
        this.polarPanel = new PolarPanel();
        this.add(this.polarPanel, "Center");
        this.controlPanel = new ControlPanel(this);
        this.add(this.controlPanel, "South");
        this.createPlot(this.currentRecord);
    }

    public ProductNode getVisibleProductNode() {
        return this.sceneImage.getRasters()[0];
    }

    public void dispose() {
        this.sceneImage = null;
        super.dispose();
    }

    public Product getProduct() {
        return this.product;
    }

    private void getMetadata() {
        MetadataElement root = AbstractMetadata.getOriginalProductMetadata((Product)this.product);
        MetadataElement sph = root.getElement("SPH");
        this.numDirBins = sph.getAttributeInt("NUM_DIR_BINS", 0);
        this.numWLBins = sph.getAttributeInt("NUM_WL_BINS", 0);
        this.firstDirBins = (float)sph.getAttributeDouble("FIRST_DIR_BIN", 0.0);
        this.dirBinStep = (float)sph.getAttributeDouble("DIR_BIN_STEP", 0.0);
        this.firstWLBin = (float)sph.getAttributeDouble("FIRST_WL_BIN", 0.0);
        this.lastWLBin = (float)sph.getAttributeDouble("LAST_WL_BIN", 0.0);
        this.spectraMetadataRoot = this.waveProductType == WaveProductType.WAVE_SPECTRA ? root.getElement("OCEAN_WAVE_SPECTRA_MDS") : root.getElement("CROSS_SPECTRA_MDS");
    }

    private void getSpectraMetadata(int rec) {
        try {
            String elemName = this.spectraMetadataRoot.getName() + '.' + (rec + 1);
            MetadataElement spectraMetadata = this.spectraMetadataRoot.getElement(elemName);
            this.zeroDopplerTime = spectraMetadata.getAttributeUTC("zero_doppler_time");
            this.maxSpecDir = spectraMetadata.getAttributeDouble("spec_max_dir", 0.0);
            this.maxSpecWL = spectraMetadata.getAttributeDouble("spec_max_wl", 0.0);
            if (this.waveProductType == WaveProductType.WAVE_SPECTRA) {
                this.minSpectrum = spectraMetadata.getAttributeDouble("min_spectrum", 0.0);
                this.maxSpectrum = spectraMetadata.getAttributeDouble("max_spectrum", 255.0);
                this.windSpeed = spectraMetadata.getAttributeDouble("wind_speed", 0.0);
                this.windDirection = spectraMetadata.getAttributeDouble("wind_direction", 0.0);
                this.sarWaveHeight = spectraMetadata.getAttributeDouble("SAR_wave_height", 0.0);
                this.sarAzShiftVar = spectraMetadata.getAttributeDouble("SAR_az_shift_var", 0.0);
                this.backscatter = spectraMetadata.getAttributeDouble("backscatter", 0.0);
            } else {
                this.minReal = spectraMetadata.getAttributeDouble("min_real", 0.0);
                this.maxReal = spectraMetadata.getAttributeDouble("max_real", 255.0);
                this.minImaginary = spectraMetadata.getAttributeDouble("min_imag", 0.0);
                this.maxImaginary = spectraMetadata.getAttributeDouble("max_imag", 255.0);
            }
        }
        catch (Exception e) {
            System.out.println("Unable to get metadata for " + this.spectraMetadataRoot.getName());
        }
        DecimalFormat frmt = new DecimalFormat("0.0000");
        ArrayList<String> metadataList = new ArrayList<String>(10);
        metadataList.add("Time: " + this.zeroDopplerTime.toString());
        metadataList.add("Peak Direction: " + this.maxSpecDir + " deg");
        metadataList.add("Peak Wavelength: " + frmt.format(this.maxSpecWL) + " m");
        if (this.waveProductType == WaveProductType.WAVE_SPECTRA) {
            metadataList.add("Min Spectrum: " + frmt.format(this.minSpectrum));
            metadataList.add("Max Spectrum: " + frmt.format(this.maxSpectrum));
            metadataList.add("Wind Speed: " + this.windSpeed + " m/s");
            metadataList.add("Wind Direction: " + this.windDirection + " deg");
            metadataList.add("SAR Swell Wave Height: " + frmt.format(this.sarWaveHeight) + " m");
            metadataList.add("SAR Azimuth Shift Var: " + frmt.format(this.sarAzShiftVar) + " m^2");
            metadataList.add("Backscatter: " + frmt.format(this.backscatter) + " dB");
        }
        this.polarPanel.setMetadata(metadataList.toArray(new String[metadataList.size()]));
    }

    private float getMinValue(boolean real) {
        if (this.waveProductType == WaveProductType.WAVE_SPECTRA) {
            return (float)this.minSpectrum;
        }
        return real ? (float)this.minReal : (float)this.minImaginary;
    }

    private float getMaxValue(boolean real) {
        if (this.waveProductType == WaveProductType.WAVE_SPECTRA) {
            return (float)this.maxSpectrum;
        }
        return real ? (float)this.maxReal : (float)this.maxImaginary;
    }

    private void createPlot(int rec) {
        float thStep;
        float thFirst;
        this.getSpectraMetadata(rec);
        this.spectrum = this.getSpectrum(0, rec, this.graphUnit != Unit.IMAGINARY);
        float minValue = this.getMinValue(this.graphUnit != Unit.IMAGINARY);
        float maxValue = this.getMaxValue(this.graphUnit != Unit.IMAGINARY);
        if (this.waveProductType == WaveProductType.WAVE_SPECTRA) {
            if (this.graphUnit == Unit.INTENSITY) {
                minValue = Float.MAX_VALUE;
                maxValue = Float.MIN_VALUE;
                for (int i = 0; i < this.spectrum.length; ++i) {
                    for (int j = 0; j < this.spectrum[0].length; ++j) {
                        float val;
                        float realVal = this.spectrum[i][j];
                        this.spectrum[i][j] = val = realVal * realVal;
                        minValue = Math.min(minValue, val);
                        maxValue = Math.max(maxValue, val);
                    }
                }
            }
        } else if (this.graphUnit == Unit.AMPLITUDE || this.graphUnit == Unit.INTENSITY) {
            float[][] imagSpectrum = this.getSpectrum(1, rec, false);
            minValue = Float.MAX_VALUE;
            maxValue = Float.MIN_VALUE;
            for (int i = 0; i < this.spectrum.length; ++i) {
                for (int j = 0; j < this.spectrum[0].length; ++j) {
                    float realVal = this.spectrum[i][j];
                    float imagVal = imagSpectrum[i][j];
                    float val = PolarView.sign(realVal) == PolarView.sign(imagVal) ? realVal * realVal + imagVal * imagVal : 0.0f;
                    if (this.graphUnit == Unit.AMPLITUDE) {
                        val = (float)Math.sqrt(val);
                    }
                    this.spectrum[i][j] = val;
                    minValue = Math.min(minValue, val);
                    maxValue = Math.max(maxValue, val);
                }
            }
        }
        float rStep = (float)(Math.log(this.lastWLBin) - Math.log(this.firstWLBin)) / (float)(this.numWLBins - 1);
        double logr = Math.log(this.firstWLBin) - (double)rStep / 2.0;
        double[] colourRange = new double[]{minValue, maxValue};
        double[] radialRange = new double[]{-10.0, 333.33333333333};
        if (this.waveProductType == WaveProductType.WAVE_SPECTRA) {
            thFirst = this.firstDirBins + 5.0f;
            thStep = -this.dirBinStep;
        } else {
            thFirst = this.firstDirBins - 5.0f;
            thStep = this.dirBinStep;
        }
        int nWl = this.spectrum[0].length;
        float[] radii = new float[nWl + 1];
        for (int j = 0; j <= nWl; ++j) {
            radii[j] = (float)(10000.0 / Math.exp(logr));
            logr += (double)rStep;
        }
        PolarData data = new PolarData(this.spectrum, 90.0f + thFirst, thStep, radii);
        PolarCanvas polarCanvas = this.polarPanel.getPolarCanvas();
        polarCanvas.setAxisNames("Azimuth", "Range");
        if (this.waveProductType == WaveProductType.WAVE_SPECTRA) {
            polarCanvas.setWindDirection(this.windDirection);
            polarCanvas.showWindDirection(true);
            polarCanvas.setAxisNames("North", "East");
        }
        Axis colourAxis = polarCanvas.getColourAxis();
        Axis radialAxis = polarCanvas.getRadialAxis();
        colourAxis.setDataRange(colourRange);
        colourAxis.setUnit(this.unitTypes[this.graphUnit.ordinal()]);
        radialAxis.setAutoRange(false);
        radialAxis.setDataRange(radialRange);
        radialAxis.setRange(radialRange[0], radialRange[1], 4);
        radialAxis.setTitle("Wavelength (m)");
        polarCanvas.setRings(rings, ringTextStrings);
        data.setColorScale(ColourScale.newCustomScale(colourRange));
        polarCanvas.setData(data);
        this.repaint();
        this.controlPanel.updateControls();
    }

    private float[][] getSpectrum(int imageNum, int rec, boolean getReal) {
        float[] dataset;
        try {
            Band rasterNode = this.product.getBandAt(imageNum);
            rasterNode.loadRasterData();
            dataset = new float[this.recordLength];
            rasterNode.getPixels(0, rec, this.recordLength, 1, dataset);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return null;
        }
        float minValue = this.getMinValue(getReal);
        float maxValue = this.getMaxValue(getReal);
        float scale = (maxValue - minValue) / 255.0f;
        float[][] spectrum = new float[this.numDirBins][this.numWLBins];
        int index = 0;
        if (this.waveProductType == WaveProductType.WAVE_SPECTRA) {
            for (int i = 0; i < this.numDirBins; ++i) {
                for (int j = 0; j < this.numWLBins; ++j) {
                    spectrum[i][j] = dataset[index++] * scale + minValue;
                }
            }
        } else {
            int j;
            int i;
            int Nd2 = this.numDirBins / 2;
            for (i = 0; i < Nd2; ++i) {
                for (j = 0; j < this.numWLBins; ++j) {
                    spectrum[i][j] = dataset[index++] * scale + minValue;
                }
            }
            if (getReal) {
                for (i = 0; i < Nd2; ++i) {
                    System.arraycopy(spectrum[i], 0, spectrum[i + Nd2], 0, this.numWLBins);
                }
            } else {
                for (i = 0; i < Nd2; ++i) {
                    for (j = 0; j < this.numWLBins; ++j) {
                        spectrum[i + Nd2][j] = -spectrum[i][j];
                    }
                }
            }
        }
        return spectrum;
    }

    private static int sign(float f) {
        return f < 0.0f ? -1 : 1;
    }

    public JPopupMenu createPopupMenu(Component component) {
        return null;
    }

    public JPopupMenu createPopupMenu(MouseEvent event) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem itemNext = this.createMenuItem("Next");
        popup.add(itemNext);
        itemNext.setEnabled(this.currentRecord < this.numRecords);
        JMenuItem itemPrev = this.createMenuItem("Previous");
        popup.add(itemPrev);
        itemPrev.setEnabled(this.currentRecord > 0);
        JMenuItem itemColourScale = this.createMenuItem("Colour Scale");
        popup.add(itemColourScale);
        JMenu unitMenu = new JMenu("Unit");
        popup.add(unitMenu);
        if (this.waveProductType == WaveProductType.WAVE_SPECTRA) {
            this.createCheckedMenuItem(this.unitTypes[Unit.AMPLITUDE.ordinal()], unitMenu, this.graphUnit == Unit.AMPLITUDE);
            this.createCheckedMenuItem(this.unitTypes[Unit.INTENSITY.ordinal()], unitMenu, this.graphUnit == Unit.INTENSITY);
        } else {
            this.createCheckedMenuItem(this.unitTypes[Unit.REAL.ordinal()], unitMenu, this.graphUnit == Unit.REAL);
            this.createCheckedMenuItem(this.unitTypes[Unit.IMAGINARY.ordinal()], unitMenu, this.graphUnit == Unit.IMAGINARY);
            this.createCheckedMenuItem(this.unitTypes[Unit.AMPLITUDE.ordinal()], unitMenu, this.graphUnit == Unit.AMPLITUDE);
            this.createCheckedMenuItem(this.unitTypes[Unit.INTENSITY.ordinal()], unitMenu, this.graphUnit == Unit.INTENSITY);
        }
        JMenuItem itemExportReadout = this.createMenuItem("Export Readouts");
        popup.add(itemExportReadout);
        popup.setLabel("Justification");
        popup.setBorder(new BevelBorder(0));
        popup.addPopupMenuListener(this);
        popup.show((Component)((Object)this), event.getX(), event.getY());
        return popup;
    }

    private JMenuItem createMenuItem(String name) {
        JMenuItem item = new JMenuItem(name);
        item.setHorizontalTextPosition(4);
        item.addActionListener(this);
        return item;
    }

    private JCheckBoxMenuItem createCheckedMenuItem(String name, JMenu parent, boolean state) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(name);
        item.setHorizontalTextPosition(4);
        item.addActionListener(this);
        parent.add(item);
        return item;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("Next")) {
            this.showNextPlot();
        } else if (event.getActionCommand().equals("Previous")) {
            this.showPreviousPlot();
        } else if (event.getActionCommand().equals("Colour Scale")) {
            this.callColourScaleDlg();
        } else if (event.getActionCommand().equals("Export Readouts")) {
            this.exportReadouts();
        } else if (event.getActionCommand().equals("Real")) {
            this.graphUnit = Unit.REAL;
            this.createPlot(this.currentRecord);
        } else if (event.getActionCommand().equals("Imaginary")) {
            this.graphUnit = Unit.IMAGINARY;
            this.createPlot(this.currentRecord);
        } else if (event.getActionCommand().equals("Amplitude")) {
            this.graphUnit = Unit.AMPLITUDE;
            this.createPlot(this.currentRecord);
        } else if (event.getActionCommand().equals("Intensity")) {
            this.graphUnit = Unit.INTENSITY;
            this.createPlot(this.currentRecord);
        }
    }

    int getCurrentRecord() {
        return this.currentRecord;
    }

    int getNumRecords() {
        return this.numRecords;
    }

    void showNextPlot() {
        this.createPlot(++this.currentRecord);
    }

    void showPreviousPlot() {
        this.createPlot(--this.currentRecord);
    }

    void showPlot(int record) {
        this.currentRecord = record;
        this.createPlot(this.currentRecord);
    }

    void zoomOut() {
        this.createPlot(this.currentRecord);
    }

    void zoomIn() {
        this.createPlot(this.currentRecord);
    }

    private void callColourScaleDlg() {
        PolarCanvas polarCanvas = this.polarPanel.getPolarCanvas();
        ColourScaleDialog dlg = new ColourScaleDialog(polarCanvas.getColourAxis());
        dlg.show();
    }

    private void exportReadouts() {
        File file = FileFolderUtils.GetFilePath("Export Wave Mode Readout", "txt", "txt", this.product.getName() + "_rec" + this.currentRecord, "Wave mode readout", true);
        try {
            this.polarPanel.exportReadout(file);
        }
        catch (Exception e) {
            VisatApp.getApp().showErrorDialog(e.getMessage());
        }
    }

    private void checkPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.createPopupMenu(e);
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.checkPopup(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Axis axis;
        this.checkPopup(e);
        Object src = e.getSource();
        PolarCanvas polarCanvas = this.polarPanel.getPolarCanvas();
        if (src == polarCanvas && (axis = polarCanvas.selectAxis(e.getPoint())) != null && axis == polarCanvas.getColourAxis()) {
            this.callColourScaleDlg();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkPopup(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateReadout(e);
    }

    private void updateReadout(MouseEvent evt) {
        if (this.spectrum == null) {
            return;
        }
        double[] rTh = this.polarPanel.getPolarCanvas().getRTheta(evt.getPoint());
        if (rTh != null) {
            int direction;
            int element;
            int thBin;
            float rStep = (float)(Math.log(this.lastWLBin) - Math.log(this.firstWLBin)) / (float)(this.numWLBins - 1);
            int wvBin = (int)(((double)rStep / 2.0 + Math.log(10000.0 / rTh[0]) - Math.log(this.firstWLBin)) / (double)rStep);
            wvBin = Math.min(wvBin, this.spectrum[0].length - 1);
            int wl = (int)Math.round(Math.exp((double)wvBin * (double)rStep + Math.log(this.firstWLBin)));
            if (this.waveProductType == WaveProductType.CROSS_SPECTRA) {
                float thFirst = this.firstDirBins - 5.0f;
                float thStep = this.dirBinStep;
                thBin = (int)((rTh[1] - (double)thFirst) % 360.0 / (double)thStep);
                element = thBin % (this.spectrum.length / 2) * this.spectrum[0].length + wvBin;
                direction = (int)((float)thBin * thStep + thStep / 2.0f + thFirst);
            } else {
                float thFirst = this.firstDirBins + 5.0f;
                float thStep = -this.dirBinStep;
                thBin = (int)((360.0 - rTh[1] + (double)thFirst) % 360.0 / (double)(-thStep));
                element = thBin * this.spectrum[0].length + wvBin;
                direction = (int)(-((float)thBin * thStep + thStep / 2.0f + thFirst));
            }
            ArrayList<String> readoutList = new ArrayList<String>(5);
            readoutList.add("Record: " + (this.currentRecord + 1) + " of " + (this.numRecords + 1));
            readoutList.add("Wavelength: " + wl + " m");
            readoutList.add("Direction: " + direction + " deg");
            readoutList.add("Bin: " + (thBin + 1) + "," + (wvBin + 1) + " Element: " + element);
            readoutList.add("Value: " + this.spectrum[thBin][wvBin]);
            this.polarPanel.setReadout(readoutList.toArray(new String[readoutList.size()]));
        } else {
            this.polarPanel.setReadout(null);
        }
        this.repaint();
    }

    private static enum WaveProductType {
        CROSS_SPECTRA,
        WAVE_SPECTRA;

    }

    private static enum Unit {
        REAL,
        IMAGINARY,
        AMPLITUDE,
        INTENSITY;

    }
}

