/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.views.polarview;

import java.awt.Graphics;
import java.awt.Point;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

class ReadoutCanvas {
    private final Point readoutOrigin = new Point(20, 40);
    private String[] readoutList = null;
    private String[] metadataList = null;

    public void setReadout(String[] readout) {
        this.readoutList = readout;
    }

    public void setMetadata(String[] metadata) {
        this.metadataList = metadata;
    }

    public void paint(Graphics g) {
        this.draw(g);
    }

    private synchronized void draw(Graphics g) {
        int y;
        int x;
        g.translate(this.readoutOrigin.x, this.readoutOrigin.y);
        if (this.readoutList != null) {
            x = 0;
            y = 0;
            for (String str : this.readoutList) {
                g.drawString(str, x, y);
                y += 20;
            }
        }
        if (this.metadataList != null) {
            g.translate((int)g.getClipBounds().getWidth() - 230, 0);
            x = 0;
            y = 0;
            for (String str : this.metadataList) {
                g.drawString(str, x, y);
                y += 20;
            }
        }
    }

    public void exportReadout(File file) throws IOException {
        if (this.metadataList != null) {
            FileOutputStream out = new FileOutputStream(file.getAbsolutePath(), false);
            PrintStream p = new PrintStream(out);
            if (this.readoutList != null) {
                for (String str : this.readoutList) {
                    p.println(str + ",");
                }
            }
            for (String str : this.metadataList) {
                p.println(str + ",");
            }
        }
    }
}

