/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.wizards;

import java.awt.Component;
import java.io.File;
import javax.swing.JPanel;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.wizards.WizardPanel;
import org.esa.snap.dat.dialogs.FileTable;
import org.esa.snap.dat.dialogs.ProductSetPanel;

public abstract class AbstractMultipleInputPanel
extends WizardPanel {
    protected ProductSetPanel productSetPanel;

    public AbstractMultipleInputPanel() {
        super("Input");
        this.createPanel();
    }

    @Override
    public void returnFromLaterStep() {
    }

    @Override
    public boolean canRedisplayNextPanel() {
        return false;
    }

    @Override
    public boolean hasNextPanel() {
        return true;
    }

    @Override
    public boolean canFinish() {
        return false;
    }

    @Override
    public boolean validateInput() {
        File[] fileList = this.productSetPanel.getFileList();
        if (fileList.length == 0 || fileList.length == 1 && !fileList[0].exists()) {
            AbstractMultipleInputPanel.showErrorMsg("Please add some products to the table");
            return false;
        }
        return true;
    }

    @Override
    public abstract WizardPanel getNextPanel();

    protected String getInstructions() {
        return "Browse for input products with the Add button, use the Add All Open button to add every product opened or drag and drop products into the table.\nSpecify the target folder where the products will be written to.\n";
    }

    private void createPanel() {
        JPanel textPanel = AbstractMultipleInputPanel.createTextPanel("Instructions", this.getInstructions());
        this.add((Component)textPanel, "North");
        this.productSetPanel = new ProductSetPanel((AppContext)VisatApp.getApp(), null, new FileTable(), true, true);
        this.add((Component)this.productSetPanel, "Center");
    }
}

