/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.help.BadIDException;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.esa.beam.framework.help.HelpSys;
import org.esa.beam.util.Debug;
import org.esa.beam.util.logging.BeamLogManager;
import org.esa.nest.dat.wizards.WizardPanel;
import org.jfree.ui.L1R3ButtonPanel;

public class WizardDialog
extends JDialog
implements ActionListener {
    private Object result;
    private int step;
    private WizardPanel currentPanel;
    private String wizardName = "";
    private List<WizardPanel> panels;
    private JButton previousButton;
    private JButton nextButton;
    private JButton finishButton;
    private JButton helpButton;
    private String helpId;
    private HelpBroker helpBroker;

    public WizardDialog(JDialog owner, boolean modal, String title, String helpID, WizardPanel firstPanel) {
        super(owner, title, modal);
        this.init(title, helpID, firstPanel);
        this.setLocation(owner.getSize());
    }

    public WizardDialog(JFrame owner, boolean modal, String title, String helpID, WizardPanel firstPanel) {
        super(owner, title, modal);
        this.init(title, helpID, firstPanel);
        this.setLocation(owner.getSize());
    }

    private void init(String title, String helpID, WizardPanel firstPanel) {
        this.wizardName = title;
        this.result = null;
        this.currentPanel = firstPanel;
        this.currentPanel.setOwner(this);
        this.step = 0;
        this.panels = new ArrayList<WizardPanel>(4);
        this.panels.add(firstPanel);
        this.setContentPane(this.createContent());
        this.setTitle(this.createTitle());
        this.setHelpID(helpID);
        super.setDefaultCloseOperation(2);
    }

    private void setLocation(Dimension ownerDim) {
        int size = 500;
        int half = 250;
        this.setLocation((int)(ownerDim.getWidth() / 2.0) - 250, (int)(ownerDim.getHeight() / 2.0) - 250);
        this.setMinimumSize(new Dimension(500, 500));
    }

    public void setIcon(ImageIcon ico) {
        if (ico == null) {
            return;
        }
        this.setIconImage(ico.getImage());
    }

    public String getHelpID() {
        return this.helpId;
    }

    public void setHelpID(String helpID) {
        this.helpId = helpID;
        this.updateHelpID();
    }

    private void updateHelpID() {
        if (this.helpId == null) {
            return;
        }
        if (this.helpBroker == null) {
            this.initHelpBroker();
        }
        if (this.helpBroker == null) {
            return;
        }
        HelpSet helpSet = this.helpBroker.getHelpSet();
        try {
            this.helpBroker.setCurrentID(this.helpId);
        }
        catch (BadIDException e) {
            Logger systemLogger = BeamLogManager.getSystemLogger();
            if (systemLogger != null) {
                systemLogger.severe("ModalDialog: '" + this.helpId + "' is not a valid helpID");
            }
            Debug.trace((Throwable)e);
        }
        if (helpSet == null) {
            return;
        }
        this.helpBroker.enableHelpKey((Component)this, this.helpId, helpSet);
        if (this.getContentPane() != null) {
            this.helpBroker.enableHelpKey((Component)this.getContentPane(), this.helpId, helpSet);
        }
        if (this.helpButton != null) {
            this.helpBroker.enableHelpKey((Component)this.helpButton, this.helpId, helpSet);
            this.helpBroker.enableHelpOnButton((Component)this.helpButton, this.helpId, helpSet);
        }
    }

    private void initHelpBroker() {
        HelpSet helpSet = HelpSys.getHelpSet();
        if (helpSet != null) {
            this.helpBroker = helpSet.createHelpBroker();
            if (this.helpBroker instanceof DefaultHelpBroker) {
                DefaultHelpBroker defaultHelpBroker = (DefaultHelpBroker)this.helpBroker;
                defaultHelpBroker.setActivationWindow((Window)this);
            }
        }
    }

    public Object getResult() {
        return this.result;
    }

    public int getStepCount() {
        return 0;
    }

    public boolean canDoPreviousPanel() {
        return this.step > 0;
    }

    public boolean canDoNextPanel() {
        return this.currentPanel.hasNextPanel();
    }

    public boolean canFinish() {
        return this.currentPanel.canFinish();
    }

    public WizardPanel getWizardPanel(int step) {
        if (step < this.panels.size()) {
            return this.panels.get(step);
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("nextButton")) {
            this.next();
        } else if (command.equals("previousButton")) {
            this.previous();
        } else if (command.equals("finishButton")) {
            this.finish();
        }
    }

    private String createTitle() {
        String stepStr = "";
        if (this.step != 0) {
            stepStr = "Step " + this.step + ' ';
        }
        return this.wizardName + " : " + stepStr + this.currentPanel.getPanelTitle();
    }

    public void previous() {
        if (this.step > 0) {
            WizardPanel previousPanel = this.getWizardPanel(this.step - 1);
            previousPanel.returnFromLaterStep();
            Container content = this.getContentPane();
            content.remove(this.currentPanel);
            content.add(previousPanel);
            --this.step;
            this.currentPanel = previousPanel;
            this.setTitle(this.createTitle());
            this.enableButtons();
            this.pack();
            this.repaint();
        }
    }

    public void next() {
        if (!this.currentPanel.validateInput()) {
            return;
        }
        WizardPanel nextPanel = this.getWizardPanel(this.step + 1);
        if (nextPanel != null) {
            if (!this.currentPanel.canRedisplayNextPanel()) {
                nextPanel = this.currentPanel.getNextPanel();
            }
        } else {
            nextPanel = this.currentPanel.getNextPanel();
        }
        ++this.step;
        if (this.step < this.panels.size()) {
            this.panels.set(this.step, nextPanel);
        } else {
            this.panels.add(nextPanel);
        }
        Container content = this.getContentPane();
        content.remove(this.currentPanel);
        content.add(nextPanel);
        this.currentPanel = nextPanel;
        this.currentPanel.setOwner(this);
        this.setTitle(this.createTitle());
        this.enableButtons();
        this.pack();
        this.repaint();
    }

    public void finish() {
        this.currentPanel.finish();
    }

    private void enableButtons() {
        this.previousButton.setEnabled(this.step > 0);
        this.nextButton.setEnabled(this.canDoNextPanel());
        this.finishButton.setEnabled(this.canFinish());
        this.helpButton.setEnabled(this.helpId != null);
    }

    public void updateState() {
        this.enableButtons();
        this.repaint();
    }

    public boolean isCancelled() {
        return false;
    }

    public JPanel createContent() {
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        content.add(this.panels.get(0));
        L1R3ButtonPanel buttons = new L1R3ButtonPanel("Help", "Previous", "Next", "Finish");
        this.helpButton = buttons.getLeftButton();
        this.helpButton.setEnabled(false);
        this.previousButton = buttons.getRightButton1();
        this.previousButton.setActionCommand("previousButton");
        this.previousButton.addActionListener(this);
        this.previousButton.setEnabled(false);
        this.nextButton = buttons.getRightButton2();
        this.nextButton.setActionCommand("nextButton");
        this.nextButton.addActionListener(this);
        this.nextButton.setEnabled(true);
        this.finishButton = buttons.getRightButton3();
        this.finishButton.setActionCommand("finishButton");
        this.finishButton.addActionListener(this);
        this.finishButton.setEnabled(false);
        buttons.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        content.add((Component)buttons, "South");
        return content;
    }
}

