/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.toolviews.nestwwview;

import com.bc.ceres.grender.Viewport;
import com.bc.ceres.grender.ViewportListener;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.EarthFlat;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Earth.LandsatI3WMSLayer;
import gov.nasa.worldwind.layers.Earth.MSVirtualEarthLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.SkyGradientLayer;
import gov.nasa.worldwind.layers.WorldMapLayer;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwind.view.orbit.FlatOrbitView;
import gov.nasa.worldwindx.examples.ClickAndGoSelectListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.ui.application.support.AbstractToolView;
import org.esa.beam.framework.ui.product.ProductSceneView;
import org.esa.beam.framework.ui.product.ProductTreeListener;
import org.esa.beam.util.SystemUtils;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.toolviews.nestwwview.MinimalStatusBar;
import org.esa.nest.dat.toolviews.nestwwview.ProductLayer;
import org.esa.nest.dat.toolviews.nestwwview.WWProductTreeListener;
import org.esa.nest.dat.toolviews.nestwwview.WWView;

public class FlatEarthWWToolView
extends AbstractToolView
implements WWView {
    private final VisatApp datApp = VisatApp.getApp();
    private final Dimension canvasSize = new Dimension(800, 600);
    private AppPanel wwjPanel = null;
    private ProductLayer productLayer = null;
    private Position eyePosition = null;
    private ProductSceneView currentView;
    private ObservedViewportHandler observedViewportHandler;
    private static final boolean includeStatusBar = true;
    private static final String useflatWorld = System.getProperty(SystemUtils.getApplicationContextId() + ".use.flat.worldmap");
    private static final boolean flatWorld = useflatWorld == null || !useflatWorld.equals("false");

    public JComponent createControl() {
        Window windowPane = this.getPaneWindow();
        if (windowPane != null) {
            windowPane.setSize(300, 300);
        }
        JPanel mainPane = new JPanel(new BorderLayout(4, 4));
        mainPane.setSize(new Dimension(300, 300));
        this.initialize(mainPane);
        this.observedViewportHandler = new ObservedViewportHandler();
        return mainPane;
    }

    WorldWindowGLCanvas getWwd() {
        if (this.wwjPanel == null) {
            return null;
        }
        return this.wwjPanel.getWwd();
    }

    private void initialize(final JPanel mainPane) {
        final FlatEarthWWToolView toolView = this;
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                try {
                    FlatEarthWWToolView.this.wwjPanel = new AppPanel(FlatEarthWWToolView.this.canvasSize, true);
                    FlatEarthWWToolView.this.wwjPanel.setPreferredSize(FlatEarthWWToolView.this.canvasSize);
                    mainPane.add((Component)FlatEarthWWToolView.this.wwjPanel, "Center");
                    LayerList layerList = FlatEarthWWToolView.this.getWwd().getModel().getLayers();
                    MSVirtualEarthLayer virtualEarthLayerA = new MSVirtualEarthLayer("gov.nasa.worldwind.layers.Earth.MSVirtualEarthLayer.Aerial");
                    virtualEarthLayerA.setName("MS Bing Aerial");
                    layerList.add((Layer)virtualEarthLayerA);
                    FlatEarthWWToolView.this.productLayer = new ProductLayer(false);
                    FlatEarthWWToolView.this.productLayer.setOpacity(1.0);
                    FlatEarthWWToolView.this.productLayer.setPickEnabled(false);
                    FlatEarthWWToolView.this.productLayer.setName("Opened Products");
                    layerList.add((Layer)FlatEarthWWToolView.this.productLayer);
                    Layer placeNameLayer = layerList.getLayerByName("Place Names");
                    placeNameLayer.setEnabled(true);
                    FlatEarthWWToolView.this.datApp.addInternalFrameListener((InternalFrameListener)new WWIFL());
                    FlatEarthWWToolView.this.datApp.addProductTreeListener((ProductTreeListener)new WWProductTreeListener(toolView));
                    FlatEarthWWToolView.this.setProducts(FlatEarthWWToolView.this.datApp.getProductManager().getProducts());
                    FlatEarthWWToolView.this.setSelectedProduct(FlatEarthWWToolView.this.datApp.getSelectedProduct());
                }
                catch (Throwable e) {
                    System.out.println("Can't load openGL " + e.getMessage());
                }
                return null;
            }
        };
        worker.execute();
    }

    private void gotoProduct(Product product) {
        if (product == null) {
            return;
        }
        View theView = this.getWwd().getView();
        Position origPos = theView.getEyePosition();
        GeoCoding geoCoding = product.getGeoCoding();
        if (geoCoding != null) {
            GeoPos centre = product.getGeoCoding().getGeoPos(new PixelPos((float)(product.getSceneRasterWidth() / 2), (float)(product.getSceneRasterHeight() / 2)), null);
            centre.normalize();
            theView.setEyePosition(Position.fromDegrees((double)centre.getLat(), (double)centre.getLon(), (double)origPos.getElevation()));
        }
    }

    public void setCurrentView(ProductSceneView newView) {
        if (this.currentView != newView) {
            Viewport observedViewport;
            ProductSceneView oldView = this.currentView;
            this.currentView = newView;
            if (oldView != null && (observedViewport = oldView.getLayerCanvas().getViewport()) != null) {
                observedViewport.removeListener((ViewportListener)this.observedViewportHandler);
            }
            if (newView != null && (observedViewport = newView.getLayerCanvas().getViewport()) != null) {
                observedViewport.addListener((ViewportListener)this.observedViewportHandler);
            }
        }
    }

    @Override
    public void setSelectedProduct(Product product) {
        if (product == this.getSelectedProduct() && this.eyePosition == this.getWwd().getView().getEyePosition()) {
            return;
        }
        if (this.productLayer != null) {
            this.productLayer.setSelectedProduct(product);
        }
        if (this.isVisible()) {
            this.gotoProduct(product);
            this.getWwd().redrawNow();
            this.eyePosition = this.getWwd().getView().getEyePosition();
        }
    }

    public Product getSelectedProduct() {
        if (this.productLayer != null) {
            return this.productLayer.getSelectedProduct();
        }
        return null;
    }

    @Override
    public void setProducts(Product[] products) {
        if (this.productLayer != null) {
            for (Product prod : products) {
                try {
                    this.productLayer.addProduct(prod);
                }
                catch (Exception e) {
                    this.datApp.showErrorDialog("WorldWind unable to add product " + prod.getName() + '\n' + e.getMessage());
                }
            }
        }
        if (this.isVisible()) {
            this.getWwd().redrawNow();
        }
    }

    @Override
    public void removeProduct(Product product) {
        if (this.getSelectedProduct() == product) {
            this.setSelectedProduct(null);
        }
        if (this.productLayer != null) {
            this.productLayer.removeProduct(product);
        }
        if (this.isVisible()) {
            this.getWwd().redrawNow();
        }
    }

    private class ObservedViewportHandler
    implements ViewportListener {
        private ObservedViewportHandler() {
        }

        public void handleViewportChanged(Viewport observedViewport, boolean orientationChanged) {
        }
    }

    private class WWIFL
    extends InternalFrameAdapter {
        private WWIFL() {
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent e) {
            Container contentPane = e.getInternalFrame().getContentPane();
            Product product = null;
            if (contentPane instanceof ProductSceneView) {
                ProductSceneView view = (ProductSceneView)contentPane;
                FlatEarthWWToolView.this.setCurrentView(view);
                product = view.getProduct();
            }
            FlatEarthWWToolView.this.setSelectedProduct(product);
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent e) {
        }
    }

    public static class AppPanel
    extends JPanel {
        private WorldWindowGLCanvas wwd = new WorldWindowGLCanvas();
        private StatusBar statusBar = null;

        public AppPanel(Dimension canvasSize, boolean includeStatusBar) {
            super(new BorderLayout());
            Model m = (Model)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.ModelClassName");
            this.wwd.setModel(m);
            if (flatWorld) {
                m.setGlobe((Globe)new EarthFlat());
                this.wwd.setView((View)new FlatOrbitView());
            }
            LayerList layerList = m.getLayers();
            for (Layer layer : layerList) {
                if (!(layer instanceof CompassLayer) && !(layer instanceof WorldMapLayer) && !(layer instanceof LandsatI3WMSLayer) && !(layer instanceof SkyGradientLayer)) continue;
                layerList.remove(layer);
            }
            this.wwd.addSelectListener((SelectListener)new ClickAndGoSelectListener((WorldWindow)this.wwd, WorldMapLayer.class));
            this.add((Component)this.wwd, "Center");
            if (includeStatusBar) {
                this.statusBar = new MinimalStatusBar();
                this.add((Component)this.statusBar, "Last");
                this.statusBar.setEventSource((WorldWindow)this.wwd);
            }
        }

        public final WorldWindowGLCanvas getWwd() {
            return this.wwd;
        }

        public final StatusBar getStatusBar() {
            return this.statusBar;
        }
    }
}

