/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.toolviews.nestwwview;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.layers.Layer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

class LayerPanel
extends JPanel {
    private JPanel layersPanel;
    private JPanel westPanel;
    private JScrollPane scrollPane;
    private Font defaultFont;

    public LayerPanel(WorldWindow wwd) {
        super(new BorderLayout());
        this.makePanel(wwd, new Dimension(100, 400));
    }

    public LayerPanel(WorldWindow wwd, Dimension size) {
        super(new BorderLayout());
        this.makePanel(wwd, size);
    }

    private void makePanel(WorldWindow wwd, Dimension size) {
        this.layersPanel = new JPanel(new GridLayout(0, 1, 0, 4));
        this.layersPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.fill(wwd);
        JPanel dummyPanel = new JPanel(new BorderLayout());
        dummyPanel.add((Component)this.layersPanel, "North");
        this.scrollPane = new JScrollPane(dummyPanel);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (size != null) {
            this.scrollPane.setPreferredSize(size);
        }
        this.westPanel = new JPanel(new GridLayout(0, 1, 0, 10));
        this.westPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Layers")));
        this.westPanel.setToolTipText("Layers to Show");
        this.westPanel.add(this.scrollPane);
        this.add((Component)this.westPanel, "Center");
    }

    private void fill(WorldWindow wwd) {
        for (Layer layer : wwd.getModel().getLayers()) {
            if (layer.getName().equalsIgnoreCase("Atmosphere") || layer.getName().equalsIgnoreCase("World Map") || layer.getName().equalsIgnoreCase("Scale bar") || layer.getName().equalsIgnoreCase("Compass")) continue;
            LayerAction action = new LayerAction(layer, wwd, layer.isEnabled());
            JCheckBox jcb = new JCheckBox(action);
            jcb.setSelected(action.selected);
            this.layersPanel.add(jcb);
            if (this.defaultFont != null) continue;
            this.defaultFont = jcb.getFont();
        }
    }

    public void update(WorldWindow wwd) {
        this.layersPanel.removeAll();
        this.fill(wwd);
        this.westPanel.revalidate();
        this.westPanel.repaint();
    }

    @Override
    public void setToolTipText(String string) {
        this.scrollPane.setToolTipText(string);
    }

    private static class LayerAction
    extends AbstractAction {
        final WorldWindow wwd;
        private final Layer layer;
        private final boolean selected;

        public LayerAction(Layer layer, WorldWindow wwd, boolean selected) {
            super(layer.getName());
            this.wwd = wwd;
            this.layer = layer;
            this.selected = selected;
            this.layer.setEnabled(this.selected);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                this.layer.setEnabled(true);
            } else {
                this.layer.setEnabled(false);
            }
            this.wwd.redraw();
        }
    }
}

