/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.toolviews.nestwwview;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Earth;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Earth.MSVirtualEarthLayer;
import gov.nasa.worldwind.layers.Earth.OSMMapnikLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.layers.WorldMapLayer;
import gov.nasa.worldwind.layers.placename.PlaceNameLayer;
import gov.nasa.worldwind.ogc.wms.WMSCapabilities;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import gov.nasa.worldwind.terrain.WMSBasicElevationModel;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwind.view.orbit.BasicOrbitView;
import gov.nasa.worldwind.wms.CapabilitiesRequest;
import gov.nasa.worldwindx.examples.ClickAndGoSelectListener;
import gov.nasa.worldwindx.examples.WMSLayersPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.ui.application.support.AbstractToolView;
import org.esa.beam.framework.ui.command.ExecCommand;
import org.esa.beam.framework.ui.product.ProductSceneView;
import org.esa.beam.framework.ui.product.ProductTreeListener;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.toolviews.nestwwview.LayerPanel;
import org.esa.nest.dat.toolviews.nestwwview.LayerPanelLayer;
import org.esa.nest.dat.toolviews.nestwwview.ProductLayer;
import org.esa.nest.dat.toolviews.nestwwview.ProductPanel;
import org.esa.nest.dat.toolviews.nestwwview.WWProductTreeListener;
import org.esa.nest.dat.toolviews.nestwwview.WWView;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class NestWWToolView
extends AbstractToolView
implements WWView {
    private final VisatApp datApp = VisatApp.getApp();
    private final Dimension canvasSize = new Dimension(800, 600);
    private AppPanel wwjPanel = null;
    private LayerPanel layerPanel = null;
    private ProductPanel productPanel = null;
    private JSlider opacitySlider = null;
    private ProductLayer productLayer = null;
    private final Dimension wmsPanelSize = new Dimension(400, 600);
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private int previousTabIndex = 0;
    private static final boolean includeStatusBar = true;
    private static final boolean includeLayerPanel = false;
    private static final boolean includeProductPanel = true;
    private static final boolean includeWMSPanel = false;
    private static final String[] servers = new String[]{"http://neowms.sci.gsfc.nasa.gov/wms/wms", "http://wms.jpl.nasa.gov/wms.cgi", "http://worldwind46.arc.nasa.gov:8087/wms"};

    public JComponent createControl() {
        this.productLayer = new ProductLayer(true);
        Window windowPane = this.getPaneWindow();
        if (windowPane != null) {
            windowPane.setSize(800, 400);
        }
        JPanel mainPane = new JPanel(new BorderLayout(4, 4));
        mainPane.setSize(new Dimension(300, 300));
        this.initialize(mainPane);
        if (this.wwjPanel == null) {
            return mainPane;
        }
        MSVirtualEarthLayer virtualEarthLayerA = new MSVirtualEarthLayer("gov.nasa.worldwind.layers.Earth.MSVirtualEarthLayer.Aerial");
        virtualEarthLayerA.setName("MS Bing Aerial");
        NestWWToolView.insertTiledLayer((WorldWindow)this.getWwd(), (Layer)virtualEarthLayerA);
        MSVirtualEarthLayer virtualEarthLayerR = new MSVirtualEarthLayer("gov.nasa.worldwind.layers.Earth.MSVirtualEarthLayer.Roads");
        virtualEarthLayerR.setName("MS Bing Roads");
        virtualEarthLayerR.setEnabled(false);
        NestWWToolView.insertTiledLayer((WorldWindow)this.getWwd(), (Layer)virtualEarthLayerR);
        MSVirtualEarthLayer virtualEarthLayerH = new MSVirtualEarthLayer("gov.nasa.worldwind.layers.Earth.MSVirtualEarthLayer.Hybrid");
        virtualEarthLayerH.setName("MS Bing Hybrid");
        virtualEarthLayerH.setEnabled(false);
        NestWWToolView.insertTiledLayer((WorldWindow)this.getWwd(), (Layer)virtualEarthLayerH);
        OSMMapnikLayer streetLayer = new OSMMapnikLayer();
        streetLayer.setOpacity(0.7);
        streetLayer.setEnabled(false);
        streetLayer.setName("Open Street Map");
        NestWWToolView.insertTiledLayer((WorldWindow)this.getWwd(), (Layer)streetLayer);
        this.productLayer.setOpacity(0.8);
        this.productLayer.setPickEnabled(false);
        this.productLayer.setName("Opened Products");
        RenderableLayer testLayer = new RenderableLayer();
        Polyline pLine = new Polyline();
        pLine.setLineWidth(10.0);
        pLine.setFollowTerrain(true);
        ArrayList<Position> positions = new ArrayList<Position>();
        positions.add(new Position(Angle.fromDegreesLatitude((double)10.0), Angle.fromDegreesLongitude((double)10.0), 0.0));
        positions.add(new Position(Angle.fromDegreesLatitude((double)10.0), Angle.fromDegreesLongitude((double)20.0), 0.0));
        positions.add(new Position(Angle.fromDegreesLatitude((double)20.0), Angle.fromDegreesLongitude((double)20.0), 0.0));
        positions.add(new Position(Angle.fromDegreesLatitude((double)20.0), Angle.fromDegreesLongitude((double)10.0), 0.0));
        positions.add(new Position(Angle.fromDegreesLatitude((double)10.0), Angle.fromDegreesLongitude((double)10.0), 0.0));
        pLine.setPositions(positions);
        testLayer.addRenderable((Renderable)pLine);
        AnnotationAttributes controlPointsAttributes = new AnnotationAttributes();
        controlPointsAttributes.setFrameShape("gov.nasa.worldwind.avkey.ShapeRectangle");
        controlPointsAttributes.setLeader("gov.nasa.worldwind.avkey.ShapeNone");
        controlPointsAttributes.setAdjustWidthToText("gov.nasa.worldwind.avkey.SizeFixed");
        controlPointsAttributes.setSize(new Dimension(12, 12));
        controlPointsAttributes.setDrawOffset(new Point(0, -4));
        controlPointsAttributes.setInsets(new Insets(0, 0, 0, 0));
        controlPointsAttributes.setBorderWidth(0.0);
        controlPointsAttributes.setCornerRadius(0);
        controlPointsAttributes.setBackgroundColor(Color.BLUE);
        controlPointsAttributes.setTextColor(Color.GREEN);
        controlPointsAttributes.setHighlightScale(1.2);
        controlPointsAttributes.setDistanceMaxScale(1.0);
        controlPointsAttributes.setDistanceMinScale(1.0);
        controlPointsAttributes.setDistanceMinOpacity(1.0);
        Position pos = new Position(Angle.fromDegreesLatitude((double)10.0), Angle.fromDegreesLongitude((double)10.0), 0.0);
        GlobeAnnotation currControlPoint = new GlobeAnnotation("Test Point", pos, controlPointsAttributes);
        testLayer.addRenderable((Renderable)currControlPoint);
        this.getWwd().getModel().getLayers().add((Layer)testLayer);
        NestWWToolView.insertTiledLayer((WorldWindow)this.getWwd(), (Layer)this.productLayer);
        this.datApp.addInternalFrameListener((InternalFrameListener)new WWIFL());
        this.datApp.addProductTreeListener((ProductTreeListener)new WWProductTreeListener(this));
        this.setProducts(this.datApp.getProductManager().getProducts());
        this.setSelectedProduct(this.datApp.getSelectedProduct());
        return mainPane;
    }

    WorldWindowGLCanvas getWwd() {
        if (this.wwjPanel == null) {
            return null;
        }
        return this.wwjPanel.getWwd();
    }

    private static void insertTiledLayer(WorldWindow wwd, Layer layer) {
        int position = 0;
        LayerList layers = wwd.getModel().getLayers();
        for (Layer l : layers) {
            if (!(l instanceof PlaceNameLayer)) continue;
            position = layers.indexOf((Object)l);
            break;
        }
        layers.add(position, layer);
    }

    private void initialize(JPanel mainPane) {
        try {
            this.wwjPanel = new AppPanel(this.canvasSize, true);
            this.wwjPanel.setPreferredSize(this.canvasSize);
            mainPane.add((Component)this.wwjPanel, "Center");
            this.productPanel = new ProductPanel((WorldWindow)this.wwjPanel.getWwd(), this.productLayer);
            mainPane.add((Component)this.productPanel, "West");
            this.productPanel.add((Component)this.makeControlPanel(), "South");
            this.productPanel.update((WorldWindow)this.getWwd());
            this.wwjPanel.getWwd().addSelectListener(new SelectListener(){

                public void selected(SelectEvent event) {
                    System.out.println(event.getTopObject());
                    System.out.println(event.getEventAction());
                    if (event.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick")) {
                        System.out.println("selectedProduct " + NestWWToolView.this.getSelectedProduct());
                        ExecCommand command = NestWWToolView.this.datApp.getCommandManager().getExecCommand("showPolarWaveView");
                        command.execute((Object)2);
                    }
                }
            });
        }
        catch (Throwable e) {
            System.out.println("Can't load openGL " + e.getMessage());
        }
    }

    private JPanel makeControlPanel() {
        JPanel controlPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        this.opacitySlider = new JSlider();
        this.opacitySlider.setMaximum(100);
        this.opacitySlider.setValue((int)(this.productLayer.getOpacity() * 100.0));
        this.opacitySlider.setEnabled(true);
        this.opacitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = NestWWToolView.this.opacitySlider.getValue();
                NestWWToolView.this.productLayer.setOpacity((double)value / 100.0);
                NestWWToolView.this.getWwd().repaint();
            }
        });
        JPanel opacityPanel = new JPanel(new BorderLayout(5, 5));
        opacityPanel.add((Component)new JLabel("Opacity"), "West");
        opacityPanel.add((Component)this.opacitySlider, "Center");
        controlPanel.add(opacityPanel);
        controlPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        return controlPanel;
    }

    private void LoadDEM() {
    }

    @Override
    public void setSelectedProduct(Product product) {
        if (this.productLayer != null) {
            this.productLayer.setSelectedProduct(product);
        }
        if (this.productPanel != null) {
            this.productPanel.update((WorldWindow)this.getWwd());
        }
        if (this.isVisible()) {
            this.getWwd().redrawNow();
        }
    }

    public Product getSelectedProduct() {
        if (this.productLayer != null) {
            return this.productLayer.getSelectedProduct();
        }
        return null;
    }

    @Override
    public void setProducts(Product[] products) {
        if (this.productLayer != null) {
            for (Product prod : products) {
                try {
                    this.productLayer.addProduct(prod);
                }
                catch (Exception e) {
                    this.datApp.showErrorDialog("WorldWind unable to add product " + prod.getName() + "\n" + e.getMessage());
                }
            }
        }
        if (this.productPanel != null) {
            this.productPanel.update((WorldWindow)this.getWwd());
        }
        if (this.isVisible()) {
            this.getWwd().redrawNow();
        }
    }

    @Override
    public void removeProduct(Product product) {
        if (this.getSelectedProduct() == product) {
            this.setSelectedProduct(null);
        }
        if (this.productLayer != null) {
            this.productLayer.removeProduct(product);
        }
        if (this.productPanel != null) {
            this.productPanel.update((WorldWindow)this.getWwd());
        }
        if (this.isVisible()) {
            this.getWwd().redrawNow();
        }
    }

    private WMSLayersPanel addTab(int position, String server) {
        try {
            WMSLayersPanel layersPanel = new WMSLayersPanel((WorldWindow)this.wwjPanel.getWwd(), server, this.wmsPanelSize);
            this.tabbedPane.add((Component)layersPanel, "Center");
            String title = layersPanel.getServerDisplayString();
            this.tabbedPane.setTitleAt(position, title != null && title.length() > 0 ? title : server);
            layersPanel.addPropertyChangeListener("LayersPanelUpdated", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    NestWWToolView.this.layerPanel.update((WorldWindow)NestWWToolView.this.wwjPanel.getWwd());
                }
            });
            return layersPanel;
        }
        catch (URISyntaxException e) {
            JOptionPane.showMessageDialog(null, "Server URL is invalid", "Invalid Server URL", 0);
            this.tabbedPane.setSelectedIndex(this.previousTabIndex);
            return null;
        }
    }

    private static ElevationModel makeElevationModel() throws URISyntaxException, ParserConfigurationException, IOException, SAXException {
        URI serverURI = new URI("http://www.nasa.network.com/elev");
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        if ((double)Configuration.getJavaVersion() >= 1.6) {
            try {
                docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (ParserConfigurationException e) {
                String message = Logging.getMessage((String)"XML.NonvalidatingNotSupported");
                Logging.logger().finest(message);
            }
        }
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        CapabilitiesRequest req = new CapabilitiesRequest(serverURI);
        Document doc = docBuilder.parse(req.toString());
        WMSCapabilities caps = new WMSCapabilities((Object)doc);
        double HEIGHT_OF_MT_EVEREST = 8850.0;
        double DEPTH_OF_MARIANAS_TRENCH = -11000.0;
        AVListImpl params = new AVListImpl();
        params.setValue("gov.nasa.worldwind.avkey.LayerNames", (Object)"|srtm3");
        params.setValue("gov.nasa.worldwind.avkey.TileWidthKey", (Object)150);
        params.setValue("gov.nasa.worldwind.avkey.TileHeightKey", (Object)150);
        params.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", (Object)LatLon.fromDegrees((double)20.0, (double)20.0));
        params.setValue("gov.nasa.worldwind.avkey.NumLevels", (Object)8);
        params.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", (Object)0);
        params.setValue("gov.nasa.worldwind.avkey.ElevationMinKey", (Object)-11000.0);
        params.setValue("gov.nasa.worldwind.avkey.ElevationMaxKey", (Object)8850.0);
        CompoundElevationModel cem = new CompoundElevationModel();
        cem.addElevationModel((ElevationModel)new WMSBasicElevationModel(caps, (AVList)params));
        return cem;
    }

    private class WWIFL
    extends InternalFrameAdapter {
        private WWIFL() {
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent e) {
            Container contentPane = e.getInternalFrame().getContentPane();
            Product product = null;
            if (contentPane instanceof ProductSceneView) {
                product = ((ProductSceneView)contentPane).getProduct();
            }
            NestWWToolView.this.setSelectedProduct(product);
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent e) {
        }
    }

    public static class AppPanel
    extends JPanel {
        private final WorldWindowGLCanvas wwd = new WorldWindowGLCanvas();
        private StatusBar statusBar = null;

        public AppPanel(Dimension canvasSize, boolean includeStatusBar) {
            super(new BorderLayout());
            this.wwd.setPreferredSize(canvasSize);
            Model m = (Model)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.ModelClassName");
            this.wwd.setModel(m);
            m.setGlobe((Globe)new Earth());
            this.wwd.setView((View)new BasicOrbitView());
            this.wwd.addSelectListener((SelectListener)new ClickAndGoSelectListener((WorldWindow)this.getWwd(), WorldMapLayer.class));
            this.add((Component)this.wwd, "Center");
            if (includeStatusBar) {
                this.statusBar = new StatusBar();
                this.add((Component)this.statusBar, "Last");
                this.statusBar.setEventSource((WorldWindow)this.wwd);
            }
            m.getLayers().add((Layer)new LayerPanelLayer((WorldWindow)this.getWwd()));
            try {
                ElevationModel em = NestWWToolView.makeElevationModel();
                m.getGlobe().setElevationModel(em);
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        public final WorldWindowGLCanvas getWwd() {
            return this.wwd;
        }

        public final StatusBar getStatusBar() {
            return this.statusBar;
        }
    }
}

