/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.toolviews.nestwwview;

import com.bc.ceres.core.ProgressMonitor;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceImage;
import gov.nasa.worldwind.util.BufferFactory;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwindx.examples.analytics.AnalyticSurface;
import gov.nasa.worldwindx.examples.analytics.AnalyticSurfaceAttributes;
import gov.nasa.worldwindx.examples.analytics.AnalyticSurfaceLegend;
import gov.nasa.worldwindx.examples.util.DirectedPath;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.SwingWorker;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.ImageInfo;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.GPF;
import org.esa.beam.util.ProductUtils;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.eo.GeoUtils;
import org.esa.snap.gpf.OperatorUtils;

public class ProductLayer
extends RenderableLayer {
    private Product selectedProduct = null;
    private final boolean enableSurfaceImages;
    private final ConcurrentHashMap<String, Polyline[]> outlineTable = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, SurfaceImage> imageTable = new ConcurrentHashMap();

    ProductLayer(boolean showSurfaceImages) {
        this.enableSurfaceImages = showSurfaceImages;
    }

    public String[] getProductNames() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.outlineTable.keySet())).toArray(new String[this.outlineTable.size()]);
    }

    private static String getUniqueName(Product product) {
        return product.getProductRefString();
    }

    public void setOpacity(double opacity) {
        super.setOpacity(opacity);
        for (Map.Entry<String, SurfaceImage> entry : this.imageTable.entrySet()) {
            entry.getValue().setOpacity(opacity);
        }
    }

    public void setOpacity(String name, double opacity) {
        SurfaceImage img = this.imageTable.get(name);
        if (img != null) {
            img.setOpacity(opacity);
        }
    }

    public double getOpacity(String name) {
        SurfaceImage img = this.imageTable.get(name);
        if (img != null) {
            return img.getOpacity();
        }
        Polyline[] lineList = this.outlineTable.get(name);
        return lineList != null ? 1.0 : 0.0;
    }

    public void setSelectedProduct(Product product) {
        this.selectedProduct = product;
        if (this.selectedProduct != null) {
            String selName = ProductLayer.getUniqueName(this.selectedProduct);
            for (String name : this.outlineTable.keySet()) {
                Polyline[] lineList = this.outlineTable.get(name);
                boolean highlight = name.equals(selName);
                for (Polyline line : lineList) {
                    line.setHighlighted(highlight);
                    line.setHighlightColor(Color.RED);
                }
            }
        }
    }

    public Product getSelectedProduct() {
        return this.selectedProduct;
    }

    public void addProduct(Product product) {
        String name = ProductLayer.getUniqueName(product);
        if (this.outlineTable.get(name) != null) {
            return;
        }
        GeoCoding geoCoding = product.getGeoCoding();
        if (geoCoding == null) {
            String productType = product.getProductType();
            if (productType.equals("ASA_WVW_2P") || productType.equals("ASA_WVS_1P") || productType.equals("ASA_WVI_1P")) {
                this.addWaveProduct(product);
            }
        } else {
            try {
                if (product.getName().indexOf("_OCN_") >= 0) {
                    Product newProduct = product;
                    System.out.println("product " + product.getName());
                    Band lonBand = newProduct.getBand("hh_001_owiLon");
                    Band latBand = newProduct.getBand("hh_001_owiLat");
                    Band incAngleBand = newProduct.getBand("hh_001_owiIncidenceAngle");
                    Band windSpeedBand = newProduct.getBand("hh_001_owiWindSpeed");
                    Band windDirBand = newProduct.getBand("hh_001_owiWindDirection");
                    Band oswLonBand = newProduct.getBand("hh_001_oswLon");
                    Band oswLatBand = newProduct.getBand("hh_001_oswLat");
                    Band oswWindDirBand = newProduct.getBand("hh_001_oswWindDirection");
                    Band rvlLonBand = newProduct.getBand("hh_001_rvlLon");
                    Band rvlLatBand = newProduct.getBand("hh_001_rvlLat");
                    Band rvlRadVelBand = newProduct.getBand("hh_001_rvlRadVel");
                    System.out.println("band 0 " + lonBand);
                    System.out.println("band width " + lonBand.getRasterWidth());
                    System.out.println("band height " + lonBand.getRasterHeight());
                    float[] lonValues = new float[lonBand.getRasterWidth() * lonBand.getRasterHeight()];
                    lonBand.readPixels(0, 0, lonBand.getRasterWidth(), lonBand.getRasterHeight(), lonValues, ProgressMonitor.NULL);
                    float[] latValues = new float[latBand.getRasterWidth() * latBand.getRasterHeight()];
                    latBand.readPixels(0, 0, latBand.getRasterWidth(), latBand.getRasterHeight(), latValues, ProgressMonitor.NULL);
                    float[] incAngleValues = new float[incAngleBand.getRasterWidth() * incAngleBand.getRasterHeight()];
                    incAngleBand.readPixels(0, 0, incAngleBand.getRasterWidth(), incAngleBand.getRasterHeight(), incAngleValues, ProgressMonitor.NULL);
                    float[] windSpeedValues = new float[windSpeedBand.getRasterWidth() * windSpeedBand.getRasterHeight()];
                    windSpeedBand.readPixels(0, 0, windSpeedBand.getRasterWidth(), windSpeedBand.getRasterHeight(), windSpeedValues, ProgressMonitor.NULL);
                    float[] windDirValues = new float[windDirBand.getRasterWidth() * windDirBand.getRasterHeight()];
                    windDirBand.readPixels(0, 0, windDirBand.getRasterWidth(), windDirBand.getRasterHeight(), windDirValues, ProgressMonitor.NULL);
                    float[] oswLonValues = new float[oswLonBand.getRasterWidth() * oswLonBand.getRasterHeight()];
                    incAngleBand.readPixels(0, 0, oswLonBand.getRasterWidth(), oswLonBand.getRasterHeight(), oswLonValues, ProgressMonitor.NULL);
                    float[] oswLatValues = new float[oswLatBand.getRasterWidth() * oswLatBand.getRasterHeight()];
                    oswLatBand.readPixels(0, 0, oswLatBand.getRasterWidth(), oswLatBand.getRasterHeight(), oswLatValues, ProgressMonitor.NULL);
                    float[] oswWindDirValues = new float[oswWindDirBand.getRasterWidth() * oswWindDirBand.getRasterHeight()];
                    oswWindDirBand.readPixels(0, 0, oswWindDirBand.getRasterWidth(), oswWindDirBand.getRasterHeight(), oswWindDirValues, ProgressMonitor.NULL);
                    float[] rvlLonValues = new float[rvlLonBand.getRasterWidth() * rvlLonBand.getRasterHeight()];
                    rvlLonBand.readPixels(0, 0, rvlLonBand.getRasterWidth(), rvlLonBand.getRasterHeight(), rvlLonValues, ProgressMonitor.NULL);
                    float[] rvlLatValues = new float[rvlLatBand.getRasterWidth() * rvlLatBand.getRasterHeight()];
                    windSpeedBand.readPixels(0, 0, rvlLatBand.getRasterWidth(), rvlLatBand.getRasterHeight(), rvlLatValues, ProgressMonitor.NULL);
                    float[] rvlRadVelValues = new float[rvlRadVelBand.getRasterWidth() * rvlRadVelBand.getRasterHeight()];
                    rvlRadVelBand.readPixels(0, 0, rvlRadVelBand.getRasterWidth(), rvlRadVelBand.getRasterHeight(), rvlRadVelValues, ProgressMonitor.NULL);
                    GeoPos geoPos1 = product.getGeoCoding().getGeoPos(new PixelPos(0.0f, 0.0f), null);
                    GeoPos geoPos2 = product.getGeoCoding().getGeoPos(new PixelPos((float)(product.getSceneRasterWidth() - 1), (float)(product.getSceneRasterHeight() - 1)), null);
                    double HUE_BLUE = 0.6666666666666666;
                    double HUE_RED = 0.0;
                    double minValue = -400000.0;
                    double maxValue = 100000.0;
                    ProductLayer.createRandomColorSurface(geoPos2.getLat(), geoPos1.getLat(), geoPos1.getLon(), geoPos2.getLon(), HUE_BLUE, HUE_RED, 40, 40, minValue, maxValue, this);
                    System.out.println("geoPos1.getLat(), geoPos2.getLat(), geoPos1.getLon(), geoPos2.getLon() " + geoPos1.getLat() + " " + geoPos2.getLat() + " " + geoPos1.getLon() + " " + geoPos2.getLon());
                    BasicShapeAttributes attrs = new BasicShapeAttributes();
                    attrs.setOutlineMaterial(Material.BLACK);
                    attrs.setOutlineWidth(2.0);
                    DecimalFormat legendLabelFormat = new DecimalFormat("# m/s");
                    AnalyticSurfaceLegend legend = AnalyticSurfaceLegend.fromColorGradient((double)minValue, (double)maxValue, (double)HUE_BLUE, (double)HUE_RED, (Iterable)AnalyticSurfaceLegend.createDefaultColorGradientLabels((double)minValue, (double)maxValue, (Format)legendLabelFormat), (AnalyticSurfaceLegend.LabelAttributes)AnalyticSurfaceLegend.createDefaultTitle((String)"Wind Speed"));
                    legend.setOpacity(0.8);
                    legend.setScreenLocation(new Point(650, 300));
                    this.addRenderable((Renderable)legend);
                    for (int i = 0; i < latValues.length; ++i) {
                        Position startPos = new Position(Angle.fromDegreesLatitude((double)latValues[i]), Angle.fromDegreesLongitude((double)lonValues[i]), 10.0);
                        Position endPos = new Position(LatLon.greatCircleEndPosition((LatLon)startPos, (Angle)Angle.fromDegrees((double)windDirValues[i]), (Angle)Angle.fromDegrees((double)0.01)), 10.0);
                        ArrayList<Position> positions = new ArrayList<Position>();
                        positions.add(startPos);
                        positions.add(endPos);
                        DirectedPath directedPath = new DirectedPath(positions);
                        directedPath.setAttributes((ShapeAttributes)attrs);
                        directedPath.setVisible(true);
                        directedPath.setAltitudeMode(2);
                        directedPath.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
                        this.addRenderable((Renderable)directedPath);
                    }
                }
            }
            catch (Exception e) {
                System.out.println("exception " + e);
                e.printStackTrace();
            }
            if (product.getName().indexOf("_OCN_") < 0 && this.enableSurfaceImages) {
                this.addSurfaceImage(product);
            }
            this.addOutline(product);
        }
    }

    private void addSurfaceImage(final Product product) {
        final String name = ProductLayer.getUniqueName(product);
        SwingWorker worker = new SwingWorker(){

            protected SurfaceImage doInBackground() throws Exception {
                Product newProduct = ProductLayer.createSubsampledProduct(product);
                Band band = newProduct.getBandAt(0);
                BufferedImage image = ProductUtils.createRgbImage((RasterDataNode[])new RasterDataNode[]{band}, (ImageInfo)band.getImageInfo(ProgressMonitor.NULL), (ProgressMonitor)ProgressMonitor.NULL);
                GeoPos geoPos1 = product.getGeoCoding().getGeoPos(new PixelPos(0.0f, 0.0f), null);
                GeoPos geoPos2 = product.getGeoCoding().getGeoPos(new PixelPos((float)(product.getSceneRasterWidth() - 1), (float)(product.getSceneRasterHeight() - 1)), null);
                Sector sector = new Sector(Angle.fromDegreesLatitude((double)geoPos1.getLat()), Angle.fromDegreesLatitude((double)geoPos2.getLat()), Angle.fromDegreesLongitude((double)geoPos1.getLon()), Angle.fromDegreesLongitude((double)geoPos2.getLon()));
                SurfaceImage si = new SurfaceImage((Object)image, sector);
                si.setOpacity(ProductLayer.this.getOpacity());
                return si;
            }

            @Override
            public void done() {
                try {
                    if (ProductLayer.this.imageTable.contains(name)) {
                        ProductLayer.this.removeImage(name);
                    }
                    SurfaceImage si = (SurfaceImage)this.get();
                    ProductLayer.this.addRenderable((Renderable)si);
                    ProductLayer.this.imageTable.put(name, si);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        worker.execute();
    }

    protected static void createRandomColorSurface(double minLat, double maxLat, double minLon, double maxLon, double minHue, double maxHue, int width, int height, double minValue, double maxValue, RenderableLayer outLayer) {
        AnalyticSurface surface = new AnalyticSurface();
        surface.setSector(Sector.fromDegrees((double)minLat, (double)maxLat, (double)minLon, (double)maxLon));
        surface.setAltitudeMode(1);
        surface.setDimensions(width, height);
        surface.setClientLayer((Layer)outLayer);
        outLayer.addRenderable((Renderable)surface);
        BufferWrapper secondBuffer = ProductLayer.randomGridValues(width, height, minValue, maxValue);
        ArrayList<AnalyticSurface.GridPointAttributes> attributesList = new ArrayList<AnalyticSurface.GridPointAttributes>();
        for (int i = 0; i < secondBuffer.length(); ++i) {
            attributesList.add(AnalyticSurface.createColorGradientAttributes((double)secondBuffer.getDouble(i), (double)minValue, (double)maxValue, (double)minHue, (double)maxHue));
        }
        surface.setValues(attributesList);
        AnalyticSurfaceAttributes attr = new AnalyticSurfaceAttributes();
        attr.setDrawShadow(false);
        attr.setInteriorOpacity(0.6);
        attr.setDrawOutline(false);
        surface.setSurfaceAttributes(attr);
    }

    public static BufferWrapper randomGridValues(int width, int height, double min, double max, int numIterations, double smoothness, BufferFactory factory) {
        int numValues = width * height;
        double[] values = new double[numValues];
        for (int i = 0; i < numIterations; ++i) {
            double offset = 1.0 - (double)i / (double)numIterations;
            int x1 = (int)Math.round(Math.random() * (double)(width - 1));
            int x2 = (int)Math.round(Math.random() * (double)(width - 1));
            int y1 = (int)Math.round(Math.random() * (double)(height - 1));
            int y2 = (int)Math.round(Math.random() * (double)(height - 1));
            int dx1 = x2 - x1;
            int dy1 = y2 - y1;
            for (int y = 0; y < height; ++y) {
                int dy2 = y - y1;
                for (int x = 0; x < width; ++x) {
                    int dx2 = x - x1;
                    if (dx2 * dy1 - dx1 * dy2 < 0) continue;
                    int n = x + y * width;
                    values[n] = values[n] + offset;
                }
            }
        }
        ProductLayer.smoothValues(width, height, values, smoothness);
        ProductLayer.scaleValues(values, numValues, min, max);
        BufferWrapper buffer = factory.newBuffer(numValues);
        buffer.putDouble(0, values, 0, numValues);
        return buffer;
    }

    public static BufferWrapper randomGridValues(int width, int height, double min, double max) {
        return ProductLayer.randomGridValues(width, height, min, max, 1000, 0.5, (BufferFactory)new BufferFactory.DoubleBufferFactory());
    }

    protected static void scaleValues(double[] values, int count, double minValue, double maxValue) {
        int i;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (i = 0; i < count; ++i) {
            if (min > values[i]) {
                min = values[i];
            }
            if (!(max < values[i])) continue;
            max = values[i];
        }
        for (i = 0; i < count; ++i) {
            values[i] = (values[i] - min) / (max - min);
            values[i] = minValue + values[i] * (maxValue - minValue);
        }
    }

    protected static void smoothValues(int width, int height, double[] values, double smoothness) {
        for (int x = 0; x < width; ++x) {
            ProductLayer.smoothBand(values, x, width, height, smoothness);
        }
        int lastRowOffset = (height - 1) * width;
        for (int x = 0; x < width; ++x) {
            ProductLayer.smoothBand(values, x + lastRowOffset, -width, height, smoothness);
        }
        for (int y = 0; y < height; ++y) {
            ProductLayer.smoothBand(values, y * width, 1, width, smoothness);
        }
        int lastColOffset = width - 1;
        for (int y = 0; y < height; ++y) {
            ProductLayer.smoothBand(values, lastColOffset + y * width, -1, width, smoothness);
        }
    }

    protected static void smoothBand(double[] values, int start, int stride, int count, double smoothness) {
        double prevValue = values[start];
        int j = start + stride;
        for (int i = 0; i < count - 1; ++i) {
            values[j] = smoothness * prevValue + (1.0 - smoothness) * values[j];
            prevValue = values[j];
            j += stride;
        }
    }

    private void addOutline(Product product) {
        int step = Math.max(16, (product.getSceneRasterWidth() + product.getSceneRasterHeight()) / 250);
        GeneralPath[] boundaryPaths = ProductUtils.createGeoBoundaryPaths((Product)product, null, (int)step);
        Polyline[] polyLineList = new Polyline[boundaryPaths.length];
        int i = 0;
        for (GeneralPath boundaryPath : boundaryPaths) {
            PathIterator it = boundaryPath.getPathIterator(null);
            float[] floats = new float[2];
            ArrayList<Position> positions = new ArrayList<Position>(4);
            it.currentSegment(floats);
            Position firstPosition = new Position(Angle.fromDegreesLatitude((double)floats[1]), Angle.fromDegreesLongitude((double)floats[0]), 0.0);
            positions.add(firstPosition);
            it.next();
            while (!it.isDone()) {
                it.currentSegment(floats);
                positions.add(new Position(Angle.fromDegreesLatitude((double)floats[1]), Angle.fromDegreesLongitude((double)floats[0]), 0.0));
                it.next();
            }
            positions.add(firstPosition);
            polyLineList[i] = new Polyline();
            polyLineList[i].setFollowTerrain(true);
            polyLineList[i].setPositions(positions);
            this.addRenderable((Renderable)polyLineList[i]);
            ++i;
        }
        this.outlineTable.put(ProductLayer.getUniqueName(product), polyLineList);
    }

    private void addWaveProduct(Product product) {
        MetadataElement root = AbstractMetadata.getOriginalProductMetadata((Product)product);
        MetadataElement ggADS = root.getElement("GEOLOCATION_GRID_ADS");
        if (ggADS == null) {
            return;
        }
        MetadataElement[] geoElemList = ggADS.getElements();
        Polyline[] lineList = new Polyline[geoElemList.length];
        int cnt = 0;
        for (MetadataElement geoElem : geoElemList) {
            double lat = geoElem.getAttributeDouble("center_lat", 0.0) / 1000000.0;
            double lon = geoElem.getAttributeDouble("center_long", 0.0) / 1000000.0;
            double heading = geoElem.getAttributeDouble("heading", 0.0);
            GeoUtils.LatLonHeading r1 = GeoUtils.vincenty_direct((double)lon, (double)lat, (double)5000.0, (double)heading);
            GeoUtils.LatLonHeading corner1 = GeoUtils.vincenty_direct((double)r1.lon, (double)r1.lat, (double)2500.0, (double)(heading - 90.0));
            GeoUtils.LatLonHeading corner2 = GeoUtils.vincenty_direct((double)r1.lon, (double)r1.lat, (double)2500.0, (double)(heading + 90.0));
            GeoUtils.LatLonHeading r2 = GeoUtils.vincenty_direct((double)lon, (double)lat, (double)5000.0, (double)(heading + 180.0));
            GeoUtils.LatLonHeading corner3 = GeoUtils.vincenty_direct((double)r2.lon, (double)r2.lat, (double)2500.0, (double)(heading - 90.0));
            GeoUtils.LatLonHeading corner4 = GeoUtils.vincenty_direct((double)r2.lon, (double)r2.lat, (double)2500.0, (double)(heading + 90.0));
            ArrayList<Position> positions = new ArrayList<Position>(4);
            positions.add(new Position(Angle.fromDegreesLatitude((double)corner1.lat), Angle.fromDegreesLongitude((double)corner1.lon), 0.0));
            positions.add(new Position(Angle.fromDegreesLatitude((double)corner2.lat), Angle.fromDegreesLongitude((double)corner2.lon), 0.0));
            positions.add(new Position(Angle.fromDegreesLatitude((double)corner4.lat), Angle.fromDegreesLongitude((double)corner4.lon), 0.0));
            positions.add(new Position(Angle.fromDegreesLatitude((double)corner3.lat), Angle.fromDegreesLongitude((double)corner3.lon), 0.0));
            positions.add(new Position(Angle.fromDegreesLatitude((double)corner1.lat), Angle.fromDegreesLongitude((double)corner1.lon), 0.0));
            Polyline line = new Polyline();
            line.setFollowTerrain(true);
            line.setPositions(positions);
            this.addRenderable((Renderable)line);
            lineList[cnt++] = line;
        }
        this.outlineTable.put(ProductLayer.getUniqueName(product), lineList);
    }

    public void removeProduct(Product product) {
        this.removeOutline(ProductLayer.getUniqueName(product));
        this.removeImage(ProductLayer.getUniqueName(product));
    }

    private void removeOutline(String imagePath) {
        Polyline[] lineList = this.outlineTable.get(imagePath);
        if (lineList != null) {
            for (Polyline line : lineList) {
                this.removeRenderable((Renderable)line);
            }
            this.outlineTable.remove(imagePath);
        }
    }

    private void removeImage(String imagePath) {
        SurfaceImage si = this.imageTable.get(imagePath);
        if (si != null) {
            this.removeRenderable((Renderable)si);
            this.imageTable.remove(imagePath);
        }
    }

    private static Product createSubsampledProduct(Product product) throws IOException {
        String quicklookBandName = ProductUtils.findSuitableQuicklookBandName((Product)product);
        ProductSubsetDef productSubsetDef = new ProductSubsetDef("subset");
        int scaleFactor = product.getSceneRasterWidth() / 1000;
        if (scaleFactor < 1) {
            scaleFactor = 1;
        }
        productSubsetDef.setSubSampling(scaleFactor, scaleFactor);
        productSubsetDef.setTreatVirtualBandsAsRealBands(true);
        productSubsetDef.setNodeNames(new String[]{quicklookBandName});
        Product productSubset = product.createSubset(productSubsetDef, quicklookBandName, null);
        if (!OperatorUtils.isMapProjected((Product)product)) {
            try {
                HashMap<String, String> projParameters = new HashMap<String, String>();
                HashMap<String, Product> projProducts = new HashMap<String, Product>();
                projProducts.put("source", productSubset);
                projParameters.put("crs", "WGS84(DD)");
                productSubset = GPF.createProduct((String)"Reproject", projParameters, projProducts);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return productSubset;
    }
}

