/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.toolviews.nestwwview;

import gov.nasa.worldwind.WorldWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.esa.nest.dat.toolviews.nestwwview.ProductLayer;

class ProductPanel
extends JPanel {
    private final ProductLayer productLayer;
    private JPanel layersPanel;
    private JPanel westPanel;
    private JScrollPane scrollPane;
    private Font defaultFont = null;

    public ProductPanel(WorldWindow wwd, ProductLayer prodLayer) {
        super(new BorderLayout());
        this.productLayer = prodLayer;
        this.makePanel(wwd, new Dimension(100, 400));
    }

    public ProductPanel(WorldWindow wwd, Dimension size, ProductLayer prodLayer) {
        super(new BorderLayout());
        this.productLayer = prodLayer;
        this.makePanel(wwd, size);
    }

    private void makePanel(WorldWindow wwd, Dimension size) {
        this.layersPanel = new JPanel(new GridLayout(0, 1, 0, 4));
        this.layersPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.fill(wwd);
        JPanel dummyPanel = new JPanel(new BorderLayout());
        dummyPanel.add((Component)this.layersPanel, "North");
        this.scrollPane = new JScrollPane(dummyPanel);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (size != null) {
            this.scrollPane.setPreferredSize(size);
        }
        this.westPanel = new JPanel(new GridLayout(0, 1, 0, 10));
        this.westPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Products")));
        this.westPanel.setToolTipText("Products to Show");
        this.westPanel.add(this.scrollPane);
        this.add((Component)this.westPanel, "Center");
    }

    private void fill(WorldWindow wwd) {
        String[] productNames;
        String[] stringArray = productNames = this.productLayer.getProductNames();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String name;
            LayerAction action = new LayerAction(this.productLayer, wwd, name, this.productLayer.getOpacity(name = stringArray[i]) != 0.0);
            JCheckBox jcb = new JCheckBox(action);
            jcb.setSelected(action.selected);
            this.layersPanel.add(jcb);
            if (this.defaultFont != null) continue;
            this.defaultFont = jcb.getFont();
        }
    }

    public void update(WorldWindow wwd) {
        this.layersPanel.removeAll();
        this.fill(wwd);
        this.westPanel.revalidate();
        this.westPanel.repaint();
    }

    @Override
    public void setToolTipText(String string) {
        this.scrollPane.setToolTipText(string);
    }

    private static class LayerAction
    extends AbstractAction {
        final WorldWindow wwd;
        private final ProductLayer layer;
        private final boolean selected;
        private final String name;

        public LayerAction(ProductLayer layer, WorldWindow wwd, String name, boolean selected) {
            super(name);
            this.wwd = wwd;
            this.layer = layer;
            this.name = name;
            this.selected = selected;
            this.layer.setEnabled(this.selected);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                this.layer.setOpacity(this.name, this.layer.getOpacity());
            } else {
                this.layer.setOpacity(this.name, 0.0);
            }
            this.wwd.redraw();
        }
    }
}

