/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.atsr;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.atsr.AtsrBandReader;
import org.esa.beam.framework.datamodel.ProductData;

class AtsrByteBandReader
extends AtsrBandReader {
    private static final int _pixelSize = 1;

    AtsrByteBandReader(String bandName, int offset, float mult, ImageInputStream stream) {
        super(bandName, offset, mult, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void readBandData(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        this.setStreamPos(sourceOffsetX, sourceOffsetY, 1);
        float[] targetData = (float[])destBuffer.getElems();
        byte[] line = new byte[sourceWidth];
        int targetIdx = 0;
        pm.beginTask("Reading band '" + this.getBandName() + "'...", sourceHeight);
        try {
            for (int y = 0; y < sourceHeight; y += sourceStepY) {
                if (pm.isCanceled()) {
                    break;
                }
                this._stream.readFully(line, 0, line.length);
                for (int x = 0; x < sourceWidth; x += sourceStepX) {
                    int value = Math.abs(line[x] & 0xFF);
                    targetData[targetIdx] = (float)value * this._multiplier;
                    ++targetIdx;
                }
                this.updateStreamPos(512 - sourceWidth, 1);
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }
}

