/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.atsr;

public interface AtsrConstants {
    public static final String ATSR_FORMAT_NAME = "ATSR";
    public static final String DESCRIPTION = "ATSR1/ATSR2 products";
    public static final int SADIST_2_HEAER_SIZE = 4096;
    public static final int BYTE_ORDER_SIZE = 2;
    public static final short LITTLE_ENDIAN_TAG = 16961;
    public static final int BT_PIXEL_SIZE = 2;
    public static final int REF_PIXEL_SIZE = 2;
    public static final int SST_PIXEL_SIZE = 2;
    public static final int SST_CONF_PIXEL_SIZE = 2;
    public static final int LATLON_PIXEL_SIZE = 4;
    public static final int OFFSET_PIXEL_SIZE = 1;
    public static final int FLAGS_PIXEL_SIZE = 2;
    public static final int PRODUCT_FILE_NAME_SIZE = 60;
    public static final String PRODUCT_FILE_NAME_FIELD_NAME = "PRODUCT_FILE_NAME";
    public static final int INSTRUMENT_NAME_SIZE = 6;
    public static final String INSTRUMENT_NAME_FIELD_NAME = "INSTRUMENT_NAME";
    public static final int STATE_VECTOR_TYPE_SIZE = 5;
    public static final String STATE_VECTOR_FIELD_NAME = "ERS_STATE_VECTOR_TYPE";
    public static final int ASCENDING_NODE_TIME_SIZE = 16;
    public static final String ASCENDING_NODE_TIME_FIELD_NAME = "ASCENDING_NODE_TIME";
    public static final String ASCENDING_NODE_TIME_DESCRIPTION = "Days since January 1st, 1950";
    public static final String ASCENDING_NODE_TIME_UNIT = "d";
    public static final int ASCENDING_NODE_UT_SIZE = 25;
    public static final String ASCENDING_NODE_UT_FIELD_NAME = "ASCENDING_NODE_UT";
    public static final String ASCENDING_NODE_UT_DESCRIPTION = "Universal time at ascending node";
    public static final int ASCENDING_NODE_STATE_VECTOR_POSITION_SIZE = 13;
    public static final String ASCENDING_NODE_STATE_VECTOR_POSITION_UNIT = "km";
    public static final String ASCENDING_NODE_STATE_VECTOR_POSITION_X_NAME = "STATE_VECTOR_POSITION_X";
    public static final String ASCENDING_NODE_STATE_VECTOR_POSITION_X_DESCRIPTION = "Ascending node state vector position x";
    public static final String ASCENDING_NODE_STATE_VECTOR_POSITION_Y_NAME = "STATE_VECTOR_POSITION_Y";
    public static final String ASCENDING_NODE_STATE_VECTOR_POSITION_Y_DESCRIPTION = "Ascending node state vector position y";
    public static final String ASCENDING_NODE_STATE_VECTOR_POSITION_Z_NAME = "STATE_VECTOR_POSITION_Z";
    public static final String ASCENDING_NODE_STATE_VECTOR_POSITION_Z_DESCRIPTION = "Ascending node state vector position z";
    public static final int ASCENDING_NODE_STATE_VECTOR_VELOCITY_SIZE = 9;
    public static final String ASCENDING_NODE_STATE_VECTOR_VELOCITY_UNIT = "km/s";
    public static final String ASCENDING_NODE_STATE_VECTOR_VELOCITY_X_NAME = "STATE_VECTOR_VELOCITY_X";
    public static final String ASCENDING_NODE_STATE_VECTOR_VELOCITY_X_DESCRIPTION = "Ascending node state vector velocity x";
    public static final String ASCENDING_NODE_STATE_VECTOR_VELOCITY_Y_NAME = "STATE_VECTOR_VELOCITY_Y";
    public static final String ASCENDING_NODE_STATE_VECTOR_VELOCITY_Y_DESCRIPTION = "Ascending node state vector velocity y";
    public static final String ASCENDING_NODE_STATE_VECTOR_VELOCITY_Z_NAME = "STATE_VECTOR_VELOCITY_Z";
    public static final String ASCENDING_NODE_STATE_VECTOR_VELOCITY_Z_DESCRIPTION = "Ascending node state vector velocity z";
    public static final int ASCENDING_NODE_LON_SIZE = 11;
    public static final String ASCENDING_NODE_LON_NAME = "ASCENDING_NODE_LONGITUDE";
    public static final String ASCENDING_NODE_LON_DESCRIPTION = "Longitude of ascending node";
    public static final String ASCENDING_NODE_LON_UNIT = "dec. deg.";
    public static final int REFERENCE_UT_SIZE = 16;
    public static final String REFERENCE_UT_FIELD_NAME = "REFERENCE_UT";
    public static final String REFERENCE_UT_DESCRIPTION = "Reference universal time (days since January 1st, 1950)";
    public static final String REFERENCE_UT_UNIT = "d";
    public static final int REFERENCE_ERS_CLOCK_SIZE = 13;
    public static final String REFERENCE_ERS_CLOCK_UNIT = "ns";
    public static final String REFERENCE_ERS_CLOCK_TIME_NAME = "ERS_CLOCK_TIME";
    public static final String REFERENCE_ERS_CLOCK_TIME_DESCRIPTION = "Reference ERS satellite clock time";
    public static final String REFERENCE_ERS_CLOCK_PERIOD_NAME = "ERS_CLOCK_PERIOD";
    public static final String REFERENCE_ERS_CLOCK_PERIOD_DESCRIPTION = "Period of ERS satellite clock";
    public static final int RECORD_CONTENTS_SIZE = 2;
    public static final String NADIR_ONLY_PRESENT_NAME = "NADIR_ONLY_PRESENT";
    public static final String NADIR_ONLY_DESCRIPTION = "Nadir-only records present";
    public static final String THERMAL_PRESENT_NAME = "THERMAL_RECORDS_PRESENT";
    public static final String THERMAL_PRESENT_DESCRIPTION = "Thermal infra-red detector records present";
    public static final String VISIBLE_PRESENT_NAME = "VISIBLE_RECORDS_PRESENT";
    public static final String VISIBLE_PRESENT_DESCRIPTION = "Visible/near-infra-red detector records present";
    public static final String LAT_LON_PRESENT_NAME = "LAT_LON_RECORDS_PRESENT";
    public static final String LAT_LON_PRESENT_DESCRIPTION = "Latitude/longitude records present";
    public static final String X_Y_PRESENT_NAME = "X_Y_RECORDS_PRESENT";
    public static final String X_Y_PRESENT_DESCRIPTION = "X/Y coordinate records present";
    public static final String FLAGS_PRESENT_NAME = "FLAG_RECORDS_PRESENT";
    public static final String FLAGS_PRESENT_DESCRIPTION = "Cloud-clearing/land-flagging records present";
    public static final int TRACK_DISTANCE_SIZE = 6;
    public static final String TRACK_DISTANCE_UNIT = "km";
    public static final String TRACK_DISTANCE_START_NAME = "ALONG_TRACK_START_DISTANCE";
    public static final String TRACK_DISTANCE_START_DESCRIPTION = "Along-track distance of product start";
    public static final String TRACK_DISTANCE_END_NAME = "ALONG_TRACK_END_DISTANCE";
    public static final String TRACK_DISTANCE_END_DESCRIPTION = "Along-track distance of product end";
    public static final int PRODUCT_TIME_SIZE = 25;
    public static final String UT_PRODUCT_START_NAME = "PRODUCT_START_TIME";
    public static final String UT_PRODUCT_START_DESCRIPTION = "Universal time of data acquisition at product start";
    public static final String UT_PRODUCT_END_NAME = "PRODUCT_END_TIME";
    public static final String UT_PRODUCT_END_DESCRIPTION = "Universal time of data acquisition at product end";
    public static final int CORNER_LAT_SIZE = 8;
    public static final String CORNER_LAT_LON_UNITS = "dec. deg.";
    public static final String CORNER_LAT_LHS_START_NAME = "CORNER_LAT_LHS_START";
    public static final String CORNER_LAT_LHS_START_DESCRIPTION = "Latitude of product LHS corner point at start";
    public static final String CORNER_LAT_RHS_START_NAME = "CORNER_LAT_RHS_START";
    public static final String CORNER_LAT_RHS_START_DESCRIPTION = "Latitude of product RHS corner point at start";
    public static final String CORNER_LAT_LHS_END_NAME = "CORNER_LAT_LHS_END";
    public static final String CORNER_LAT_LHS_END_DESCRIPTION = "Latitude of product LHS corner point at end";
    public static final String CORNER_LAT_RHS_END_NAME = "CORNER_LAT_RHS_END";
    public static final String CORNER_LAT_RHS_END_DESCRIPTION = "Latitude of product RHS corner point at end";
    public static final int CORNER_LON_SIZE = 9;
    public static final String CORNER_LON_LHS_START_NAME = "CORNER_LON_LHS_START";
    public static final String CORNER_LON_LHS_START_DESCRIPTION = "Longitude of product LHS corner point at start";
    public static final String CORNER_LON_RHS_START_NAME = "CORNER_LON_RHS_START";
    public static final String CORNER_LON_RHS_START_DESCRIPTION = "Longitude of product RHS corner point at start";
    public static final String CORNER_LON_LHS_END_NAME = "CORNER_LON_LHS_END";
    public static final String CORNER_LON_LHS_END_DESCRIPTION = "Longitude of product LHS corner point at end";
    public static final String CORNER_LON_RHS_END_NAME = "CORNER_LON_RHS_END";
    public static final String CORNER_LON_RHS_END_DESCRIPTION = "Longitude of product RHS corner point at end";
    public static final int PIXEL_SELECTION_MAP_SIZE = 3;
    public static final String PIXEL_SELECTION_MAP_NADIR_NAME = "PIXEL_SELECTION_MAPS_NADIR";
    public static final String PIXEL_SELECTION_MAP_NADIR_DESCRIPTION = "1st and 2nd ATSR-2 Pixel Selection Maps in nadir-view";
    public static final String PIXEL_SELECTION_MAP_FORWARD_NAME = "PIXEL_SELECTION_MAPS_FORWARD";
    public static final String PIXEL_SELECTION_MAP_FORWARD_DESCRIPTION = "1st and 2nd ATSR-2 Pixel Selection Maps in forward-view";
    public static final int PSM_CHANGE_SIZE = 6;
    public static final String PSM_CHANGE_UNIT = "km";
    public static final String PSM_CHANGE_NADIR_NAME = "PSM_CHANGE_DISTANCE_NADIR";
    public static final String PSM_CHANGE_NADIR_DESCRIPTION = "Along-track distance of 1st PSM change in nadir-view";
    public static final String PSM_CHANGE_FORWARD_NAME = "PSM_CHANGE_DISTANCE_FORWARD";
    public static final String PSM_CHANGE_FORWARD_DESCRIPTION = "Along-track distance of 1st PSM change in forward-view";
    public static final int ATSR2_DATA_RATE_SIZE = 2;
    public static final String ATSR2_DATA_RATE_NADIR_NAME = "ATSR2_DATA_RATE_NADIR_VIEW";
    public static final String ATSR2_DATA_RATE_NADIR_DESCRIPTION = "ATSR-2 data-rate at start of nadir-view";
    public static final String ATSR2_DATA_RATE_FORWARD_NAME = "ATSR2_DATA_RATE_FORWARD_VIEW";
    public static final String ATSR2_DATA_RATE_FORWARD_DESCRIPTION = "ATSR-2 data-rate at start of forward-view";
    public static final int ATSR2_DATA_RATE_CHANGE_SIZE = 6;
    public static final String ATSR2_DATA_RATE_CHANGE_UNIT = "km";
    public static final String ATSR2_DATA_RATE_CHANGE_NADIR_NAME = "ATSR2_DATA_RATE_CHANGE_NADIR_VIEW";
    public static final String ATSR2_DATA_RATE_CHANGE_NADIR_DESCRIPTION = "Along-track distance of 1st ATSR-2 data-rate change in nadir-view";
    public static final String ATSR2_DATA_RATE_CHANGE_FORWARD_NAME = "ATSR2_DATA_RATE_CHANGE_FORWARD_VIEW";
    public static final String ATSR2_DATA_RATE_CHANGE_FORWARD_DESCRIPTION = "Along-track distance of 1st ATSR-2 data-rate change in forward-view";
    public static final int TEMPERATURES_SIZE = 8;
    public static final String TEMPERATURES_UNIT = "K";
    public static final String MIN_SCC_TEMPERATURE_NAME = "MINIMUM_SCC_TEMPERATURE";
    public static final String MIN_SCC_TEMPERATURE_DESCRIPTION = "Minimum Stirling Cycle Cooler cold-tip temperature";
    public static final String MIN_INSTRUMENT_TEMPERATURE_1200_NM_NAME = "MINIMUM_INSTRUMENT_TEMPERATURE_1200_NM";
    public static final String MIN_INSTRUMENT_TEMPERATURE_1200_NM_DESCRIPTION = "Minimum instrument detector temperature at 1200 nm";
    public static final String MIN_INSTRUMENT_TEMPERATURE_1100_NM_NAME = "MINIMUM_INSTRUMENT_TEMPERATURE_1100_NM";
    public static final String MIN_INSTRUMENT_TEMPERATURE_1100_NM_DESCRIPTION = "Minimum instrument detector temperature at 1100 nm";
    public static final String MIN_INSTRUMENT_TEMPERATURE_370_NM_NAME = "MINIMUM_INSTRUMENT_TEMPERATURE_370_NM";
    public static final String MIN_INSTRUMENT_TEMPERATURE_370_NM_DESCRIPTION = "Minimum instrument detector temperature at 370 nm";
    public static final String MIN_INSTRUMENT_TEMPERATURE_160_NM_NAME = "MINIMUM_INSTRUMENT_TEMPERATURE_160_NM";
    public static final String MIN_INSTRUMENT_TEMPERATURE_160_NM_DESCRIPTION = "Minimum instrument detector temperature at 160 nm";
    public static final String MIN_INSTRUMENT_TEMPERATURE_87_NM_NAME = "MINIMUM_INSTRUMENT_TEMPERATURE_87_NM";
    public static final String MIN_INSTRUMENT_TEMPERATURE_87_NM_DESCRIPTION = "Minimum instrument detector temperature at 87 nm";
    public static final String MAX_SCC_TEMPERATURE_NAME = "MAXIMUM_SCC_TEMPERATURE";
    public static final String MAX_SCC_TEMPERATURE_DESCRIPTION = "Maximum Stirling Cycle Cooler cold-tip temperature";
    public static final String MAX_INSTRUMENT_TEMPERATURE_1200_NM_NAME = "MAXIMUM_INSTRUMENT_TEMPERATURE_1200_NM";
    public static final String MAX_INSTRUMENT_TEMPERATURE_1200_NM_DESCRIPTION = "Maximum instrument detector temperature at 1200 nm";
    public static final String MAX_INSTRUMENT_TEMPERATURE_1100_NM_NAME = "MAXIMUM_INSTRUMENT_TEMPERATURE_1100_NM";
    public static final String MAX_INSTRUMENT_TEMPERATURE_1100_NM_DESCRIPTION = "Maximum instrument detector temperature at 1100 nm";
    public static final String MAX_INSTRUMENT_TEMPERATURE_370_NM_NAME = "MAXIMUM_INSTRUMENT_TEMPERATURE_370_NM";
    public static final String MAX_INSTRUMENT_TEMPERATURE_370_NM_DESCRIPTION = "Maximum instrument detector temperature at 370 nm";
    public static final String MAX_INSTRUMENT_TEMPERATURE_160_NM_NAME = "MAXIMUM_INSTRUMENT_TEMPERATURE_160_NM";
    public static final String MAX_INSTRUMENT_TEMPERATURE_160_NM_DESCRIPTION = "Maximum instrument detector temperature at 160 nm";
    public static final String MAX_INSTRUMENT_TEMPERATURE_87_NM_NAME = "MAXIMUM_INSTRUMENT_TEMPERATURE_87_NM";
    public static final String MAX_INSTRUMENT_TEMPERATURE_87_NM_DESCRIPTION = "Maximum instrument detector temperature at 87 nm";
    public static final int ANGLE_PARAMETER_SIZE = 9;
    public static final String ANGLE_UNIT = "dec. deg.";
    public static final String SUN_ELEVATION_NADIR_NAME = "sun_elev_nadir";
    public static final String SUN_ELEVATION_NADIR_DESCRIPTION = "Nadir-view solar elevation";
    public static final String VIEW_ELEVATION_NADIR_NAME = "view_elev_nadir";
    public static final String VIEW_ELEVATION_NADIR_DESCRIPTION = "Nadir-view satellite elevation";
    public static final String SUN_AZIMUTH_NADIR_NAME = "sun_azimuth_nadir";
    public static final String SUN_AZIMUTH_NADIR_DESCRIPTION = "Nadir-view solar azimuth";
    public static final String VIEW_AZIMUTH_NADIR_NAME = "view_azimuth_nadir";
    public static final String VIEW_AZIMUTH_NADIR_DESCRIPTION = "Nadir-view satellite azimuth";
    public static final String SUN_ELEVATION_FORWARD_NAME = "sun_elev_forward";
    public static final String SUN_ELEVATION_FORWARD_DESCRIPTION = "Forward-view solar elevation";
    public static final String VIEW_ELEVATION_FORWARD_NAME = "view_elev_forward";
    public static final String VIEW_ELEVATION_FORWARD_DESCRIPTION = "Forward-view satellite elevation";
    public static final String SUN_AZIMUTH_FORWARD_NAME = "sun_azimuth_forward";
    public static final String SUN_AZIMUTH_FORWARD_DESCRIPTION = "Forward-view solar azimuth";
    public static final String VIEW_AZIMUTH_FORWARD_NAME = "view_azimuth_forward";
    public static final String VIEW_AZIMUTH_FORWARD_DESCRIPTION = "Forward-view satellite azimuth";
    public static final String LATITUDE_NAME = "latitude";
    public static final String LATITUDE_DESCRIPTION = "Latitudes of image pixels";
    public static final String LONGITUDE_NAME = "longitude";
    public static final String LONGITUDE_DESCRIPTION = "Longitudes of image pixels";
    public static final int CONFIDENCE_SIZE = 6;
    public static final String ERS_MODE_YSM_NADIR_NAME = "ERS_PLATFORM_MODE_YSM_NADIR";
    public static final String ERS_MODE_YSM_NADIR_DESCRIPTION = "ERS platform modes during nadir view as # of scans in YSM";
    public static final String ERS_MODE_FCM_NADIR_NAME = "ERS_PLATFORM_MODE_FCM_NADIR";
    public static final String ERS_MODE_FCM_NADIR_DESCRIPTION = "ERS platform modes during nadir view as # of scans in FCM";
    public static final String ERS_MODE_OCM_NADIR_NAME = "ERS_PLATFORM_MODE_OCM_NADIR";
    public static final String ERS_MODE_OCM_NADIR_DESCRIPTION = "ERS platform modes during nadir view as # of scans in OCM";
    public static final String ERS_MODE_FPM_NADIR_NAME = "ERS_PLATFORM_MODE_FPM_NADIR";
    public static final String ERS_MODE_FPM_NADIR_DESCRIPTION = "ERS platform modes during nadir view as # of scans in FPM";
    public static final String ERS_MODE_RTMM_NADIR_NAME = "ERS_PLATFORM_MODE_RTMM_NADIR";
    public static final String ERS_MODE_RTMM_NADIR_DESCRIPTION = "ERS platform modes during nadir view as # of scans in RTMM";
    public static final String ERS_MODE_RTMC_NADIR_NAME = "ERS_PLATFORM_MODE_RTMC_NADIR";
    public static final String ERS_MODE_RTMC_NADIR_DESCRIPTION = "ERS platform modes during nadir view as # of scans in RTMC";
    public static final String ERS_MODE_YSM_FORWARD_NAME = "ERS_PLATFORM_MODE_YSM_FORWARD";
    public static final String ERS_MODE_YSM_FORWARD_DESCRIPTION = "ERS platform modes during forward view as # of scans in YSM";
    public static final String ERS_MODE_FCM_FORWARD_NAME = "ERS_PLATFORM_MODE_FCM_FORWARD";
    public static final String ERS_MODE_FCM_FORWARD_DESCRIPTION = "ERS platform modes during forward view as # of scans in FCM";
    public static final String ERS_MODE_OCM_FORWARD_NAME = "ERS_PLATFORM_MODE_OCM_FORWARD";
    public static final String ERS_MODE_OCM_FORWARD_DESCRIPTION = "ERS platform modes during forward view as # of scans in OCM";
    public static final String ERS_MODE_FPM_FORWARD_NAME = "ERS_PLATFORM_MODE_FPM_FORWARD";
    public static final String ERS_MODE_FPM_FORWARD_DESCRIPTION = "ERS platform modes during forward view as # of scans in FPM";
    public static final String ERS_MODE_RTMM_FORWARD_NAME = "ERS_PLATFORM_MODE_RTMM_FORWARD";
    public static final String ERS_MODE_RTMM_FORWARD_DESCRIPTION = "ERS platform modes during forward view as # of scans in RTMM";
    public static final String ERS_MODE_RTMC_FORWARD_NAME = "ERS_PLATFORM_MODE_RTMC_FORWARD";
    public static final String ERS_MODE_RTMC_FORWARD_DESCRIPTION = "ERS platform modes during forward view as # of scans in RTMC";
    public static final int NUM_PCD_SETS = 8;
    public static final String PCD_INFO_NADIR_NAME = "PCD_INFORMATION_NADIR";
    public static final String PCD_INFO_NADIR_DESCRIPTION = "Acquisition of PCD information during nadir-view as # of scans for each condition";
    public static final String PCD_INFO_FORWARD_NAME = "PCD_INFORMATION_FORWARD";
    public static final String PCD_INFO_FORWARD_DESCRIPTION = "Acquisition of PCD information during forward-view as # of scans for each condition";
    public static final int NUM_PACKET_SETS = 10;
    public static final String PACKET_INFO_NADIR_NAME = "PACKET_INFORMATION_NADIR";
    public static final String PACKET_INFO_NADIR_DESCRIPTION = "SADIST-2 packet validation during nadir-view as # of scans for each condition";
    public static final String PACKET_INFO_FORWARD_NAME = "PACKET_INFORMATION_FORWARD";
    public static final String PACKET_INFO_FORWARD_DESCRIPTION = "SADIST-2 packet validation during forward-view as # of scans for each condition";
    public static final int PIXEL_ERROR_SIZE = 4;
    public static final String MAX_PIXEL_ERROR_CODE_NAME = "MAX_SINGLE_PIXEL_ERROR_CODE";
    public static final String MAX_PIXEL_ERROR_CODE_DESCRIPTION = "Maximum single-pixel error code";
    public static final char[] BYTE_ORDER_FIELD = new char[]{'A', 'B'};
    public static final String[] PRODUCT_TYPES = new String[]{"GBT", "GSST"};
    public static final String[] INSTRUMENTS = new String[]{"ATSR1", "ATSR2"};
    public static final String MPH_NAME = "MPH";
    public static final String SPH_NAME = "SPH";
    public static final String QADS_NAME = "QUALITY_ADS";
    public static final int ATSR_SCENE_RASTER_WIDTH = 512;
    public static final int ATSR_SCENE_RASTER_HEIGHT = 512;
    public static final int ATSR_TIE_PT_GRID_WIDTH = 11;
    public static final int ATSR_TIE_PT_GRID_HEIGHT = 2;
    public static final int ATSR_TIE_PT_SUBS_X = 50;
    public static final int ATSR_TIE_PT_SUBS_Y = 512;
    public static final float ATSR_TIE_PT_OFFS_X = 6.0f;
    public static final int LAT_LON_SUBS_X = 16;
    public static final int LAT_LON_SUBS_Y = 16;
    public static final float LAT_LON_CONVERSION = 0.001f;
    public static final String NADIR_FLAGS_NAME = "cloud_flags_nadir";
    public static final String NADIR_FLAGS_DESCRIPTION = "Nadir-view cloud-clearing/land-flagging results";
    public static final String FORWARD_FLAGS_NAME = "cloud_flags_fward";
    public static final String FORWARD_FLAGS_DESCRIPTION = "Forward-view cloud-clearing/land-flagging results";
    public static final String LAND_FLAG_NAME = "LAND";
    public static final int LAND_FLAG_MASK = 1;
    public static final String LAND_FLAG_DESCRIPTION = "Pixel is over land";
    public static final String CLOUD_FLAG_NAME = "CLOUDY";
    public static final int CLOUD_FLAG_MASK = 2;
    public static final String CLOUD_FLAG_DESCRIPTION = "Pixel is cloudy (result of all cloud tests)";
    public static final String SUNGLINT_FLAG_NAME = "SUN_GLINT";
    public static final int SUNGLINT_FLAG_MASK = 4;
    public static final String SUNGLINT_FLAG_DESCRIPTION = "Sunglint detected in pixel";
    public static final String REFL_HIST_FLAG_NAME = "CLOUDY_REFL_HIST";
    public static final int REFL_HIST_FLAG_MASK = 8;
    public static final String REFL_HIST_FLAG_DESCRIPTION = "1.6 um reflectance histogram test (day-time only)";
    public static final String SPAT_COHER_16_FLAG_NAME = "CLOUDY_SPAT_COHER_16";
    public static final int SPAT_COHER_16_FLAG_MASK = 16;
    public static final String SPAT_COHER_16_FLAG_DESCRIPTION = "1.6 um spatial coherence test (day-time only)";
    public static final String SPAT_COHER_11_FLAG_NAME = "CLOUDY_SPAT_COHER_11";
    public static final int SPAT_COHER_11_FLAG_MASK = 32;
    public static final String SPAT_COHER_11_FLAG_DESCRIPTION = "11 um spatial coherence test";
    public static final String GROSS_12_FLAG_NAME = "CLOUDY_GROSS_12";
    public static final int GROSS_12_FLAG_MASK = 64;
    public static final String GROSS_12_FLAG_DESCRIPTION = "12 um gross cloud test";
    public static final String CIRRUS_11_12_FLAG_NAME = "CLOUDY_CIRRUS_11_12";
    public static final int CIRRUS_11_12_FLAG_MASK = 128;
    public static final String CIRRUS_11_12_FLAG_DESCRIPTION = "11/12 um thin cirrus test";
    public static final String MED_HI_37_12_FLAG_NAME = "CLOUDY_MED_HI_LEVEL_37_12";
    public static final int MED_HI_37_12_FLAG_MASK = 256;
    public static final String MED_HI_37_12_FLAG_DESCRIPTION = "3.7/12 um medium/high level test (night-time only)";
    public static final String FOG_LOW_STRATUS_11_37_FLAG_NAME = "CLOUDY_FOG_LOW_STRATUS_11_37";
    public static final int FOG_LOW_STRATUS_11_37_FLAG_MASK = 512;
    public static final String FOG_LOW_STRATUS_11_37_FLAG_DESCRIPTION = "11/3.7 um fog/low stratus test (night-time only)";
    public static final String VW_DIFF_11_12_FLAG_NAME = "CLOUDY_VW_DIFF_11_12";
    public static final int VW_DIFF_11_12_FLAG_MASK = 1024;
    public static final String VW_DIFF_11_12_FLAG_DESCRIPTION = "11/12 um view difference test";
    public static final String VW_DIFF_37_11_FLAG_NAME = "CLOUDY_VW_DIFF_37_11";
    public static final int VW_DIFF_37_11_FLAG_MASK = 2048;
    public static final String VW_DIFF_37_11_FLAG_DESCRIPTION = "3.7/11 um view difference test (night-time only)";
    public static final String THERM_HIST_11_12_FLAG_NAME = "CLOUDY_THERM_HIST_11_12";
    public static final int THERM_HIST_11_12_FLAG_MASK = 4096;
    public static final String THERM_HIST_11_12_FLAG_DESCRIPTION = "11/12 um thermal histogram test";
    public static final int BAND_12_WAVELENGTH = 12000;
    public static final int BAND_12_WIDTH = 1000;
    public static final int BAND_11_WAVELENGTH = 10800;
    public static final int BAND_11_WIDTH = 1000;
    public static final int BAND_37_WAVELENGTH = 3700;
    public static final int BAND_37_WIDTH = 300;
    public static final int BAND_16_WAVELENGTH = 1600;
    public static final int BAND_16_WIDTH = 300;
    public static final int BAND_87_WAVELENGTH = 870;
    public static final int BAND_87_WIDTH = 20;
    public static final int BAND_65_WAVELENGTH = 670;
    public static final int BAND_65_WIDTH = 20;
    public static final int BAND_55_WAVELENGTH = 550;
    public static final int BAND_55_WIDTH = 20;
}

