/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.atsr;

import java.io.File;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.atsr.AtsrBandReader;
import org.esa.beam.dataio.atsr.AtsrByteBandReader;
import org.esa.beam.dataio.atsr.AtsrFile;
import org.esa.beam.dataio.atsr.AtsrFlagBandReader;
import org.esa.beam.dataio.atsr.AtsrShortBandReader;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.SampleCoding;

public class AtsrGBTFile
extends AtsrFile {
    private int _nadir1200offset;
    private int _nadir1100offset;
    private int _nadir370offset;
    private int _nadir1600offset;
    private int _nadir870offset;
    private int _nadir650offset;
    private int _nadir550offset;
    private int _forward1200offset;
    private int _forward1100offset;
    private int _forward370offset;
    private int _forward1600offset;
    private int _forward870offset;
    private int _forward650offset;
    private int _forward550offset;
    private int _latOffset;
    private int _lonOffset;
    private int _nadirXOffset;
    private int _nadirYOffset;
    private int _forwardXOffset;
    private int _forwardYOffset;
    private int _nadirFlagsOffset;
    private int _forwardFlagsOffset;
    private FlagCoding _flagCodingNadir;
    private FlagCoding _flagCodingForward;

    @Override
    public void open(ImageInputStream inStream, File file) throws IOException {
        super.open(inStream, file);
        this.scanBands();
        this.createFlagBands();
        this.calculateFileOffsets();
        this.createBandReader();
        this.readLatLonTiePoints(this._latOffset, this._lonOffset);
    }

    private void scanBands() {
        if (this.getHeader().isThermalPresent()) {
            this.createNadirThermalBands();
            if (!this.getHeader().isNadirOnly()) {
                this.createForwardThermalBands();
            }
        }
        if (this.getHeader().isVisiblePresent() || this.getHeader().isThermalPresent()) {
            this.createNadir1600Band();
            if (!this.getHeader().isNadirOnly()) {
                this.createForward1600Band();
            }
        }
        if (this.getHeader().isVisiblePresent()) {
            this.createNadirVisibleBands();
            if (!this.getHeader().isNadirOnly()) {
                this.createForwardVisibleBands();
            }
        }
        if (this.getHeader().isXYPresent()) {
            this.createNadirOffsetBands();
            if (!this.getHeader().isNadirOnly()) {
                this.createForwardOffsetBands();
            }
        }
    }

    private void createNadirThermalBands() {
        Band band = new Band("btemp_nadir_1200", 30, 512, 512);
        band.setUnit("K");
        band.setDescription("Nadir-view 12.0um brightness temperature image");
        band.setSpectralWavelength(12000.0f);
        band.setSpectralBandwidth(1000.0f);
        this.addBand(band);
        band = new Band("btemp_nadir_1100", 30, 512, 512);
        band.setUnit("K");
        band.setDescription("Nadir-view 11.0um brightness temperature image");
        band.setSpectralWavelength(10800.0f);
        band.setSpectralBandwidth(1000.0f);
        this.addBand(band);
        band = new Band("btemp_nadir_370", 30, 512, 512);
        band.setUnit("K");
        band.setDescription("Nadir-view 3.7um brightness temperature image");
        band.setSpectralWavelength(3700.0f);
        band.setSpectralBandwidth(300.0f);
        this.addBand(band);
    }

    private void createForwardThermalBands() {
        Band band = new Band("btemp_fward_1200", 30, 512, 512);
        band.setUnit("K");
        band.setDescription("Forward-view 12.0um brightness temperature image");
        band.setSpectralWavelength(12000.0f);
        band.setSpectralBandwidth(1000.0f);
        this.addBand(band);
        band = new Band("btemp_fward_1100", 30, 512, 512);
        band.setUnit("K");
        band.setDescription("Forward-view 11.0um brightness temperature image");
        band.setSpectralWavelength(10800.0f);
        band.setSpectralBandwidth(1000.0f);
        this.addBand(band);
        band = new Band("btemp_fward_370", 30, 512, 512);
        band.setUnit("K");
        band.setDescription("Forward-view 3.7um brightness temperature image");
        band.setSpectralWavelength(3700.0f);
        band.setSpectralBandwidth(300.0f);
        this.addBand(band);
    }

    private void createNadirVisibleBands() {
        Band band = new Band("reflec_nadir_870", 30, 512, 512);
        band.setUnit("%");
        band.setDescription("Nadir-view 0.87um reflectance image");
        band.setSpectralWavelength(870.0f);
        band.setSpectralBandwidth(20.0f);
        this.addBand(band);
        band = new Band("reflec_nadir_650", 30, 512, 512);
        band.setUnit("%");
        band.setDescription("Nadir-view 0.65um reflectance image");
        band.setSpectralWavelength(670.0f);
        band.setSpectralBandwidth(20.0f);
        this.addBand(band);
        band = new Band("reflec_nadir_550", 30, 512, 512);
        band.setUnit("%");
        band.setDescription("Nadir-view 0.55um reflectance image");
        band.setSpectralWavelength(550.0f);
        band.setSpectralBandwidth(20.0f);
        this.addBand(band);
    }

    private void createForwardVisibleBands() {
        Band band = new Band("reflec_fward_870", 30, 512, 512);
        band.setUnit("%");
        band.setDescription("Forward-view 0.87um reflectance image");
        band.setSpectralWavelength(870.0f);
        band.setSpectralBandwidth(20.0f);
        this.addBand(band);
        band = new Band("reflec_fward_650", 30, 512, 512);
        band.setUnit("%");
        band.setDescription("Forward-view 0.65um reflectance image");
        band.setSpectralWavelength(670.0f);
        band.setSpectralBandwidth(20.0f);
        this.addBand(band);
        band = new Band("reflec_fward_550", 30, 512, 512);
        band.setUnit("%");
        band.setDescription("Forward-view 0.55um reflectance image");
        band.setSpectralWavelength(550.0f);
        band.setSpectralBandwidth(20.0f);
        this.addBand(band);
    }

    private void createNadir1600Band() {
        Band band = new Band("reflec_nadir_1600", 30, 512, 512);
        band.setUnit("%");
        band.setDescription("Nadir-view 1.6um reflectance image");
        band.setSpectralWavelength(1600.0f);
        band.setSpectralBandwidth(300.0f);
        this.addBand(band);
    }

    private void createForward1600Band() {
        Band band = new Band("reflec_fward_1600", 30, 512, 512);
        band.setUnit("%");
        band.setDescription("Forward-view 1.6um reflectance image");
        band.setSpectralWavelength(1600.0f);
        band.setSpectralBandwidth(300.0f);
        this.addBand(band);
    }

    private void createNadirOffsetBands() {
        Band band = new Band("x_offs_nadir", 30, 512, 512);
        band.setUnit("km");
        band.setDescription("X coordinate offsets (across-track) of nadir view pixels");
        this.addBand(band);
        band = new Band("y_offs_nadir", 30, 512, 512);
        band.setUnit("km");
        band.setDescription("Y coordinate offsets (along-track) of nadir view pixels");
        this.addBand(band);
    }

    private void createForwardOffsetBands() {
        Band band = new Band("x_offs_fward", 30, 512, 512);
        band.setUnit("km");
        band.setDescription("X coordinate offsets (across-track) of forward view pixels");
        this.addBand(band);
        band = new Band("y_offs_fward", 30, 512, 512);
        band.setUnit("km");
        band.setDescription("Y coordinate offsets (along-track) of forward view pixels");
        this.addBand(band);
    }

    private void calculateFileOffsets() {
        int runningOffset = 4096;
        if (this.getHeader().isThermalPresent()) {
            this._nadir1200offset = runningOffset;
            this._nadir1100offset = runningOffset += 524288;
            this._nadir370offset = runningOffset += 524288;
            runningOffset += 524288;
        }
        if (this.getHeader().isThermalPresent() || this.getHeader().isVisiblePresent()) {
            this._nadir1600offset = runningOffset;
            runningOffset += 524288;
        }
        if (this.getHeader().isVisiblePresent()) {
            this._nadir870offset = runningOffset;
            this._nadir650offset = runningOffset += 524288;
            this._nadir550offset = runningOffset += 524288;
            runningOffset += 524288;
        }
        if (this.getHeader().isThermalPresent() && !this.getHeader().isNadirOnly()) {
            this._forward1200offset = runningOffset;
            this._forward1100offset = runningOffset += 524288;
            this._forward370offset = runningOffset += 524288;
            runningOffset += 524288;
        }
        if ((this.getHeader().isThermalPresent() || this.getHeader().isVisiblePresent()) && !this.getHeader().isNadirOnly()) {
            this._forward1600offset = runningOffset;
            runningOffset += 524288;
        }
        if (this.getHeader().isVisiblePresent() && !this.getHeader().isNadirOnly()) {
            this._forward870offset = runningOffset;
            this._forward650offset = runningOffset += 524288;
            this._forward550offset = runningOffset += 524288;
            runningOffset += 524288;
        }
        if (this.getHeader().isLatLonPresent()) {
            this._latOffset = runningOffset;
            this._lonOffset = runningOffset += 0x100000;
            runningOffset += 0x100000;
        }
        if (this.getHeader().isXYPresent()) {
            this._nadirXOffset = runningOffset;
            this._nadirYOffset = runningOffset += 262144;
            runningOffset += 262144;
            if (!this.getHeader().isNadirOnly()) {
                this._forwardXOffset = runningOffset;
                this._forwardYOffset = runningOffset += 262144;
                runningOffset += 262144;
            }
        }
        if (this.getHeader().areFlagsPresent()) {
            this._nadirFlagsOffset = runningOffset;
            runningOffset += 524288;
            if (!this.getHeader().isNadirOnly()) {
                this._forwardFlagsOffset = runningOffset;
                runningOffset += 524288;
            }
        }
    }

    private void createFlagBands() {
        if (this.getHeader().areFlagsPresent()) {
            this.createFlagCodings();
            Band band = new Band("cloud_flags_nadir", 11, 512, 512);
            band.setDescription("Nadir-view cloud-clearing/land-flagging results");
            band.setSampleCoding((SampleCoding)this._flagCodingNadir);
            this.addBand(band);
            if (!this.getHeader().isNadirOnly()) {
                band = new Band("cloud_flags_fward", 11, 512, 512);
                band.setDescription("Forward-view cloud-clearing/land-flagging results");
                band.setSampleCoding((SampleCoding)this._flagCodingForward);
                this.addBand(band);
            }
        }
    }

    private void createFlagCodings() {
        this._flagCodingNadir = new FlagCoding("cloud_flags_nadir");
        this._flagCodingNadir = this.addCloudAndLandFlagsToCoding(this._flagCodingNadir);
        if (!this.getHeader().isNadirOnly()) {
            this._flagCodingForward = new FlagCoding("cloud_flags_fward");
            this._flagCodingForward = this.addCloudAndLandFlagsToCoding(this._flagCodingForward);
        }
    }

    private void createBandReader() {
        AtsrBandReader reader = null;
        if (this.getHeader().isThermalPresent()) {
            reader = new AtsrShortBandReader("btemp_nadir_1200", this._nadir1200offset, 0.01f, this.getStream());
            this.addBandReader(reader);
            reader = new AtsrShortBandReader("btemp_nadir_1100", this._nadir1100offset, 0.01f, this.getStream());
            this.addBandReader(reader);
            reader = new AtsrShortBandReader("btemp_nadir_370", this._nadir370offset, 0.01f, this.getStream());
            this.addBandReader(reader);
            if (!this.getHeader().isNadirOnly()) {
                reader = new AtsrShortBandReader("btemp_fward_1200", this._forward1200offset, 0.01f, this.getStream());
                this.addBandReader(reader);
                reader = new AtsrShortBandReader("btemp_fward_1100", this._forward1100offset, 0.01f, this.getStream());
                this.addBandReader(reader);
                reader = new AtsrShortBandReader("btemp_fward_370", this._forward370offset, 0.01f, this.getStream());
                this.addBandReader(reader);
            }
        }
        if (this.getHeader().isThermalPresent() || this.getHeader().isVisiblePresent()) {
            reader = new AtsrShortBandReader("reflec_nadir_1600", this._nadir1600offset, 0.01f, this.getStream());
            this.addBandReader(reader);
            if (!this.getHeader().isNadirOnly()) {
                reader = new AtsrShortBandReader("reflec_fward_1600", this._forward1600offset, 0.01f, this.getStream());
                this.addBandReader(reader);
            }
        }
        if (this.getHeader().isVisiblePresent()) {
            reader = new AtsrShortBandReader("reflec_nadir_870", this._nadir870offset, 0.01f, this.getStream());
            this.addBandReader(reader);
            reader = new AtsrShortBandReader("reflec_nadir_650", this._nadir650offset, 0.01f, this.getStream());
            this.addBandReader(reader);
            reader = new AtsrShortBandReader("reflec_nadir_550", this._nadir550offset, 0.01f, this.getStream());
            this.addBandReader(reader);
            if (!this.getHeader().isNadirOnly()) {
                reader = new AtsrShortBandReader("reflec_fward_870", this._forward870offset, 0.01f, this.getStream());
                this.addBandReader(reader);
                reader = new AtsrShortBandReader("reflec_fward_650", this._forward650offset, 0.01f, this.getStream());
                this.addBandReader(reader);
                reader = new AtsrShortBandReader("reflec_fward_550", this._forward550offset, 0.01f, this.getStream());
                this.addBandReader(reader);
            }
        }
        if (this.getHeader().isXYPresent()) {
            reader = new AtsrByteBandReader("x_offs_nadir", this._nadirXOffset, 0.00390625f, this.getStream());
            this.addBandReader(reader);
            reader = new AtsrByteBandReader("y_offs_nadir", this._nadirYOffset, 0.00390625f, this.getStream());
            this.addBandReader(reader);
            if (!this.getHeader().isNadirOnly()) {
                reader = new AtsrByteBandReader("x_offs_fward", this._forwardXOffset, 0.00390625f, this.getStream());
                this.addBandReader(reader);
                reader = new AtsrByteBandReader("y_offs_fward", this._forwardYOffset, 0.00390625f, this.getStream());
                this.addBandReader(reader);
            }
        }
        if (this.getHeader().areFlagsPresent()) {
            reader = new AtsrFlagBandReader("cloud_flags_nadir", this._nadirFlagsOffset, 1.0f, this.getStream());
            this.addBandReader(reader);
            if (!this.getHeader().isNadirOnly()) {
                reader = new AtsrFlagBandReader("cloud_flags_fward", this._forwardFlagsOffset, 1.0f, this.getStream());
                this.addBandReader(reader);
            }
        }
    }
}

