/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.atsr;

import java.io.File;
import java.util.Locale;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.atsr.AtsrFileFactory;
import org.esa.beam.dataio.atsr.AtsrProductReader;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.util.io.BeamFileFilter;

public class AtsrProductReaderPlugIn
implements ProductReaderPlugIn {
    public DecodeQualification getDecodeQualification(Object input) {
        AtsrFileFactory factory = AtsrFileFactory.getInstance();
        if (input instanceof String) {
            return factory.getDecodeQualification((String)input);
        }
        if (input instanceof File) {
            return factory.getDecodeQualification((File)input);
        }
        if (input instanceof ImageInputStream) {
            return factory.getDecodeQualification((ImageInputStream)input);
        }
        return DecodeQualification.UNABLE;
    }

    public String[] getFormatNames() {
        return new String[]{"ATSR"};
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{""};
    }

    public Class[] getInputTypes() {
        return new Class[]{String.class, File.class, ImageInputStream.class};
    }

    public String getDescription(Locale locale) {
        return "ATSR1/ATSR2 products";
    }

    public ProductReader createReaderInstance() {
        return new AtsrProductReader(this);
    }

    public BeamFileFilter getProductFileFilter() {
        return new BeamFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }
}

