/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr;

import java.util.Calendar;
import java.util.Date;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.ProductData;

public class HeaderUtil {
    public static MetadataAttribute createAttribute(String name, int bitField, int field, String offValue, String onValue) {
        int bitValue = bitField & 1 << field;
        String stringValue = bitValue == 0 ? offValue : onValue;
        return HeaderUtil.createAttribute(name, stringValue);
    }

    public static MetadataAttribute createAttribute(String name, int intData) {
        ProductData data = ProductData.createInstance((int[])new int[]{intData});
        return new MetadataAttribute(name, data, true);
    }

    public static MetadataAttribute createAttribute(String name, int intData, String unit) {
        return HeaderUtil.createAttribute(name, intData, unit, null);
    }

    public static MetadataAttribute createAttribute(String name, int intData, String unit, String description) {
        MetadataAttribute attribute = HeaderUtil.createAttribute(name, intData);
        HeaderUtil.extendAttribute(attribute, unit, description);
        return attribute;
    }

    public static MetadataAttribute createAttribute(String name, float floatData) {
        ProductData data = ProductData.createInstance((float[])new float[]{floatData});
        return new MetadataAttribute(name, data, true);
    }

    public static MetadataAttribute createAttribute(String name, float floatData, String unit) {
        return HeaderUtil.createAttribute(name, floatData, unit, null);
    }

    public static MetadataAttribute createAttribute(String name, float floatData, String unit, String description) {
        MetadataAttribute attribute = HeaderUtil.createAttribute(name, floatData);
        HeaderUtil.extendAttribute(attribute, unit, description);
        return attribute;
    }

    public static MetadataAttribute createAttribute(String name, String stringData) {
        ProductData data = ProductData.createInstance((String)stringData);
        return new MetadataAttribute(name, data, true);
    }

    public static MetadataAttribute createAttribute(String name, String stringData, String unit) {
        return HeaderUtil.createAttribute(name, stringData, unit, null);
    }

    public static MetadataAttribute createAttribute(String name, String stringData, String unit, String description) {
        MetadataAttribute attribute = HeaderUtil.createAttribute(name, stringData);
        HeaderUtil.extendAttribute(attribute, unit, description);
        return attribute;
    }

    public static ProductData.UTC createUTCDate(int year, int dayOfYear, int millisInDay) {
        Calendar calendar = ProductData.UTC.createCalendar();
        calendar.set(1, year);
        calendar.set(6, dayOfYear);
        calendar.add(14, millisInDay);
        return ProductData.UTC.create((Date)calendar.getTime(), (long)0L);
    }

    private static void extendAttribute(MetadataAttribute attribute, String unit, String description) {
        if (unit != null) {
            attribute.setUnit(unit);
        }
        if (description != null) {
            attribute.setDescription(description);
        }
    }
}

