/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.calibration;

import org.esa.beam.dataio.avhrr.AvhrrConstants;
import org.esa.beam.dataio.avhrr.AvhrrReader;
import org.esa.beam.dataio.avhrr.calibration.Radiance2ReflectanceFactorCalibrator;
import org.esa.beam.dataio.avhrr.calibration.ReflectanceFactorCalibrator;

public class VisibleRadianceCalibrator
extends ReflectanceFactorCalibrator {
    private Radiance2ReflectanceFactorCalibrator radianceCalibrator;

    public VisibleRadianceCalibrator(int channel) {
        super(channel);
    }

    public void setHeaderConstants(double equivalentWidth, double solarIrradiance, double earthSunDistance) {
        this.radianceCalibrator = new Radiance2ReflectanceFactorCalibrator(equivalentWidth, solarIrradiance, earthSunDistance);
    }

    @Override
    public String getBandName() {
        return "radiance_" + AvhrrConstants.CH_STRINGS[this.channel];
    }

    @Override
    public String getBandUnit() {
        return "mW / (m^2 sr nm)";
    }

    @Override
    public String getBandDescription() {
        return AvhrrReader.format("Spectral radiance for channel {0}", AvhrrConstants.CH_STRINGS[this.channel]);
    }

    @Override
    public float calibrate(int counts) {
        return this.radianceCalibrator.getConversionFactor() * super.calibrate(counts);
    }
}

