/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.noaa;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.SequenceData;
import java.io.IOException;
import org.esa.beam.dataio.avhrr.AvhrrConstants;
import org.esa.beam.dataio.avhrr.calibration.Calibrator;
import org.esa.beam.dataio.avhrr.noaa.CountReader;
import org.esa.beam.dataio.avhrr.noaa.KlmAvhrrFile;

class CountReader16Bit
extends CountReader {
    private short[] scanLineBuffer;

    public CountReader16Bit(int channel, KlmAvhrrFile noaaFile, Calibrator calibrator, int elementCount, int dataWidth) {
        super(channel, noaaFile, calibrator, dataWidth);
        this.scanLineBuffer = new short[elementCount];
    }

    @Override
    protected void readData(int rawY) throws IOException {
        CompoundData dataRecord = this.noaaFile.getDataRecord(rawY);
        SequenceData avhrr_sensor_data = dataRecord.getSequence("AVHRR_SENSOR_DATA");
        for (int i = 0; i < this.scanLineBuffer.length; ++i) {
            this.scanLineBuffer[i] = avhrr_sensor_data.getShort(i);
        }
        this.extractCounts(this.scanLineBuffer);
    }

    private void extractCounts(short[] rawData) {
        int indexRaw = AvhrrConstants.CH_DATASET_INDEXES[this.channel];
        for (int i = 0; i < this.lineOfCounts.length; ++i) {
            this.lineOfCounts[i] = rawData[indexRaw];
            indexRaw += 5;
        }
    }
}

