/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.noaa;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.DataFormat;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.core.Assert;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import org.esa.beam.dataio.avhrr.AvhrrConstants;
import org.esa.beam.dataio.avhrr.AvhrrFile;
import org.esa.beam.dataio.avhrr.BandReader;
import org.esa.beam.dataio.avhrr.calibration.IrRadianceCalibrator;
import org.esa.beam.dataio.avhrr.calibration.IrTemperatureCalibrator;
import org.esa.beam.dataio.avhrr.calibration.ReflectanceFactorCalibrator;
import org.esa.beam.dataio.avhrr.calibration.VisibleRadianceCalibrator;
import org.esa.beam.dataio.avhrr.noaa.CloudReader;
import org.esa.beam.dataio.avhrr.noaa.FlagReader;
import org.esa.beam.dataio.avhrr.noaa.HeaderWrapper;
import org.esa.beam.dataio.avhrr.noaa.KlmFormatDetector;
import org.esa.beam.dataio.avhrr.noaa.KlmTypes;
import org.esa.beam.dataio.avhrr.noaa.ProductFormat;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.util.Debug;

public class KlmAvhrrFile
extends AvhrrFile
implements AvhrrConstants {
    private final File file;
    private CompoundData noaaData;
    private DataContext context;
    private boolean hasCloudBand = false;
    private ProductFormat productFormat;
    private boolean hasArsHeader;

    public KlmAvhrrFile(File file) {
        this.file = file;
    }

    @Override
    public void readHeader() throws IOException {
        KlmFormatDetector detector = new KlmFormatDetector(this.file);
        Assert.state((boolean)detector.canDecode());
        this.productFormat = detector.getProductFormat();
        this.hasArsHeader = detector.hasArsHeader();
        detector.dispose();
        Debug.trace((String)("ProductFormat=" + (Object)((Object)this.productFormat)));
        Debug.trace((String)("hasArsHeader=" + this.hasArsHeader));
        int blockSize = this.productFormat.getBlockSize();
        int dataRecordCount = this.getDataRecordCount(blockSize);
        CompoundType type = KlmTypes.getFileType(this.hasArsHeader, this.productFormat, dataRecordCount);
        DataFormat dataFormat = new DataFormat(type, ByteOrder.BIG_ENDIAN);
        this.context = dataFormat.createContext(this.file, "r");
        this.noaaData = this.context.getData();
        int tpSubsampling = this.productFormat.getProductDimension().getTpSubsampling();
        int toSkip = dataRecordCount % tpSubsampling - 1;
        if (toSkip < 0) {
            toSkip += tpSubsampling;
        }
        this.productWidth = this.productFormat.getProductDimension().getProductWidth();
        this.productHeight = dataRecordCount - toSkip;
        if (this.getFormatVersion() >= 4 && this.getHeader().getInt("CLAVR_STATUS") == 1) {
            this.hasCloudBand = true;
        }
        this.analyzeScanLineBitfield();
    }

    int getScanlineBitfield(int yIndex) throws IOException {
        return this.getDataRecord(yIndex).getInt("SCANLINE_BIT_FIELD");
    }

    private void analyzeScanLineBitfield() throws IOException {
        boolean isLastSouthBound;
        int first = this.getScanlineBitfield(0);
        int last = this.getScanlineBitfield(this.getProductHeight() - 1);
        boolean isFirstSouthBound = (first & 0x8000) >> 15 == 1;
        boolean bl = isLastSouthBound = (last & 0x8000) >> 15 == 1;
        this.northbound = isFirstSouthBound && isLastSouthBound ? false : !isFirstSouthBound && !isLastSouthBound;
        int firstChannel3ab = first & 3;
        int lastChannel3ab = last & 3;
        this.channel3ab = firstChannel3ab == 1 && lastChannel3ab == 1 ? 2 : (firstChannel3ab == 0 && lastChannel3ab == 0 ? 3 : -1);
    }

    private int getDataRecordCount(long blockSize) throws IOException {
        long realFileSize = this.file.length() - blockSize;
        if (this.hasArsHeader) {
            realFileSize -= 512L;
        }
        return (int)(realFileSize / blockSize);
    }

    CompoundData getHeader() throws IOException {
        return this.noaaData.getCompound("HeaderRecord");
    }

    int getFormatVersion() throws IOException {
        return this.getHeader().getCompound("FILE_IDENTIFICATION").getInt("NOAA_LEVEL_1B_FORMAT_VERSION_NUMBER");
    }

    CompoundData getDataRecord(int yIndex) throws IOException {
        return this.noaaData.getSequence("DataRecord").getCompound(yIndex);
    }

    ProductFormat getProductFormat() {
        return this.productFormat;
    }

    @Override
    public String getProductName() throws IOException {
        SequenceData sequence = this.getHeader().getCompound("FILE_IDENTIFICATION").getSequence("DATA_SET_NAME");
        return HeaderWrapper.getAsString(sequence);
    }

    @Override
    public ProductData.UTC getStartDate() throws IOException {
        CompoundData compound = this.getHeader().getCompound("FILE_IDENTIFICATION").getCompound("START_OF_DATA_SET");
        ProductData.UTC date = HeaderWrapper.createDate(compound);
        return date;
    }

    @Override
    public ProductData.UTC getEndDate() throws IOException {
        CompoundData compound = this.getHeader().getCompound("FILE_IDENTIFICATION").getCompound("END_OF_DATA_SET");
        ProductData.UTC date = HeaderWrapper.createDate(compound);
        return date;
    }

    @Override
    public void addMetaData(MetadataElement metadataRoot) throws IOException {
        HeaderWrapper headerWrapper;
        if (this.hasArsHeader) {
            headerWrapper = new HeaderWrapper(this.noaaData.getCompound(0));
            metadataRoot.addElement(headerWrapper.getAsMetadataElement());
        }
        headerWrapper = new HeaderWrapper(this.getHeader());
        metadataRoot.addElement(headerWrapper.getAsMetadataElement());
    }

    @Override
    public BandReader createVisibleRadianceBandReader(int channel) throws IOException {
        VisibleRadianceCalibrator calibrator = new VisibleRadianceCalibrator(channel);
        String channelString = CH_STRINGS[channel].toUpperCase();
        calibrator.setHeaderConstants(HeaderWrapper.getValue(this.getHeader().getCompound("RADIANCE_CONVERSION"), String.format("CHANNEL_%s_EQUIVALENT_WIDTH", channelString)), HeaderWrapper.getValue(this.getHeader().getCompound("RADIANCE_CONVERSION"), String.format("CHANNEL_%s_SOLAR_IRRADIANCE", channelString)), HeaderWrapper.getValue(this.getHeader().getCompound("NAVIGATION"), "EARTH_SUN_DISTANCE_RATIO"));
        return this.productFormat.createCountReader(channel, this, calibrator);
    }

    @Override
    public BandReader createIrRadianceBandReader(int channel) throws IOException {
        IrRadianceCalibrator calibrator = new IrRadianceCalibrator(channel);
        calibrator.setFormatVersion(this.getFormatVersion());
        return this.productFormat.createCountReader(channel, this, calibrator);
    }

    @Override
    public BandReader createIrTemperatureBandReader(int channel) throws IOException {
        IrTemperatureCalibrator calibrator = new IrTemperatureCalibrator(channel);
        calibrator.setFormatVersion(this.getFormatVersion());
        String channelString = CH_STRINGS[channel].toUpperCase();
        calibrator.setHeaderConstants(HeaderWrapper.getValue(this.getHeader().getCompound("RADIANCE_CONVERSION"), String.format("CHANNEL_%s_CONSTANT_1", channelString)), HeaderWrapper.getValue(this.getHeader().getCompound("RADIANCE_CONVERSION"), String.format("CHANNEL_%s_CONSTANT_2", channelString)), HeaderWrapper.getValue(this.getHeader().getCompound("RADIANCE_CONVERSION"), String.format("CHANNEL_%s_CENTRAL_WAVENUMBER", channelString)));
        return this.productFormat.createCountReader(channel, this, calibrator);
    }

    @Override
    public BandReader createReflectanceFactorBandReader(int channel) {
        ReflectanceFactorCalibrator calibrator = new ReflectanceFactorCalibrator(channel);
        return this.productFormat.createCountReader(channel, this, calibrator);
    }

    @Override
    public BandReader createFlagBandReader() {
        return new FlagReader(this);
    }

    @Override
    public BandReader createCloudBandReader() {
        return new CloudReader(this);
    }

    @Override
    public String[] getTiePointNames() {
        return new String[]{"sun_zenith", "view_zenith", "delta_azimuth", "latitude", "longitude"};
    }

    @Override
    public float[][] getTiePointData() throws IOException {
        int tiePointSubsampling = this.getTiePointSubsampling();
        int gridHeight = this.getProductHeight() / tiePointSubsampling + 1;
        int numTiePoints = 51 * gridHeight;
        float[][] tiePointData = new float[5][numTiePoints];
        int numRawAngles = 153;
        int numRawLatLon = 102;
        short[] rawAngles = new short[153];
        int[] rawLatLon = new int[102];
        int targetIndex = 0;
        int targetIncr = 1;
        if (this.northbound) {
            targetIndex = 51 * (this.productHeight / tiePointSubsampling + 1) - 1;
            targetIncr = -1;
        }
        for (int scanLine = 0; scanLine < this.productHeight; scanLine += tiePointSubsampling) {
            CompoundData dataRecord = this.getDataRecord(scanLine);
            SequenceData angularRelationships = dataRecord.getSequence("ANGULAR_RELATIONSHIPS");
            for (int i = 0; i < 153; ++i) {
                rawAngles[i] = angularRelationships.getShort(i);
            }
            SequenceData earthLocation = dataRecord.getSequence("EARTH_LOCATION");
            for (int i = 0; i < 102; ++i) {
                rawLatLon[i] = earthLocation.getInt(i);
            }
            for (int scanPoint = 0; scanPoint < 51; ++scanPoint) {
                tiePointData[0][targetIndex] = (float)rawAngles[scanPoint * 3] * 0.01f;
                tiePointData[1][targetIndex] = (float)rawAngles[scanPoint * 3 + 1] * 0.01f;
                tiePointData[2][targetIndex] = (float)rawAngles[scanPoint * 3 + 2] * 0.01f;
                tiePointData[3][targetIndex] = (float)rawLatLon[scanPoint * 2] * 1.0E-4f;
                tiePointData[4][targetIndex] = (float)rawLatLon[scanPoint * 2 + 1] * 1.0E-4f;
                targetIndex += targetIncr;
            }
        }
        return tiePointData;
    }

    @Override
    public int getScanLineOffset(int rawY) {
        return 0;
    }

    @Override
    public int getFlagOffset(int rawY) {
        return 0;
    }

    @Override
    public int getTiePointTrimX() {
        return this.productFormat.getProductDimension().getTpTrimX();
    }

    @Override
    public int getTiePointSubsampling() {
        return this.productFormat.getProductDimension().getTpSubsampling();
    }

    @Override
    public boolean hasCloudBand() {
        return this.hasCloudBand;
    }

    @Override
    public void dispose() {
        if (this.context != null) {
            this.context.dispose();
            this.context = null;
        }
        this.noaaData = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canDecode(File file) {
        KlmFormatDetector formatDetector = null;
        try {
            formatDetector = new KlmFormatDetector(file);
            boolean bl = formatDetector.canDecode();
            return bl;
        }
        catch (Throwable e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (formatDetector != null) {
                formatDetector.dispose();
            }
        }
    }
}

