/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.noaa.pod;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.SequenceData;
import java.io.IOException;
import org.esa.beam.dataio.avhrr.calibration.Calibrator;
import org.esa.beam.dataio.avhrr.noaa.pod.CalibrationCoefficientsProvider;
import org.esa.beam.dataio.avhrr.noaa.pod.CalibratorFactory;
import org.esa.beam.dataio.avhrr.noaa.pod.CoefficientCalibrator;

abstract class AbstractCalibratorFactory
implements CalibratorFactory {
    private final int channelIndex;
    private final CalibrationCoefficientsProvider provider;
    private final double interceptScaleFactor;
    private final double slopeScaleFactor;

    protected AbstractCalibratorFactory(int channelIndex, CalibrationCoefficientsProvider provider) {
        this.channelIndex = channelIndex;
        this.provider = provider;
        this.slopeScaleFactor = provider.getSlopeScaleFactor();
        this.interceptScaleFactor = provider.getInterceptScaleFactor();
    }

    @Override
    public final Calibrator createCalibrator(int i) throws IOException {
        SequenceData coefficientsSequence = this.provider.getCalibrationCoefficients(i);
        CompoundData coefficients = coefficientsSequence.getCompound(this.channelIndex);
        double slope = (double)coefficients.getInt(0) * this.slopeScaleFactor;
        double intercept = (double)coefficients.getInt(1) * this.interceptScaleFactor;
        return new CoefficientCalibrator(this, slope, intercept);
    }

    public final int getChannelIndex() {
        return this.channelIndex;
    }
}

