/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.noaa.pod;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import org.esa.beam.dataio.avhrr.BandReader;
import org.esa.beam.dataio.avhrr.noaa.pod.PodAvhrrFile;
import org.esa.beam.dataio.avhrr.noaa.pod.PodAvhrrReaderPlugIn;
import org.esa.beam.framework.dataio.AbstractProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;

final class PodAvhrrReader
extends AbstractProductReader {
    private PodAvhrrFile avhrrFile;

    PodAvhrrReader(PodAvhrrReaderPlugIn plugIn) {
        super((ProductReaderPlugIn)plugIn);
    }

    protected Product readProductNodesImpl() throws IOException {
        Product product;
        File file = PodAvhrrReaderPlugIn.getInputFile(this.getInput());
        try {
            this.avhrrFile = new PodAvhrrFile(file);
            product = this.avhrrFile.createProduct();
            product.setFileLocation(file);
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw e;
        }
        return product;
    }

    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band targetBand, int targetOffsetX, int targetOffsetY, int targetWidth, int targetHeight, ProductData targetBuffer, ProgressMonitor pm) throws IOException {
        BandReader bandReader = this.avhrrFile.getBandReader(targetBand);
        if (bandReader == null) {
            throw new IllegalStateException("No band reader available.");
        }
        bandReader.readBandRasterData(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, targetBuffer, pm);
    }

    public void close() throws IOException {
        super.close();
        this.avhrrFile.dispose();
    }
}

