/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.noaa.pod;

import java.io.File;
import java.util.Locale;
import org.esa.beam.dataio.avhrr.noaa.pod.PodAvhrrFile;
import org.esa.beam.dataio.avhrr.noaa.pod.PodAvhrrReader;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.util.io.BeamFileFilter;

public final class PodAvhrrReaderPlugIn
implements ProductReaderPlugIn {
    private static final String DESCRIPTION = "NOAA Polar Orbiter Data products (AVHRR HRPT)";
    private static final String[] FILE_EXTENSIONS = new String[]{".l1b"};
    private static final String FORMAT_NAME = "NOAA_POD_AVHRR_HRPT";
    private static final String[] FORMAT_NAMES = new String[]{"NOAA_POD_AVHRR_HRPT"};
    private static final Class[] INPUT_TYPES = new Class[]{String.class, File.class};

    public DecodeQualification getDecodeQualification(Object input) {
        File file = PodAvhrrReaderPlugIn.getInputFile(input);
        if (PodAvhrrFile.canDecode(file)) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    public static File getInputFile(Object input) {
        File file = null;
        if (input instanceof String) {
            file = new File((String)input);
        } else if (input instanceof File) {
            file = (File)input;
        }
        return file;
    }

    public Class[] getInputTypes() {
        return INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new PodAvhrrReader(this);
    }

    public BeamFileFilter getProductFileFilter() {
        return new BeamFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }

    public String[] getFormatNames() {
        return FORMAT_NAMES;
    }

    public String[] getDefaultFileExtensions() {
        return FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return DESCRIPTION;
    }
}

