/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.noaa.pod;

import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Rectangle;
import javax.media.jai.PlanarImage;
import org.esa.beam.dataio.avhrr.noaa.pod.PodPixelFinder;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.GeoApproximation;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.PixelPosEstimator;
import org.esa.beam.framework.datamodel.Scene;
import org.esa.beam.framework.datamodel.TiePointGeoCoding;
import org.esa.beam.framework.datamodel.TiePointGrid;

final class PodGeoCoding
extends TiePointGeoCoding {
    private transient PixelPosEstimator pixelPosEstimator;
    private transient PodPixelFinder pixelFinder;

    PodGeoCoding(TiePointGrid latGrid, TiePointGrid lonGrid) {
        super(latGrid, lonGrid);
        MultiLevelImage lonImage = lonGrid.getGeophysicalImage();
        MultiLevelImage latImage = latGrid.getGeophysicalImage();
        GeoApproximation[] approximations = PodGeoCoding.createApproximations((PlanarImage)lonImage, (PlanarImage)latImage);
        Rectangle bounds = new Rectangle(0, 0, lonGrid.getSceneRasterWidth(), lonGrid.getSceneRasterHeight());
        this.pixelPosEstimator = new PixelPosEstimator(approximations, bounds);
        this.pixelFinder = new PodPixelFinder((PlanarImage)lonImage, (PlanarImage)latImage, null, 0.01);
    }

    public boolean canGetPixelPos() {
        return this.pixelPosEstimator.canGetPixelPos();
    }

    public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        if (this.pixelPosEstimator.canGetPixelPos()) {
            if (pixelPos == null) {
                pixelPos = new PixelPos();
            }
            this.pixelPosEstimator.getPixelPos(geoPos, pixelPos);
            if (pixelPos.isValid()) {
                this.pixelFinder.findPixelPos(geoPos, pixelPos);
            }
        } else {
            super.getPixelPos(geoPos, pixelPos);
        }
        return pixelPos;
    }

    private static GeoApproximation[] createApproximations(PlanarImage lonImage, PlanarImage latImage) {
        return GeoApproximation.createApproximations((PlanarImage)lonImage, (PlanarImage)latImage, null, (double)0.5);
    }

    public boolean transferGeoCoding(Scene sourceScene, Scene targetScene, ProductSubsetDef subsetDef) {
        return false;
    }

    public void dispose() {
        super.dispose();
        this.pixelFinder = null;
        this.pixelPosEstimator = null;
    }
}

