/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.operator.cloud;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.jexp.ParseException;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.esa.beam.dataio.envisat.EnvisatConstants;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.operator.cloud.CloudPN;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.ResourceInstaller;
import org.esa.beam.util.SystemUtils;

@OperatorMetadata(alias="CloudProb", category="Optical Processing/Pre-Processing", version="1.7", authors="Rene Preusker (Algorithm), Tom Block (BEAM Implementation), Thomas Storm (GPF conversion)", copyright="Copyright (C) 2004-2014 by ESA, FUB and Brockmann Consult", description="Applies a clear sky conservative cloud detection algorithm.")
public class CloudOperator
extends Operator {
    public static final String AUXDATA_DIR = "snap-meris-cloud/auxdata";
    @SourceProduct(alias="source", label="Source product", description="The MERIS Level 1b source product.")
    private Product l1bProduct;
    @TargetProduct(label="Cloud product")
    private Product targetProduct;
    private CloudPN cloudNode;
    private Product tempCloudProduct;

    public void initialize() {
        this.setLogger(Logger.getLogger("beam.processor.cloud"));
        this.getLogger().info("Starting request...");
        this.initCloudNode();
        try {
            this.initOutputProduct();
        }
        catch (ParseException | IOException e) {
            throw new OperatorException("Unable to initialise output product.", e);
        }
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        for (Map.Entry<Band, Tile> entry : targetTiles.entrySet()) {
            this.checkForCancellation();
            Band targetBand = entry.getKey();
            Tile targetTile = entry.getValue();
            Band sourceBand = this.tempCloudProduct.getBand(targetBand.getName());
            Rectangle targetRect = targetTile.getRectangle();
            ProductData rawSamples = this.getSourceTile((RasterDataNode)sourceBand, targetRect).getRawSamples();
            targetTile.setRawSamples(rawSamples);
        }
    }

    private void initCloudNode() {
        try {
            this.installAuxdata();
        }
        catch (IOException e) {
            throw new OperatorException("Unable to install auxiliary data.", (Throwable)e);
        }
        HashMap<String, String> cloudConfig = new HashMap<String, String>();
        cloudConfig.put("config_file_name", "cloud_config.txt");
        cloudConfig.put("invalid_expression", "l1_flags.INVALID");
        this.cloudNode = new CloudPN(this.getAuxdataInstallationPath());
        try {
            this.cloudNode.setUp(cloudConfig);
        }
        catch (IOException e) {
            throw new OperatorException("Failed to initialise cloud source: " + e.getMessage(), (Throwable)e);
        }
    }

    void installAuxdata() throws IOException {
        String auxdataDirPath = this.getAuxdataInstallationPath();
        this.installAuxdata(ResourceInstaller.getSourceUrl(((Object)((Object)this)).getClass()), "auxdata/", new File(auxdataDirPath));
    }

    String getAuxdataInstallationPath() {
        File defaultAuxdataDir = new File(SystemUtils.getApplicationDataDir(), AUXDATA_DIR);
        return System.getProperty("cloud.auxdata.dir", defaultAuxdataDir.getAbsolutePath());
    }

    private void installAuxdata(URL sourceLocation, String sourceRelPath, File auxdataInstallDir) throws IOException {
        new ResourceInstaller(sourceLocation, sourceRelPath, auxdataInstallDir).install(".*", ProgressMonitor.NULL);
    }

    private void initOutputProduct() throws IOException, ParseException {
        if (!EnvisatConstants.MERIS_L1_TYPE_PATTERN.matcher(this.l1bProduct.getProductType()).matches()) {
            throw new OperatorException("Product type '" + this.l1bProduct.getProductType() + "' is not supported." + "It must be a MERIS Level 1b product.");
        }
        this.tempCloudProduct = this.cloudNode.readProductNodes(this.l1bProduct, null);
        this.targetProduct = this.cloudNode.createTargetProductImpl();
        ProductUtils.copyFlagBands((Product)this.l1bProduct, (Product)this.targetProduct, (boolean)true);
        ProductUtils.copyTiePointGrids((Product)this.l1bProduct, (Product)this.targetProduct);
        ProductUtils.copyGeoCoding((Product)this.l1bProduct, (Product)this.targetProduct);
        ProductUtils.copyMetadata((Product)this.l1bProduct, (Product)this.targetProduct);
        this.targetProduct.setStartTime(this.l1bProduct.getStartTime());
        this.targetProduct.setEndTime(this.l1bProduct.getEndTime());
        this.cloudNode.startProcessing();
        this.getLogger().info("Output product successfully initialised");
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(CloudOperator.class);
        }
    }
}

