/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.merisl3;

import org.esa.beam.dataio.merisl3.ISINGrid;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.AbstractGeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Scene;
import org.esa.beam.framework.dataop.maptransf.Datum;

public class ISINGeoCoding
extends AbstractGeoCoding {
    private ISINGrid _grid;

    public ISINGeoCoding(ISINGrid grid) {
        this._grid = grid;
    }

    public boolean transferGeoCoding(Scene srcScene, Scene destScene, ProductSubsetDef subsetDef) {
        return false;
    }

    public boolean isCrossingMeridianAt180() {
        return false;
    }

    public boolean canGetPixelPos() {
        return true;
    }

    public boolean canGetGeoPos() {
        return true;
    }

    public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        pixelPos = pixelPos == null ? new PixelPos() : pixelPos;
        pixelPos.x = -1.0f;
        pixelPos.y = -1.0f;
        int rowIndex = (int)((90.0f - geoPos.lat) * (float)this._grid.getRowCount() / 180.0f);
        if (rowIndex >= 0 && rowIndex < this._grid.getRowCount()) {
            int colIndex = (int)((double)(180.0f + geoPos.lon) / this._grid.getDeltaLon(rowIndex));
            int rowLength = this._grid.getRowLength(rowIndex);
            if (colIndex >= 0 && colIndex < rowLength) {
                pixelPos.x = this._grid.getRowCount() - rowLength / 2 + colIndex;
                pixelPos.y = rowIndex;
            }
        }
        return pixelPos;
    }

    public GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
        geoPos = geoPos == null ? new GeoPos() : geoPos;
        geoPos.lat = -1.0f;
        geoPos.lon = -1.0f;
        int rowIndex = (int)pixelPos.y;
        if (rowIndex >= 0 && rowIndex < this._grid.getRowCount()) {
            int rowLength = this._grid.getRowLength(rowIndex);
            float colIndex = pixelPos.x - (float)this._grid.getRowCount() + (float)(rowLength / 2);
            if (colIndex >= 0.0f && colIndex < (float)rowLength) {
                geoPos.lat = 90.0f - 180.0f * pixelPos.y / (float)this._grid.getRowCount();
                geoPos.lon = (float)((double)colIndex * this._grid.getDeltaLon(rowIndex) - 180.0);
            }
        }
        return geoPos;
    }

    public Datum getDatum() {
        return Datum.WGS_84;
    }

    public void dispose() {
        this._grid = null;
    }
}

