/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.spot;

import com.bc.ceres.binding.PropertySet;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.esa.beam.dataio.spot.SpotVgtProductReaderPlugIn;
import org.esa.beam.framework.datamodel.CrsGeoCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.util.Debug;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

final class LogVolDescriptor {
    private final PropertySet propertySet;
    private final String productId;
    private static final double PIXEL_CENTER = 0.5;
    private static final DateFormat DATE_FORMAT = ProductData.UTC.createDateFormat((String)"yyyyMMddHHmmss");

    public LogVolDescriptor(Reader reader) throws IOException {
        this.propertySet = SpotVgtProductReaderPlugIn.readKeyValuePairs(reader);
        this.productId = this.getValueString("PRODUCT_ID");
    }

    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    public String getValueString(String key) {
        return (String)this.propertySet.getValue(key);
    }

    Integer getValueInteger(String key) {
        String value = this.getValueString(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    Double getValueDouble(String key) {
        String value = this.getValueString(key);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    Date getValueDate(String s) {
        String value = this.getValueString(s);
        if (value != null) {
            try {
                return DATE_FORMAT.parse(value);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    Date getValueDate(String s1, String s2) {
        String value1 = this.getValueString(s1);
        String value2 = this.getValueString(s2);
        if (value1 != null && value2 != null) {
            try {
                return DATE_FORMAT.parse(value1 + value2);
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        return null;
    }

    public String getProductId() {
        return this.productId;
    }

    public GeoCoding getGeoCoding() {
        String geodeticSystName = this.getValueString("GEODETIC_SYST_NAME");
        if (geodeticSystName == null) {
            return null;
        }
        if (geodeticSystName.equals("WGS 1984")) {
            String mapProjUnit = this.getValueString("MAP_PROJ_UNIT");
            if (mapProjUnit != null && !mapProjUnit.equals("DEGREES")) {
                return null;
            }
            Double meridianOrigin = this.getValueDouble("MERIDIAN_ORIGIN");
            if (meridianOrigin != null && meridianOrigin != 0.0) {
                return null;
            }
            Rectangle imageBounds = this.getImageBounds();
            if (imageBounds == null) {
                return null;
            }
            Double pixelSize = this.getValueDouble("MAP_PROJ_RESOLUTION");
            Double upperLeftLat = this.getValueDouble("GEO_UPPER_LEFT_LAT");
            Double upperLeftLon = this.getValueDouble("GEO_UPPER_LEFT_LONG");
            if (pixelSize != null && upperLeftLat != null && upperLeftLon != null) {
                try {
                    AffineTransform transform = new AffineTransform();
                    transform.translate(upperLeftLon, upperLeftLat);
                    transform.scale(pixelSize, -pixelSize.doubleValue());
                    transform.translate(-0.5, -0.5);
                    return new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, imageBounds, transform);
                }
                catch (TransformException e) {
                }
                catch (FactoryException e) {}
            }
        } else if (geodeticSystName.equals("UTM/UPS INTERNATIONAL 1909")) {
            Rectangle imageBounds;
            Double yOrigin;
            Double xOrigin;
            Double scaleFactor;
            Double longOrigin;
            Double semiMinAxis;
            Double semiMajAxis;
            String spheroidName;
            String mapProjUnit = this.getValueString("MAP_PROJ_UNIT");
            if (mapProjUnit != null && !mapProjUnit.equals("METERS")) {
                return null;
            }
            Double meridianOrigin = this.getValueDouble("MERIDIAN_ORIGIN");
            if (meridianOrigin == null) {
                meridianOrigin = 0.0;
            }
            if ((spheroidName = this.getValueString("SPHEROID_NAME")) == null) {
                spheroidName = "INTERNATIONAL HAYFORD 1909";
            }
            if ((semiMajAxis = this.getValueDouble("SPHEROID_SEMI_MAJ_AXIS")) == null) {
                semiMajAxis = DefaultGeographicCRS.WGS84.getDatum().getEllipsoid().getSemiMajorAxis();
            }
            if ((semiMinAxis = this.getValueDouble("SPHEROID_SEMI_MIN_AXIS")) == null) {
                semiMinAxis = DefaultGeographicCRS.WGS84.getDatum().getEllipsoid().getSemiMinorAxis();
            }
            if ((longOrigin = this.getValueDouble("PROJ_LONG_ORIGIN")) == null) {
                longOrigin = 0.0;
            }
            if ((scaleFactor = this.getValueDouble("PROJ_SCALE_FACTOR")) == null) {
                scaleFactor = 1.0;
            }
            if ((xOrigin = this.getValueDouble("PROJ_X_ORIGIN")) == null) {
                xOrigin = 0.0;
            }
            if ((yOrigin = this.getValueDouble("PROJ_Y_ORIGIN")) == null) {
                yOrigin = 0.0;
            }
            if ((imageBounds = this.getImageBounds()) == null) {
                return null;
            }
            Double pixelSize = this.getValueDouble("MAP_PROJ_RESOLUTION");
            Double upperLeftLon = this.getValueDouble("CARTO_UPPER_LEFT_X");
            Double upperLeftLat = this.getValueDouble("CARTO_UPPER_LEFT_Y");
            String projHemi = this.getValueString("PROJ_HEMI");
            String meridianName = this.getValueString("MERIDIAN_NAME");
            if (pixelSize != null && upperLeftLat != null && upperLeftLon != null && projHemi != null && meridianName != null) {
                double standardParallel;
                String projectionName;
                AffineTransform transform = new AffineTransform();
                transform.translate(upperLeftLon, upperLeftLat);
                transform.scale(pixelSize, -pixelSize.doubleValue());
                transform.translate(-0.5, -0.5);
                double inverseFlattening = semiMajAxis / (semiMajAxis - semiMinAxis);
                if (projHemi.equalsIgnoreCase("SOUTH")) {
                    projectionName = "Stereographic_South_Pole";
                    standardParallel = -90.0;
                } else {
                    projectionName = "Stereographic_North_Pole";
                    standardParallel = 90.0;
                }
                String upsWktPattern = "PROJCS[\"%s\", \n  GEOGCS[\"%s\", \n    DATUM[\"%s\", \n      SPHEROID[\"%s\", %f, %f]], \n    PRIMEM[\"%s\", %f], \n    UNIT[\"degree\", 0.017453292519943295], \n    AXIS[\"Geodetic longitude\", EAST], \n    AXIS[\"Geodetic latitude\", NORTH]], \n  PROJECTION[\"%s\"], \n  PARAMETER[\"central_meridian\", %f], \n  PARAMETER[\"standard_parallel_1\", %f], \n  PARAMETER[\"scale_factor\", %f], \n  PARAMETER[\"false_easting\", %f], \n  PARAMETER[\"false_northing\", %f], \n  UNIT[\"m\", 1.0], \n  AXIS[\"Easting\", EAST], \n  AXIS[\"Northing\", NORTH] \n]";
                String upsWkt = String.format(upsWktPattern, geodeticSystName, spheroidName, spheroidName, spheroidName, semiMajAxis, inverseFlattening, meridianName, meridianOrigin, projectionName, longOrigin, standardParallel, scaleFactor, xOrigin, yOrigin);
                try {
                    CoordinateReferenceSystem crs = CRS.parseWKT((String)upsWkt);
                    return new CrsGeoCoding(crs, imageBounds, transform);
                }
                catch (Throwable t) {
                    Debug.trace((String)("upsWkt = " + upsWkt));
                    Debug.trace((Throwable)t);
                }
            }
        }
        return null;
    }

    public Date getStartDate() {
        Date date = this.getValueDate("SYNTHESIS_FIRST_DATE");
        if (date == null) {
            date = this.getValueDate("SEGM_FIRST_DATE", "SEGM_FIRST_TIME");
        }
        return date;
    }

    public Date getEndDate() {
        Date date = this.getValueDate("SYNTHESIS_LAST_DATE");
        if (date == null) {
            date = this.getValueDate("SEGM_LAST_DATE", "SEGM_LAST_TIME");
        }
        return date;
    }

    Rectangle getImageBounds() {
        Integer upperLeftCol = this.getValueInteger("IMAGE_UPPER_LEFT_COL");
        Integer upperLeftRow = this.getValueInteger("IMAGE_UPPER_LEFT_ROW");
        Integer lowerRightCol = this.getValueInteger("IMAGE_LOWER_RIGHT_COL");
        Integer lowerRightRow = this.getValueInteger("IMAGE_LOWER_RIGHT_ROW");
        if (upperLeftCol != null && upperLeftRow != null && lowerRightCol != null && lowerRightRow != null) {
            return new Rectangle(upperLeftCol - 1, upperLeftRow - 1, lowerRightCol - upperLeftCol + 1, lowerRightRow - upperLeftRow + 1);
        }
        return null;
    }
}

