/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.spot;

import com.bc.ceres.binding.PropertySet;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.esa.beam.dataio.spot.SpotVgtProductReaderPlugIn;

final class PhysVolDescriptor {
    private final PropertySet propertySet;
    private final int physVolNumber;
    private final String productId;
    private final String formatReference;
    private final String logVolDirName;
    private String logVolDescrFileName;

    public static PhysVolDescriptor create(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            PhysVolDescriptor physVolDescriptor = new PhysVolDescriptor(reader);
            return physVolDescriptor;
        }
    }

    public PhysVolDescriptor(Reader reader) throws IOException {
        this.propertySet = SpotVgtProductReaderPlugIn.readKeyValuePairs(reader);
        String value = this.getValue("PHYS_VOL_NUMBER");
        if (value != null) {
            try {
                this.physVolNumber = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new IOException("Invalid SPOT VGT volume descriptor. Missing value for 'PHYS_VOL_NUMBER'.");
            }
        } else {
            throw new IOException("Invalid SPOT VGT volume descriptor. Missing value for 'PHYS_VOL_NUMBER'.");
        }
        this.logVolDirName = String.format("%04d", this.physVolNumber);
        this.logVolDescrFileName = String.format("%s/%s_LOG.TXT", this.logVolDirName, this.logVolDirName);
        this.productId = this.getValue(String.format("PRODUCT_#%s_ID", this.logVolDirName));
        this.formatReference = this.getValue("FORMAT_REFERENCE");
    }

    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    public String getValue(String key) {
        return (String)this.propertySet.getValue(key);
    }

    public int getPhysVolNumber() {
        return this.physVolNumber;
    }

    public String getLogVolDirName() {
        return this.logVolDirName;
    }

    public String getLogVolDescriptorFileName() {
        return this.logVolDescrFileName;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getFormatReference() {
        return this.formatReference;
    }
}

