/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.spot;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.core.VirtualDir;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import org.esa.beam.dataio.spot.PhysVolDescriptor;
import org.esa.beam.dataio.spot.SpotVgtProductReader;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.util.io.BeamFileFilter;

public class SpotVgtProductReaderPlugIn
implements ProductReaderPlugIn {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecodeQualification getDecodeQualification(Object input) {
        DecodeQualification decodeQualification;
        File file = SpotVgtProductReaderPlugIn.getFileInput(input);
        if (file == null) {
            return DecodeQualification.UNABLE;
        }
        VirtualDir virtualDir = VirtualDir.create((File)file);
        if (virtualDir == null) {
            return DecodeQualification.UNABLE;
        }
        try {
            Reader reader = virtualDir.getReader("PHYS_VOL.TXT");
            if (reader == null) {
                DecodeQualification decodeQualification2 = DecodeQualification.UNABLE;
                return decodeQualification2;
            }
            try {
                PhysVolDescriptor descriptor = new PhysVolDescriptor(reader);
                String[] strings = virtualDir.list(descriptor.getLogVolDirName());
                if (strings.length == 0) {
                    DecodeQualification decodeQualification3 = DecodeQualification.UNABLE;
                    return decodeQualification3;
                }
            }
            finally {
                reader.close();
            }
            decodeQualification = DecodeQualification.INTENDED;
            return decodeQualification;
        }
        catch (IOException e) {
            decodeQualification = DecodeQualification.UNABLE;
            return decodeQualification;
        }
        finally {
            virtualDir.close();
        }
    }

    public Class[] getInputTypes() {
        return new Class[]{String.class, File.class};
    }

    public ProductReader createReaderInstance() {
        return new SpotVgtProductReader(this);
    }

    public BeamFileFilter getProductFileFilter() {
        return new BeamFileFilter("SPOT-VGT", this.getDefaultFileExtensions(), this.getDescription(null));
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{".txt", ".TXT", ".zip", ".ZIP"};
    }

    public String getDescription(Locale locale) {
        return "SPOT VGT Data Products";
    }

    public String[] getFormatNames() {
        return new String[]{"SPOT-VGT"};
    }

    static String getBandName(String name) {
        int p1 = name.indexOf("_");
        int p2 = name.lastIndexOf(46);
        return name.substring(p1 == -1 ? 0 : p1 + 1, p2);
    }

    static PropertySet readPhysVolDescriptor(File inputFile) throws IOException {
        return SpotVgtProductReaderPlugIn.readKeyValuePairs(inputFile);
    }

    static PropertySet readKeyValuePairs(File inputFile) throws IOException {
        return SpotVgtProductReaderPlugIn.readKeyValuePairs(new FileReader(inputFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PropertySet readKeyValuePairs(Reader reader) throws IOException {
        try (BufferedReader breader = new BufferedReader(reader);){
            String line;
            PropertyContainer headerProperties = new PropertyContainer();
            while ((line = breader.readLine()) != null) {
                String value;
                String key;
                int i = (line = line.trim()).indexOf(32);
                if (i > 0) {
                    key = line.substring(0, i);
                    value = line.substring(i + 1).trim();
                } else {
                    key = line;
                    value = "";
                }
                headerProperties.addProperty(Property.create((String)key, (Object)value));
            }
            PropertyContainer propertyContainer = headerProperties;
            return propertyContainer;
        }
    }

    static File getFileInput(Object input) {
        if (input instanceof String) {
            return SpotVgtProductReaderPlugIn.getFileInput(new File((String)input));
        }
        if (input instanceof File) {
            return SpotVgtProductReaderPlugIn.getFileInput((File)input);
        }
        return null;
    }

    static File getFileInput(File file) {
        if (file.isDirectory()) {
            return file;
        }
        if (file.getName().endsWith(".zip") || file.getName().endsWith(".ZIP")) {
            return file;
        }
        if (file.getName().endsWith(".txt") || file.getName().endsWith(".TXT")) {
            return file.getParentFile();
        }
        return null;
    }
}

