/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.worldmap;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.annotations.LayerTypeMetadata;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glevel.MultiLevelSource;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.esa.beam.glayer.WorldMapLayerType;
import org.esa.beam.glevel.TiledFileMultiLevelSource;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.crs.DefaultGeographicCRS;

@LayerTypeMetadata(name="BlueMarbleLayerType", aliasNames={"org.esa.beam.worldmap.BlueMarbleLayerType"})
public class BlueMarbleLayerType
extends WorldMapLayerType {
    private static final String WORLD_IMAGE_DIR_PROPERTY_NAME = "org.esa.beam.worldImageDir";
    private static final String WORLD_MAP_LAYER_NAME = "World Map (NASA Blue Marble)";
    private static final String WORLD_MAP_LABEL = "NASA Blue Marble";
    private volatile MultiLevelSource multiLevelSource;

    public String getLabel() {
        return WORLD_MAP_LABEL;
    }

    public boolean isValidFor(LayerContext ctx) {
        if (ctx.getCoordinateReferenceSystem() instanceof AbstractIdentifiedObject) {
            AbstractIdentifiedObject crs = (AbstractIdentifiedObject)ctx.getCoordinateReferenceSystem();
            return DefaultGeographicCRS.WGS84.equals(crs, false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Layer createLayer(LayerContext ctx, PropertySet configuration) {
        Property[] propertyArray;
        if (this.multiLevelSource == null) {
            propertyArray = this;
            // MONITORENTER : this
            if (this.multiLevelSource == null) {
                this.multiLevelSource = BlueMarbleLayerType.createMultiLevelSource();
            }
            // MONITOREXIT : propertyArray
        }
        propertyArray = super.createLayerConfig(ctx).getProperties();
        int n = propertyArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                configuration.setValue("multiLevelSource", (Object)this.multiLevelSource);
                ImageLayer layer = new ImageLayer((ImageLayer.Type)this, this.multiLevelSource, configuration);
                layer.setName(WORLD_MAP_LAYER_NAME);
                layer.setVisible(true);
                return layer;
            }
            Property model = propertyArray[n2];
            if (configuration.getProperty(model.getDescriptor().getName()) == null) {
                configuration.addProperty(model);
            }
            ++n2;
        }
    }

    private static MultiLevelSource createMultiLevelSource() {
        TiledFileMultiLevelSource multiLevelSource;
        String dirPath = System.getProperty(WORLD_IMAGE_DIR_PROPERTY_NAME);
        if (dirPath == null || dirPath.isEmpty()) {
            dirPath = BlueMarbleLayerType.getDirPathFromModule();
        }
        if (dirPath == null) {
            throw new IllegalStateException("World image directory not found.");
        }
        try {
            multiLevelSource = TiledFileMultiLevelSource.create((File)new File(dirPath));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return multiLevelSource;
    }

    private static String getDirPathFromModule() {
        URL resource = BlueMarbleLayerType.class.getResource("image.properties");
        try {
            return new File(resource.toURI()).getParent();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }
}

