/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.runtime.ModuleRuntime;
import com.bc.ceres.core.runtime.RuntimeConfig;
import com.bc.ceres.core.runtime.RuntimeConfigException;
import com.bc.ceres.core.runtime.internal.RuntimeImpl;
import com.bc.ceres.core.runtime.internal.SplashScreenProgressMonitor;
import com.bc.ceres.core.runtime.support.DefaultRuntimeConfig;

public final class RuntimeFactory {
    public static RuntimeConfig createRuntimeConfig() throws CoreException {
        try {
            return new DefaultRuntimeConfig();
        }
        catch (RuntimeConfigException e) {
            throw new CoreException("Failed to set-up Ceres runtime configuration", e);
        }
    }

    public static ModuleRuntime createRuntime(RuntimeConfig config, String[] commandLineArgs) {
        ProgressMonitor progressMonitor = RuntimeFactory.createProgressMonitor(config);
        return RuntimeFactory.createRuntime(config, commandLineArgs, progressMonitor);
    }

    public static ModuleRuntime createRuntime(RuntimeConfig config, String[] commandLineArgs, ProgressMonitor progressMonitor) {
        return new RuntimeImpl(config, commandLineArgs, progressMonitor);
    }

    public static ProgressMonitor createProgressMonitor(RuntimeConfig config) {
        try {
            Class.forName("java.awt.SplashScreen");
            return SplashScreenProgressMonitor.createProgressMonitor(config);
        }
        catch (ClassNotFoundException e) {
            return ProgressMonitor.NULL;
        }
    }
}

