/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;

public class TableLayout
implements LayoutManager2 {
    private GridBagLayout gbl = new GridBagLayout();
    private HashMap<String, Object> propertyMap = new HashMap(32);
    private int columnCount;
    private Cell currentCell;

    public TableLayout() {
        this(1);
    }

    public TableLayout(int columnCount) {
        this.columnCount = columnCount;
        this.currentCell = new Cell();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    public void setCellColspan(int row, int col, Integer colspan) {
        this.setCellValue("gridwidth", row, col, colspan);
    }

    public void setCellRowspan(int row, int col, Integer rowspan) {
        this.setCellValue("gridheight", row, col, rowspan);
    }

    public void setTablePadding(int hpadding, int vpadding) {
        this.setTablePadding(new Insets(0, 0, vpadding, hpadding));
        this.setColumnPadding(0, new Insets(0, hpadding, vpadding, hpadding));
        this.setRowPadding(0, new Insets(vpadding, 0, vpadding, hpadding));
        this.setCellPadding(0, 0, new Insets(vpadding, hpadding, vpadding, hpadding));
    }

    public void setTablePadding(Insets insets) {
        this.setValue("insets", insets);
    }

    public void setRowPadding(int row, Insets insets) {
        this.setRowValue("insets", row, insets);
    }

    public void setColumnPadding(int col, Insets insets) {
        this.setColumnValue("insets", col, insets);
    }

    public void setCellPadding(int row, int col, Insets insets) {
        this.setCellValue("insets", row, col, insets);
    }

    public void setTableWeightX(Double weightx) {
        this.setValue("weightx", weightx);
    }

    public void setRowWeightX(int row, Double weightx) {
        this.setRowValue("weightx", row, weightx);
    }

    public void setColumnWeightX(int col, Double weightx) {
        this.setColumnValue("weightx", col, weightx);
    }

    public void setCellWeightX(int row, int col, Double weightx) {
        this.setCellValue("weightx", row, col, weightx);
    }

    public void setTableWeightY(Double weightx) {
        this.setValue("weighty", weightx);
    }

    public void setRowWeightY(int row, Double weighty) {
        this.setRowValue("weighty", row, weighty);
    }

    public void setColumnWeightY(int col, Double weighty) {
        this.setColumnValue("weighty", col, weighty);
    }

    public void setCellWeightY(int row, int col, Double weighty) {
        this.setCellValue("weighty", row, col, weighty);
    }

    public void setTableFill(Fill fill) {
        this.setValue("fill", (Object)fill);
    }

    public void setRowFill(int row, Fill fill) {
        this.setRowValue("fill", row, (Object)fill);
    }

    public void setColumnFill(int col, Fill fill) {
        this.setColumnValue("fill", col, (Object)fill);
    }

    public void setCellFill(int row, int col, Fill fill) {
        this.setCellValue("fill", row, col, (Object)fill);
    }

    public void setTableAnchor(Anchor anchor) {
        this.setValue("anchor", (Object)anchor);
    }

    public void setRowAnchor(int row, Anchor anchor) {
        this.setRowValue("anchor", row, (Object)anchor);
    }

    public void setColumnAnchor(int col, Anchor anchor) {
        this.setColumnValue("anchor", col, (Object)anchor);
    }

    public void setCellAnchor(int row, int col, Anchor anchor) {
        this.setCellValue("anchor", row, col, (Object)anchor);
    }

    public Component createHorizontalSpacer() {
        this.setCellFill(this.currentCell.row, this.currentCell.col, Fill.BOTH);
        this.setCellWeightX(this.currentCell.row, this.currentCell.col, 1.0);
        return new JPanel();
    }

    public Component createVerticalSpacer() {
        this.setCellColspan(this.currentCell.row, 0, this.columnCount);
        this.setCellFill(this.currentCell.row, this.currentCell.col, Fill.BOTH);
        this.setCellWeightY(this.currentCell.row, this.currentCell.col, 1.0);
        return new JPanel();
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return this.gbl.getLayoutAlignmentX(target);
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return this.gbl.getLayoutAlignmentY(target);
    }

    @Override
    public void invalidateLayout(Container target) {
        this.gbl.invalidateLayout(target);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints == null) {
            this.addLayoutComponent(comp, this.currentCell);
        } else if (constraints instanceof Cell) {
            this.addLayoutComponent(comp, (Cell)constraints);
        } else {
            throw new IllegalArgumentException("cannot add to layout: constraints must be null or a TableLayout.Cell");
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.gbl.removeLayoutComponent(comp);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.gbl.layoutContainer(parent);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.gbl.minimumLayoutSize(parent);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.gbl.preferredLayoutSize(parent);
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        return this.gbl.maximumLayoutSize(parent);
    }

    public static Cell cell() {
        return new Cell();
    }

    public static Cell cell(int row, int col) {
        return new Cell(row, col);
    }

    public static Cell cell(int row, int col, int rowspan, int colspan) {
        return new Cell(row, col, rowspan, colspan);
    }

    private void addLayoutComponent(Component comp, Cell cell) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = cell.col;
        gbc.gridy = cell.row;
        gbc.gridwidth = cell.colspan;
        gbc.gridheight = cell.rowspan;
        this.setField(gbc, "gridwidth", cell);
        this.setField(gbc, "gridheight", cell);
        this.setField(gbc, "weightx", cell);
        this.setField(gbc, "weighty", cell);
        this.setField(gbc, "fill", cell);
        this.setField(gbc, "anchor", cell);
        this.setField(gbc, "insets", cell);
        this.gbl.addLayoutComponent(comp, gbc);
        this.currentCell.col = gbc.gridx + gbc.gridwidth;
        if (this.currentCell.col >= this.columnCount) {
            this.currentCell.col = 0;
            ++this.currentCell.row;
        }
    }

    private void setField(Object object, String name, Cell cell) {
        Object value = this.getValue(name, cell);
        if (value != null) {
            try {
                Field field = object.getClass().getField(name);
                field.set(object, value);
            }
            catch (Exception e) {
                throw new IllegalStateException(name, e);
            }
        }
    }

    private Object getValue(String name, Cell cell) {
        Object value = this.getCellValue(name, cell.row, cell.col);
        if (value == null && (value = this.getColumnValue(name, cell.col)) == null && (value = this.getRowValue(name, cell.row)) == null) {
            value = this.getValue(name);
        }
        if (value instanceof Fill) {
            value = ((Fill)((Object)value)).value();
        } else if (value instanceof Anchor) {
            value = ((Anchor)((Object)value)).value();
        }
        return value;
    }

    private Object getCellValue(String name, int row, int col) {
        return this.getValue(TableLayout.getCellName(name, row, col));
    }

    private void setCellValue(String name, int row, int col, Object value) {
        this.setValue(TableLayout.getCellName(name, row, col), value);
    }

    private Object getRowValue(String name, int row) {
        return this.getValue(TableLayout.getCellName(name, row, -1));
    }

    private void setRowValue(String name, int row, Object value) {
        this.setValue(TableLayout.getCellName(name, row, -1), value);
    }

    private Object getColumnValue(String name, int col) {
        return this.getValue(TableLayout.getCellName(name, -1, col));
    }

    private void setColumnValue(String name, int col, Object value) {
        this.setValue(TableLayout.getCellName(name, -1, col), value);
    }

    private Object getValue(String name) {
        return this.propertyMap.get(name);
    }

    private void setValue(String name, Object value) {
        if (value != null) {
            this.propertyMap.put(name, value);
        } else {
            this.propertyMap.remove(name);
        }
    }

    private static String getCellName(String name, int row, int col) {
        StringBuilder sb = new StringBuilder(name);
        sb.append('(');
        TableLayout.appendIndex(sb, row);
        sb.append(',');
        TableLayout.appendIndex(sb, col);
        sb.append(')');
        return sb.toString();
    }

    private static void appendIndex(StringBuilder sb, int index) {
        if (index >= 0) {
            sb.append(index);
        } else {
            sb.append('*');
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append('[');
        Set<Map.Entry<String, Object>> entries = this.propertyMap.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            sb.append(entry.getKey()).append('=').append(entry.getValue());
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    public static class Cell {
        public int row = 0;
        public int col = 0;
        public int rowspan = 1;
        public int colspan = 1;

        public Cell() {
        }

        public Cell(int row, int col) {
            this.row = row;
            this.col = col;
        }

        public Cell(int row, int col, int rowspan, int colspan) {
            this.row = row;
            this.col = col;
            this.rowspan = rowspan;
            this.colspan = colspan;
        }
    }

    public static enum Anchor {
        CENTER(10),
        NORTH(11),
        NORTHEAST(12),
        EAST(13),
        SOUTHEAST(14),
        SOUTH(15),
        SOUTHWEST(16),
        WEST(17),
        NORTHWEST(18),
        PAGE_START(19),
        PAGE_END(20),
        LINE_START(21),
        LINE_END(22),
        FIRST_LINE_START(23),
        FIRST_LINE_END(24),
        LAST_LINE_START(25),
        LAST_LINE_END(26),
        BASELINE(256),
        BASELINE_LEADING(512),
        BASELINE_TRAILING(26),
        ABOVE_BASELINE(1024),
        ABOVE_BASELINE_LEADING(1280),
        ABOVE_BASELINE_TRAILING(1536),
        BELOW_BASELINE(1792),
        BELOW_BASELINE_LEADING(2048),
        BELOW_BASELINE_TRAILING(2304);

        private final int value;

        private Anchor(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum Fill {
        NONE(0),
        HORIZONTAL(2),
        VERTICAL(3),
        BOTH(1);

        private final int value;

        private Fill(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

